/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.disk;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import me.desair.tus.server.exception.UploadAlreadyLockedException;
import me.desair.tus.server.upload.UploadLock;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedLock
implements UploadLock {
    private static final Logger log = LoggerFactory.getLogger(FileBasedLock.class);
    private String uploadUri;
    private FileChannel fileChannel = null;
    protected Path lockPath;

    public FileBasedLock(String uploadUri, Path lockPath) throws UploadAlreadyLockedException, IOException {
        Validate.notBlank((CharSequence)uploadUri, (String)"The upload URI cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)lockPath, (String)"The path to the lock cannot be null", (Object[])new Object[0]);
        this.uploadUri = uploadUri;
        this.lockPath = lockPath;
        this.tryToObtainFileLock();
    }

    private void tryToObtainFileLock() throws UploadAlreadyLockedException, IOException {
        String message = "The upload " + this.getUploadUri() + " is already locked";
        try {
            this.fileChannel = this.createFileChannel();
            FileLock fileLock = Utils.lockFileExclusively(this.fileChannel);
            if (fileLock == null) {
                this.fileChannel.close();
                throw new UploadAlreadyLockedException(message);
            }
        }
        catch (OverlappingFileLockException e) {
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new UploadAlreadyLockedException(message);
        }
        catch (IOException e) {
            throw new IOException("Unable to create or open file required to implement file-based locking", e);
        }
    }

    @Override
    public String getUploadUri() {
        return this.uploadUri;
    }

    @Override
    public void release() {
        try {
            this.fileChannel.close();
            Files.deleteIfExists(this.lockPath);
        }
        catch (IOException e) {
            log.warn("Unable to release file lock for URI " + this.getUploadUri(), (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.release();
    }

    protected FileChannel createFileChannel() throws IOException {
        return FileChannel.open(this.lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }
}

