/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.disk;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadAlreadyLockedException;
import me.desair.tus.server.upload.UploadId;
import me.desair.tus.server.upload.UploadIdFactory;
import me.desair.tus.server.upload.UploadLock;
import me.desair.tus.server.upload.UploadLockingService;
import me.desair.tus.server.upload.disk.AbstractDiskBasedService;
import me.desair.tus.server.upload.disk.FileBasedLock;
import org.apache.commons.lang3.Validate;

public class DiskLockingService
extends AbstractDiskBasedService
implements UploadLockingService {
    private static final String LOCK_SUB_DIRECTORY = "locks";
    private UploadIdFactory idFactory;

    public DiskLockingService(String storagePath) {
        super(storagePath + File.separator + LOCK_SUB_DIRECTORY);
    }

    public DiskLockingService(UploadIdFactory idFactory, String storagePath) {
        this(storagePath);
        Validate.notNull((Object)idFactory, (String)"The IdFactory cannot be null", (Object[])new Object[0]);
        this.idFactory = idFactory;
    }

    @Override
    public UploadLock lockUploadByUri(String requestUri) throws TusException, IOException {
        UploadId id = this.idFactory.readUploadId(requestUri);
        FileBasedLock lock = null;
        Path lockPath = this.getLockPath(id);
        if (lockPath != null) {
            lock = new FileBasedLock(requestUri, lockPath);
        }
        return lock;
    }

    @Override
    public void cleanupStaleLocks() throws IOException {
        try (DirectoryStream<Path> locksStream = Files.newDirectoryStream(this.getStoragePath());){
            for (Path path : locksStream) {
                UploadId id;
                FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                if (lastModifiedTime.toMillis() >= System.currentTimeMillis() - 10000L || this.isLocked(id = new UploadId((Serializable)((Object)path.getFileName().toString())))) continue;
                Files.deleteIfExists(path);
            }
        }
    }

    @Override
    public boolean isLocked(UploadId id) {
        boolean locked = false;
        Path lockPath = this.getLockPath(id);
        if (lockPath != null) {
            try (FileBasedLock lock = new FileBasedLock(id.toString(), lockPath);){
                locked = false;
            }
            catch (IOException | UploadAlreadyLockedException e) {
                locked = true;
            }
        }
        return locked;
    }

    @Override
    public void setIdFactory(UploadIdFactory idFactory) {
        Validate.notNull((Object)idFactory, (String)"The IdFactory cannot be null", (Object[])new Object[0]);
        this.idFactory = idFactory;
    }

    private Path getLockPath(UploadId id) {
        return this.getPathInStorageDirectory(id);
    }
}

