/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desair.tus.server.upload.UploadId;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class UploadIdFactory {
    private String uploadUri = "/";
    private Pattern uploadUriPattern = null;

    public void setUploadUri(String uploadUri) {
        Validate.notBlank((CharSequence)uploadUri, (String)"The upload URI pattern cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.startsWith((CharSequence)uploadUri, (CharSequence)"/"), (String)"The upload URI should start with /", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.endsWith((CharSequence)uploadUri, (CharSequence)"$") ? 1 : 0) != 0, (String)"The upload URI should not end with $", (Object[])new Object[0]);
        this.uploadUri = uploadUri;
        this.uploadUriPattern = null;
    }

    public String getUploadUri() {
        return this.uploadUri;
    }

    public UploadId readUploadId(String url) {
        Matcher uploadUriMatcher = this.getUploadUriPattern().matcher(StringUtils.trimToEmpty((String)url));
        String pathId = uploadUriMatcher.replaceFirst("");
        Serializable idValue = null;
        if (StringUtils.isNotBlank((CharSequence)pathId)) {
            idValue = this.getIdValueIfValid(pathId);
        }
        return idValue == null ? null : new UploadId(idValue);
    }

    public abstract UploadId createId();

    protected abstract Serializable getIdValueIfValid(String var1);

    protected Pattern getUploadUriPattern() {
        if (this.uploadUriPattern == null) {
            this.uploadUriPattern = Pattern.compile("^.*" + this.uploadUri + (StringUtils.endsWith((CharSequence)this.uploadUri, (CharSequence)"/") ? "" : "/?"));
        }
        return this.uploadUriPattern;
    }
}

