/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final int LOCK_FILE_RETRY_COUNT = 3;
    private static final long LOCK_FILE_SLEEP_TIME = 500L;

    private Utils() {
    }

    public static String getHeader(HttpServletRequest request, String header) {
        return StringUtils.trimToEmpty((String)request.getHeader(header));
    }

    public static Long getLongHeader(HttpServletRequest request, String header) {
        try {
            return Long.valueOf(Utils.getHeader(request, header));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String buildRemoteIpList(HttpServletRequest servletRequest) {
        String ipAddresses = servletRequest.getRemoteAddr();
        String xforwardedForHeader = Utils.getHeader(servletRequest, "X-Forwarded-For");
        if (xforwardedForHeader.length() > 0) {
            ipAddresses = xforwardedForHeader + ", " + ipAddresses;
        }
        return ipAddresses;
    }

    public static List<String> parseConcatenationIDsFromHeader(String uploadConcatValue) {
        LinkedList<String> output = new LinkedList<String>();
        String idString = StringUtils.substringAfter((String)uploadConcatValue, (String)";");
        for (String id : StringUtils.trimToEmpty((String)idString).split("\\s")) {
            output.add(id);
        }
        return output;
    }

    public static <T> T readSerializable(Path path, Class<T> clazz) throws IOException {
        Object info;
        block28: {
            info = null;
            if (path != null) {
                try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
                    if (Utils.lockFileShared(channel) != null) {
                        try (ObjectInputStream ois = new ObjectInputStream(Channels.newInputStream(channel));){
                            info = clazz.cast(ois.readObject());
                            break block28;
                        }
                        catch (ClassNotFoundException e) {
                            info = null;
                        }
                        break block28;
                    }
                    throw new IOException("Unable to lock file " + path);
                }
            }
        }
        return info;
    }

    public static void writeSerializable(Serializable object, Path path) throws IOException {
        block38: {
            if (path != null) {
                try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    if (Utils.lockFileExclusively(channel) != null) {
                        try (BufferedOutputStream buffer = new BufferedOutputStream(Channels.newOutputStream(channel));
                             ObjectOutputStream output = new ObjectOutputStream(buffer);){
                            output.writeObject(object);
                            break block38;
                        }
                    }
                    throw new IOException("Unable to lock file " + path);
                }
            }
        }
    }

    public static FileLock lockFileExclusively(FileChannel channel) throws IOException {
        return Utils.lockFile(channel, false);
    }

    public static FileLock lockFileShared(FileChannel channel) throws IOException {
        return Utils.lockFile(channel, true);
    }

    public static void sleep(long sleepTimeMillis) {
        try {
            Thread.sleep(sleepTimeMillis);
        }
        catch (InterruptedException e) {
            log.warn("Sleep was interrupted");
            Thread.currentThread().interrupt();
        }
    }

    private static FileLock lockFile(FileChannel channel, boolean shared) throws IOException {
        int i = 0;
        FileLock lock = null;
        do {
            if (i <= 0) continue;
            Utils.sleep(500L);
        } while ((lock = channel.tryLock(0L, Long.MAX_VALUE, shared)) == null && ++i < 3);
        return lock;
    }
}

