/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadNotFoundException;
import me.desair.tus.server.upload.UploadId;
import me.desair.tus.server.upload.UploadIdFactory;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadLockingService;
import me.desair.tus.server.upload.concatenation.UploadConcatenationService;

public interface UploadStorageService {
    public UploadInfo getUploadInfo(String var1, String var2) throws IOException;

    public UploadInfo getUploadInfo(UploadId var1) throws IOException;

    public String getUploadURI();

    public UploadInfo append(UploadInfo var1, InputStream var2) throws IOException, TusException;

    public void setMaxUploadSize(Long var1);

    public long getMaxUploadSize();

    public UploadInfo create(UploadInfo var1, String var2) throws IOException;

    public void update(UploadInfo var1) throws IOException, UploadNotFoundException;

    public InputStream getUploadedBytes(String var1, String var2) throws IOException, UploadNotFoundException;

    public InputStream getUploadedBytes(UploadId var1) throws IOException, UploadNotFoundException;

    public void copyUploadTo(UploadInfo var1, OutputStream var2) throws UploadNotFoundException, IOException;

    public void cleanupExpiredUploads(UploadLockingService var1) throws IOException;

    public void removeLastNumberOfBytes(UploadInfo var1, long var2) throws UploadNotFoundException, IOException;

    public void terminateUpload(UploadInfo var1) throws UploadNotFoundException, IOException;

    public Long getUploadExpirationPeriod();

    public void setUploadExpirationPeriod(Long var1);

    public void setUploadConcatenationService(UploadConcatenationService var1);

    public UploadConcatenationService getUploadConcatenationService();

    public void setIdFactory(UploadIdFactory var1);
}

