/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.core;

import java.io.IOException;
import java.util.Objects;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.upload.UploadType;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;

public class CoreHeadRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.HEAD.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException {
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (!UploadType.CONCATENATED.equals((Object)uploadInfo.getUploadType())) {
            if (uploadInfo.hasLength()) {
                servletResponse.setHeader("Upload-Length", Objects.toString(uploadInfo.getLength()));
            }
            servletResponse.setHeader("Upload-Offset", Objects.toString(uploadInfo.getOffset()));
        }
        servletResponse.setHeader("Cache-Control", "no-store");
        servletResponse.setStatus(204);
    }
}

