package me.desair.tus.server;

import java.io.IOException;

import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;

public interface RequestHandler {

    boolean supports(HttpMethod method);

    void process(HttpMethod method, TusServletRequest servletRequest,
                 TusServletResponse servletResponse, UploadStorageService uploadStorageService,
                 String ownerKey) throws IOException, TusException;

    boolean isErrorHandler();

}
