/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.igp.internal;

import java.util.Optional;
import javax.inject.Inject;
import me.champeau.gradle.igp.Authentication;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;

public class DefaultAuthentication
implements Authentication {
    private final ObjectFactory objects;
    private Authentication.KeyConfiguration keyConfiguration;
    private Authentication.BasicAuth basicAuth;
    private Authentication.WithPassword sshWithPassword;

    @Inject
    public DefaultAuthentication(ObjectFactory objects) {
        this.objects = objects;
    }

    @Override
    public void none() {
        this.keyConfiguration = null;
        this.basicAuth = null;
        this.sshWithPassword = null;
    }

    @Override
    public void basic(Action<? super Authentication.BasicAuth> spec) {
        this.none();
        this.basicAuth = (Authentication.BasicAuth)this.objects.newInstance(Authentication.BasicAuth.class, new Object[0]);
        spec.execute((Object)this.basicAuth);
    }

    @Override
    public void sshWithPublicKey(Action<? super Authentication.KeyConfiguration> spec) {
        this.none();
        this.keyConfiguration = (Authentication.KeyConfiguration)this.objects.newInstance(Authentication.KeyConfiguration.class, new Object[0]);
        spec.execute((Object)this.keyConfiguration);
    }

    @Override
    public void sshWithPassword(Action<? super Authentication.WithPassword> spec) {
        this.none();
        this.sshWithPassword = (Authentication.WithPassword)this.objects.newInstance(Authentication.WithPassword.class, new Object[0]);
        spec.execute((Object)this.sshWithPassword);
    }

    Optional<Authentication.KeyConfiguration> getSshWithPublicKey() {
        return Optional.ofNullable(this.keyConfiguration);
    }

    Optional<Authentication.BasicAuth> getBasicAuth() {
        return Optional.ofNullable(this.basicAuth);
    }

    Optional<Authentication.WithPassword> getSshWithPassword() {
        return Optional.ofNullable(this.sshWithPassword);
    }
}

