/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import java.lang.reflect.Method;
import ly.count.android.sdk.DeviceId;

public class MessagingAdapter {
    private static final String TAG = "MessagingAdapter";
    private static final String MESSAGING_CLASS_NAME = "ly.count.android.sdk.messaging.CountlyMessaging";

    public static boolean isMessagingAvailable() {
        boolean messagingAvailable = false;
        try {
            Class.forName(MESSAGING_CLASS_NAME);
            messagingAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return messagingAvailable;
    }

    public static boolean init(Activity activity, Class<? extends Activity> activityClass, String sender, String[] buttonNames, Boolean disableUI) {
        try {
            Class<?> cls = Class.forName(MESSAGING_CLASS_NAME);
            Method method = cls.getMethod("init", Activity.class, Class.class, String.class, String[].class, Boolean.class);
            method.invoke(null, activity, activityClass, sender, buttonNames, disableUI);
            return true;
        }
        catch (Throwable logged) {
            Log.e((String)TAG, (String)"Couldn't init Countly Messaging", (Throwable)logged);
            return false;
        }
    }

    public static boolean storeConfiguration(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode) {
        try {
            Class<?> cls = Class.forName(MESSAGING_CLASS_NAME);
            Method method = cls.getMethod("storeConfiguration", Context.class, String.class, String.class, String.class, DeviceId.Type.class);
            method.invoke(null, new Object[]{context, serverURL, appKey, deviceID, idMode});
            return true;
        }
        catch (Throwable logged) {
            Log.e((String)TAG, (String)"Couldn't store configuration in Countly Messaging", (Throwable)logged);
            return false;
        }
    }
}

