/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.content.Context;
import android.util.Log;
import ly.count.android.sdk.AdvertisingIdAdapter;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.OpenUDIDAdapter;

public class DeviceId {
    private static final String TAG = "DeviceId";
    private static final String PREFERENCE_KEY_ID_ID = "ly.count.android.api.DeviceId.id";
    private static final String PREFERENCE_KEY_ID_TYPE = "ly.count.android.api.DeviceId.type";
    private static final String PREFERENCE_KEY_ID_ROLLBACK_ID = "ly.count.android.api.DeviceId.rollback.id";
    private static final String PREFERENCE_KEY_ID_ROLLBACK_TYPE = "ly.count.android.api.DeviceId.rollback.type";
    private String id;
    private Type type;

    public DeviceId(CountlyStore store, Type type) {
        if (type == null) {
            throw new IllegalStateException("Please specify DeviceId.Type, that is which type of device ID generation you want to use");
        }
        if (type == Type.DEVELOPER_SUPPLIED) {
            throw new IllegalStateException("Please use another DeviceId constructor for device IDs supplied by developer");
        }
        this.type = type;
        this.retrieveId(store);
    }

    public DeviceId(CountlyStore store, String developerSuppliedId) {
        if (developerSuppliedId == null || "".equals(developerSuppliedId)) {
            throw new IllegalStateException("Please make sure that device ID is not null or empty");
        }
        this.type = Type.DEVELOPER_SUPPLIED;
        this.id = developerSuppliedId;
        this.retrieveId(store);
    }

    private void retrieveId(CountlyStore store) {
        String storedId = store.getPreference(PREFERENCE_KEY_ID_ID);
        if (storedId != null) {
            this.id = storedId;
            this.type = this.retrieveType(store, PREFERENCE_KEY_ID_TYPE);
        }
    }

    public void init(Context context, CountlyStore store, boolean raiseExceptions) {
        Type overriddenType = this.retrieveOverriddenType(store);
        if (overriddenType != null && overriddenType != this.type) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)("Overridden device ID generation strategy detected: " + (Object)((Object)overriddenType) + ", using it instead of " + (Object)((Object)this.type)));
            }
            this.type = overriddenType;
        }
        switch (this.type) {
            case DEVELOPER_SUPPLIED: {
                break;
            }
            case OPEN_UDID: {
                if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.i((String)TAG, (String)"Using OpenUDID");
                    }
                    if (OpenUDIDAdapter.isInitialized()) break;
                    OpenUDIDAdapter.sync(context);
                    break;
                }
                if (!raiseExceptions) break;
                throw new IllegalStateException("OpenUDID is not available, please make sure that you have it in your classpath");
            }
            case ADVERTISING_ID: {
                if (AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.i((String)TAG, (String)"Using Advertising ID");
                    }
                    AdvertisingIdAdapter.setAdvertisingId(context, store, this);
                    break;
                }
                if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.i((String)TAG, (String)"Advertising ID is not available, falling back to OpenUDID");
                    }
                    if (OpenUDIDAdapter.isInitialized()) break;
                    OpenUDIDAdapter.sync(context);
                    break;
                }
                if (Countly.sharedInstance().isLoggingEnabled()) {
                    Log.w((String)TAG, (String)"Advertising ID is not available, neither OpenUDID is");
                }
                if (!raiseExceptions) break;
                throw new IllegalStateException("OpenUDID is not available, please make sure that you have it in your classpath");
            }
        }
    }

    private void storeOverriddenType(CountlyStore store, Type type) {
        store.setPreference(PREFERENCE_KEY_ID_TYPE, type == null ? null : type.toString());
    }

    private Type retrieveOverriddenType(CountlyStore store) {
        return this.retrieveType(store, PREFERENCE_KEY_ID_TYPE);
    }

    private Type retrieveType(CountlyStore store, String preferenceName) {
        String typeString = store.getPreference(preferenceName);
        if (typeString == null) {
            return null;
        }
        if (typeString.equals(Type.DEVELOPER_SUPPLIED.toString())) {
            return Type.DEVELOPER_SUPPLIED;
        }
        if (typeString.equals(Type.OPEN_UDID.toString())) {
            return Type.OPEN_UDID;
        }
        if (typeString.equals(Type.ADVERTISING_ID.toString())) {
            return Type.ADVERTISING_ID;
        }
        return null;
    }

    public String getId() {
        if (this.id == null && this.type == Type.OPEN_UDID) {
            this.id = OpenUDIDAdapter.getOpenUDID();
        }
        return this.id;
    }

    protected void setId(Type type, String id2) {
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.w((String)TAG, (String)("Device ID is " + id2 + " (type " + (Object)((Object)type) + ")"));
        }
        this.type = type;
        this.id = id2;
    }

    protected void switchToIdType(Type type, Context context, CountlyStore store) {
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.w((String)TAG, (String)("Switching to device ID generation strategy " + (Object)((Object)type) + " from " + (Object)((Object)this.type)));
        }
        this.type = type;
        this.storeOverriddenType(store, type);
        this.init(context, store, false);
    }

    protected String changeToDeveloperId(CountlyStore store, String newId) {
        if (this.id != null && this.type != null && this.type != Type.DEVELOPER_SUPPLIED) {
            store.setPreference(PREFERENCE_KEY_ID_ROLLBACK_ID, this.id);
            store.setPreference(PREFERENCE_KEY_ID_ROLLBACK_TYPE, this.type.toString());
        }
        String oldId = this.id == null || !this.id.equals(newId) ? this.id : null;
        this.id = newId;
        this.type = Type.DEVELOPER_SUPPLIED;
        store.setPreference(PREFERENCE_KEY_ID_ID, this.id);
        store.setPreference(PREFERENCE_KEY_ID_TYPE, this.type.toString());
        return oldId;
    }

    public void changeToId(Context context, CountlyStore store, Type type, String deviceId) {
        this.id = deviceId;
        this.type = type;
        store.setPreference(PREFERENCE_KEY_ID_ID, deviceId);
        store.setPreference(PREFERENCE_KEY_ID_TYPE, type.toString());
        this.init(context, store, false);
    }

    protected String revertFromDeveloperId(CountlyStore store) {
        store.setPreference(PREFERENCE_KEY_ID_ID, null);
        store.setPreference(PREFERENCE_KEY_ID_TYPE, null);
        String i = store.getPreference(PREFERENCE_KEY_ID_ROLLBACK_ID);
        Type t = this.retrieveType(store, PREFERENCE_KEY_ID_ROLLBACK_TYPE);
        String oldId = null;
        if (i != null && t != null) {
            oldId = this.id == null || !this.id.equals(i) ? this.id : null;
            this.id = i;
            this.type = t;
            store.setPreference(PREFERENCE_KEY_ID_ROLLBACK_ID, null);
            store.setPreference(PREFERENCE_KEY_ID_ROLLBACK_TYPE, null);
        }
        return oldId;
    }

    public Type getType() {
        return this.type;
    }

    static boolean deviceIDEqualsNullSafe(String id2, Type type, DeviceId deviceId) {
        if (type == null || type == Type.DEVELOPER_SUPPLIED) {
            String deviceIdId = deviceId == null ? null : deviceId.getId();
            return deviceIdId == null && id2 == null || deviceIdId != null && deviceIdId.equals(id2);
        }
        return true;
    }

    public static enum Type {
        DEVELOPER_SUPPLIED,
        OPEN_UDID,
        ADVERTISING_ID;

    }
}

