/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.os.Build;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.DeviceId;
import ly.count.android.sdk.UserData;

public class ConnectionProcessor
implements Runnable {
    private static final int CONNECT_TIMEOUT_IN_MILLISECONDS = 30000;
    private static final int READ_TIMEOUT_IN_MILLISECONDS = 30000;
    private final CountlyStore store_;
    private final DeviceId deviceId_;
    private final String serverURL_;
    private final SSLContext sslContext_;
    protected static String salt;
    private static final char[] hexArray;

    ConnectionProcessor(String serverURL, CountlyStore store, DeviceId deviceId, SSLContext sslContext) {
        this.serverURL_ = serverURL;
        this.store_ = store;
        this.deviceId_ = deviceId;
        this.sslContext_ = sslContext;
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    URLConnection urlConnectionForEventData(String eventData) throws IOException {
        HttpURLConnection conn;
        String urlStr = this.serverURL_ + "/i?";
        if (!eventData.contains("&crash=") && eventData.length() < 2048) {
            urlStr = urlStr + eventData;
            urlStr = urlStr + "&checksum=" + ConnectionProcessor.sha1Hash(eventData + salt);
        } else {
            urlStr = urlStr + "checksum=" + ConnectionProcessor.sha1Hash(eventData + salt);
        }
        URL url = new URL(urlStr);
        if (Countly.publicKeyPinCertificates == null && Countly.certificatePinCertificates == null) {
            conn = (HttpURLConnection)url.openConnection();
        } else {
            HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
            c.setSSLSocketFactory(this.sslContext_.getSocketFactory());
            conn = c;
        }
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setRequestMethod("GET");
        String picturePath = UserData.getPicturePathFromQuery(url);
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.d((String)"Countly", (String)("Got picturePath: " + picturePath));
        }
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.v((String)"Countly", (String)("Is the HTTP POST forced: " + Countly.sharedInstance().isHttpPostForced()));
        }
        if (!picturePath.equals("")) {
            File binaryFile = new File(picturePath);
            conn.setDoOutput(true);
            String boundary = Long.toHexString(System.currentTimeMillis());
            String CRLF = "\r\n";
            String charset = "UTF-8";
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream output = conn.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);
            writer.append("--" + boundary).append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"binaryFile\"; filename=\"" + binaryFile.getName() + "\"").append(CRLF);
            writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(binaryFile.getName())).append(CRLF);
            writer.append("Content-Transfer-Encoding: binary").append(CRLF);
            writer.append(CRLF).flush();
            FileInputStream fileInputStream = new FileInputStream(binaryFile);
            byte[] buffer = new byte[1024];
            try {
                int len;
                while ((len = fileInputStream.read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            output.flush();
            writer.append(CRLF).flush();
            fileInputStream.close();
            writer.append("--" + boundary + "--").append(CRLF).flush();
        } else if (eventData.contains("&crash=") || eventData.length() >= 2048 || Countly.sharedInstance().isHttpPostForced()) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.d((String)"Countly", (String)"Using HTTP POST");
            }
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(eventData);
            writer.flush();
            writer.close();
            os.close();
        } else {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.d((String)"Countly", (String)"Using HTTP GET");
            }
            conn.setDoOutput(false);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] storedEvents;
        while ((storedEvents = this.store_.connections()) != null && storedEvents.length != 0) {
            String newId;
            String eventData;
            if (this.deviceId_.getId() == null) {
                if (!Countly.sharedInstance().isLoggingEnabled()) break;
                Log.i((String)"Countly", (String)("No Device ID available yet, skipping request " + storedEvents[0]));
                break;
            }
            boolean deviceIdOverride = storedEvents[0].contains("&override_id=");
            boolean deviceIdChange = storedEvents[0].contains("&device_id=");
            if (deviceIdOverride) {
                eventData = storedEvents[0].replace("&override_id=", "&device_id=");
                newId = null;
            } else if (deviceIdChange) {
                newId = storedEvents[0].substring(storedEvents[0].indexOf("&device_id=") + "&device_id=".length());
                if (newId.equals(this.deviceId_.getId())) {
                    eventData = storedEvents[0];
                    deviceIdChange = false;
                } else {
                    eventData = storedEvents[0] + "&old_device_id=" + this.deviceId_.getId();
                }
            } else {
                newId = null;
                eventData = storedEvents[0] + "&device_id=" + this.deviceId_.getId();
            }
            if (!Countly.sharedInstance().isDeviceAppCrawler() || !Countly.sharedInstance().ifShouldIgnoreCrawlers()) {
                URLConnection conn = null;
                try {
                    int responseCode;
                    conn = this.urlConnectionForEventData(eventData);
                    conn.connect();
                    boolean success = true;
                    if (conn instanceof HttpURLConnection) {
                        HttpURLConnection httpConn = (HttpURLConnection)conn;
                        responseCode = httpConn.getResponseCode();
                        boolean bl = success = responseCode >= 200 && responseCode < 300;
                        if (!success && Countly.sharedInstance().isLoggingEnabled()) {
                            Log.w((String)"Countly", (String)("HTTP error response code was " + responseCode + " from submitting event data: " + eventData));
                        }
                    } else {
                        responseCode = 0;
                    }
                    if (success) {
                        if (Countly.sharedInstance().isLoggingEnabled()) {
                            Log.d((String)"Countly", (String)("ok ->" + eventData));
                        }
                        this.store_.removeConnection(storedEvents[0]);
                        if (!deviceIdChange) continue;
                        this.deviceId_.changeToDeveloperId(this.store_, newId);
                        continue;
                    }
                    if (responseCode < 400 || responseCode >= 500) break;
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.d((String)"Countly", (String)("fail " + responseCode + " ->" + eventData));
                    }
                    this.store_.removeConnection(storedEvents[0]);
                    continue;
                }
                catch (Exception e) {
                    if (!Countly.sharedInstance().isLoggingEnabled()) break;
                    Log.w((String)"Countly", (String)("Got exception while trying to submit event data: " + eventData), (Throwable)e);
                    break;
                }
                finally {
                    if (conn != null && conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).disconnect();
                    }
                    continue;
                }
            }
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)"Countly", (String)("Device identified as a app crawler, skipping request " + storedEvents[0]));
            }
            this.store_.removeConnection(storedEvents[0]);
        }
    }

    private static String sha1Hash(String toHash) {
        String hash;
        block2: {
            hash = null;
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] bytes = toHash.getBytes("UTF-8");
                digest.update(bytes, 0, bytes.length);
                bytes = digest.digest();
                hash = ConnectionProcessor.bytesToHex(bytes);
            }
            catch (Throwable e) {
                if (!Countly.sharedInstance().isLoggingEnabled()) break block2;
                Log.e((String)"Countly", (String)"Cannot tamper-protect params", (Throwable)e);
            }
        }
        return hash;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars).toLowerCase();
    }

    String getServerURL() {
        return this.serverURL_;
    }

    CountlyStore getCountlyStore() {
        return this.store_;
    }

    DeviceId getDeviceId() {
        return this.deviceId_;
    }

    static {
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

