/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class CertificateTrustManager
implements X509TrustManager {
    private final List<byte[]> keys;
    private final List<byte[]> certificates;

    public CertificateTrustManager(List<String> keys, List<String> certs) throws CertificateException {
        CertificateFactory cf;
        if (!(keys != null && keys.size() != 0 || certs != null && certs.size() != 0)) {
            throw new IllegalArgumentException("You must specify non-empty keys list or certs list");
        }
        this.keys = new ArrayList<byte[]>();
        if (keys != null) {
            for (String key : keys) {
                cf = CertificateFactory.getInstance("X.509");
                Certificate cert = cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)key, (int)0)));
                this.keys.add(cert.getPublicKey().getEncoded());
            }
        }
        this.certificates = new ArrayList<byte[]>();
        if (certs != null) {
            for (String cert : certs) {
                cf = CertificateFactory.getInstance("X.509");
                Certificate certificate = cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)cert, (int)0)));
                this.certificates.add(certificate.getEncoded());
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null) {
            throw new IllegalArgumentException("PublicKeyManager: X509Certificate array is null");
        }
        if (chain.length <= 0) {
            throw new IllegalArgumentException("PublicKeyManager: X509Certificate is empty");
        }
        if (null == authType || !authType.contains("RSA")) {
            throw new CertificateException("PublicKeyManager: AuthType is not RSA");
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init((KeyStore)null);
            for (TrustManager trustManager : tmf.getTrustManagers()) {
                ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
            }
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        byte[] serverPublicKey = chain[0].getPublicKey().getEncoded();
        byte[] serverCertificate = chain[0].getEncoded();
        for (byte[] key : this.keys) {
            if (!Arrays.equals(key, serverPublicKey)) continue;
            return;
        }
        for (byte[] key : this.certificates) {
            if (!Arrays.equals(key, serverCertificate)) continue;
            return;
        }
        throw new CertificateException("Public keys didn't pass checks");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

