/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.content.Context;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import ly.count.android.sdk.CertificateTrustManager;
import ly.count.android.sdk.ConnectionProcessor;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.CrashDetails;
import ly.count.android.sdk.DeviceId;
import ly.count.android.sdk.DeviceInfo;
import ly.count.android.sdk.UserData;

public class ConnectionQueue {
    private CountlyStore store_;
    private ExecutorService executor_;
    private String appKey_;
    private Context context_;
    private String serverURL_;
    private Future<?> connectionProcessorFuture_;
    private DeviceId deviceId_;
    private SSLContext sslContext_;

    String getAppKey() {
        return this.appKey_;
    }

    void setAppKey(String appKey) {
        this.appKey_ = appKey;
    }

    Context getContext() {
        return this.context_;
    }

    void setContext(Context context) {
        this.context_ = context;
    }

    String getServerURL() {
        return this.serverURL_;
    }

    void setServerURL(String serverURL) {
        this.serverURL_ = serverURL;
        if (Countly.publicKeyPinCertificates == null) {
            this.sslContext_ = null;
        } else {
            try {
                TrustManager[] tm = new TrustManager[]{new CertificateTrustManager(Countly.publicKeyPinCertificates)};
                this.sslContext_ = SSLContext.getInstance("TLS");
                this.sslContext_.init(null, tm, null);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }

    CountlyStore getCountlyStore() {
        return this.store_;
    }

    void setCountlyStore(CountlyStore countlyStore) {
        this.store_ = countlyStore;
    }

    DeviceId getDeviceId() {
        return this.deviceId_;
    }

    public void setDeviceId(DeviceId deviceId) {
        this.deviceId_ = deviceId;
    }

    void checkInternalState() {
        if (this.context_ == null) {
            throw new IllegalStateException("context has not been set");
        }
        if (this.appKey_ == null || this.appKey_.length() == 0) {
            throw new IllegalStateException("app key has not been set");
        }
        if (this.store_ == null) {
            throw new IllegalStateException("countly store has not been set");
        }
        if (this.serverURL_ == null || !Countly.isValidURL(this.serverURL_)) {
            throw new IllegalStateException("server URL is not valid");
        }
        if (Countly.publicKeyPinCertificates != null && !this.serverURL_.startsWith("https")) {
            throw new IllegalStateException("server must start with https once you specified public keys");
        }
    }

    void beginSession() {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&sdk_version=" + "15.08.01" + "&begin_session=1" + "&metrics=" + DeviceInfo.getMetrics(this.context_);
        this.store_.addConnection(data);
        this.tick();
    }

    void updateSession(int duration) {
        this.checkInternalState();
        if (duration > 0) {
            String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&session_duration=" + duration + "&location=" + this.getCountlyStore().getAndRemoveLocation();
            this.store_.addConnection(data);
            this.tick();
        }
    }

    public void tokenSession(String token, Countly.CountlyMessagingMode mode) {
        this.checkInternalState();
        final String data = "app_key=" + this.appKey_ + "&" + "timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&" + "token_session=1" + "&" + "android_token=" + token + "&" + "test_mode=" + (mode == Countly.CountlyMessagingMode.TEST ? 2 : 0) + "&" + "locale=" + DeviceInfo.getLocale();
        ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
        worker.schedule(new Runnable(){

            @Override
            public void run() {
                ConnectionQueue.this.store_.addConnection(data);
                ConnectionQueue.this.tick();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    void endSession(int duration) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&end_session=1";
        if (duration > 0) {
            data = data + "&session_duration=" + duration;
        }
        this.store_.addConnection(data);
        this.tick();
    }

    void sendUserData() {
        this.checkInternalState();
        String userdata = UserData.getDataForRequest();
        if (!userdata.equals("")) {
            String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + userdata;
            this.store_.addConnection(data);
            this.tick();
        }
    }

    void sendReferrerData(String referrer) {
        this.checkInternalState();
        if (referrer != null) {
            String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + referrer;
            this.store_.addConnection(data);
            this.tick();
        }
    }

    void sendCrashReport(String error, boolean nonfatal) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&sdk_version=" + "15.08.01" + "&crash=" + CrashDetails.getCrashData(this.context_, error, nonfatal);
        this.store_.addConnection(data);
        this.tick();
    }

    void recordEvents(String events) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&events=" + events;
        this.store_.addConnection(data);
        this.tick();
    }

    void recordLocation(String events) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&timestamp=" + Countly.currentTimestamp() + "&hour=" + Countly.currentHour() + "&dow=" + Countly.currentDayOfWeek() + "&events=" + events;
        this.store_.addConnection(data);
        this.tick();
    }

    void ensureExecutor() {
        if (this.executor_ == null) {
            this.executor_ = Executors.newSingleThreadExecutor();
        }
    }

    void tick() {
        if (!this.store_.isEmptyConnections() && (this.connectionProcessorFuture_ == null || this.connectionProcessorFuture_.isDone())) {
            this.ensureExecutor();
            this.connectionProcessorFuture_ = this.executor_.submit(new ConnectionProcessor(this.serverURL_, this.store_, this.deviceId_, this.sslContext_));
        }
    }

    ExecutorService getExecutor() {
        return this.executor_;
    }

    void setExecutor(ExecutorService executor) {
        this.executor_ = executor;
    }

    Future<?> getConnectionProcessorFuture() {
        return this.connectionProcessorFuture_;
    }

    void setConnectionProcessorFuture(Future<?> connectionProcessorFuture) {
        this.connectionProcessorFuture_ = connectionProcessorFuture;
    }
}

