/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.virtualbackground;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;
import org.webrtc.YuvHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJH\u0010'\u001a\u0004\u0018\u00010(2\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\r0*j\b\u0012\u0004\u0012\u00020\r`+2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\n0*j\b\u0012\u0004\u0012\u00020\n`+2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010-\u001a\u0004\u0018\u00010\u00162\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0006J\u0010\u00101\u001a\u0004\u0018\u00010\b2\u0006\u00102\u001a\u00020\rJH\u00103\u001a\u0004\u0018\u00010(2\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\r0*j\b\u0012\u0004\u0012\u00020\r`+2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\n0*j\b\u0012\u0004\u0012\u00020\n`+2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u00104\u001a\u0004\u0018\u00010\r2\u0006\u00105\u001a\u000206J\u001e\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\u0018\u0010;\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\u0016J\u0016\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\nJ\u001e\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\nJ\u000e\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020%J\u0010\u0010F\u001a\u0004\u0018\u00010\r2\u0006\u0010E\u001a\u00020%J \u0010G\u001a\u0004\u0018\u00010%2\u0006\u0010H\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ&\u0010I\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Llive/hms/video/virtualbackground/HMSVBUtils;", "", "()V", "FOREGROUND_THRESHOLD", "", "TAG", "", "YUV_420_888toNV21", "", "width", "", "height", "yBuffer", "Ljava/nio/ByteBuffer;", "strideY", "uBuffer", "strideU", "vBuffer", "strideV", "bitmapToI420", "", "src", "Landroid/graphics/Bitmap;", "dest", "Lorg/webrtc/JavaI420Buffer;", "blendChannelOverlay", "A", "B", "compressByteArray", "bytes", "convertToMutable", "imgIn", "createNV21Buffer", "i420Buffer", "Lorg/webrtc/VideoFrame$I420Buffer;", "decodeYUV420SP", "rgb", "", "yuv420sp", "fastI420ToYuvImage", "Landroid/graphics/YuvImage;", "yuvPlanes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "yuvStrides", "getBitmapFromAsset", "context", "Landroid/content/Context;", "filename", "getByteArrayFromByteBuffer", "byteBuffer", "i420ToYuvImage", "imageToByteBuffer", "image", "Landroid/media/Image;", "maskColorsFromByteBuffer", "segmentationMask", "maskWidth", "maskHeight", "overlay", "dst", "resizeBitmap", "source", "maxLength", "scale", "bitmap", "maxWidth", "maxHeight", "toByteArray", "array", "toByteBuffer", "yuv2rgb", "yuv", "yuvByteArrayToBitmap", "virtualBackground_release"})
public final class HMSVBUtils {
    @NotNull
    public static final HMSVBUtils INSTANCE = new HMSVBUtils();
    @NotNull
    private static final String TAG = "VBUtils";
    private static final double FOREGROUND_THRESHOLD = 0.9;

    private HMSVBUtils() {
    }

    @NotNull
    public final byte[] toByteArray(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        byte[] res = new byte[array.length];
        for (int value : array) {
            res[i] = (byte)value;
        }
        return res;
    }

    @Nullable
    public final ByteBuffer toByteBuffer(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        ByteBuffer buffer = ByteBuffer.allocateDirect(array.length);
        buffer.put(this.toByteArray(array));
        buffer.rewind();
        return buffer;
    }

    @Nullable
    public final byte[] getByteArrayFromByteBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        byte[] bytesArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytesArray, 0, bytesArray.length);
        return bytesArray;
    }

    @NotNull
    public final Bitmap resizeBitmap(@NotNull Bitmap source, int maxLength) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            Bitmap bitmap2;
            if (source.getHeight() >= source.getWidth()) {
                if (source.getHeight() <= maxLength) {
                    return source;
                }
                double aspectRatio = (double)source.getWidth() / (double)source.getHeight();
                int targetWidth = (int)((double)maxLength * aspectRatio);
                bitmap2 = Bitmap.createScaledBitmap((Bitmap)source, (int)targetWidth, (int)maxLength, (boolean)false);
            } else {
                if (source.getWidth() <= maxLength) {
                    return source;
                }
                double aspectRatio = (double)source.getHeight() / (double)source.getWidth();
                int targetHeight = (int)((double)maxLength * aspectRatio);
                bitmap2 = Bitmap.createScaledBitmap((Bitmap)source, (int)maxLength, (int)targetHeight, (boolean)false);
            }
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n            if (source\u2026)\n            }\n        }");
            bitmap = bitmap2;
        }
        catch (Exception e) {
            bitmap = source;
        }
        return bitmap;
    }

    @NotNull
    public final Bitmap scale(@NotNull Bitmap bitmap, int maxWidth, int maxHeight) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = 0;
        int height = 0;
        float widthRatio = (float)bitmap.getWidth() / (float)maxWidth;
        float heightRatio = (float)bitmap.getHeight() / (float)maxHeight;
        if (widthRatio >= heightRatio) {
            width = maxWidth;
            height = (int)((float)width / (float)bitmap.getWidth() * (float)bitmap.getHeight());
        } else {
            height = maxHeight;
            width = (int)((float)height / (float)bitmap.getHeight() * (float)bitmap.getWidth());
        }
        Bitmap scaledBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float ratioX = (float)width / (float)bitmap.getWidth();
        float ratioY = (float)height / (float)bitmap.getHeight();
        float middleX = (float)width / 2.0f;
        float middleY = (float)height / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bitmap, middleX - (float)(bitmap.getWidth() / 2), middleY - (float)(bitmap.getHeight() / 2), new Paint(2));
        Intrinsics.checkNotNullExpressionValue((Object)scaledBitmap, (String)"scaledBitmap");
        return scaledBitmap;
    }

    public final void bitmapToI420(@NotNull Bitmap src, @NotNull JavaI420Buffer dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int width = src.getWidth();
        int height = src.getHeight();
        if (width != dest.getWidth() || height != dest.getHeight()) {
            return;
        }
        int strideY = dest.getStrideY();
        int strideU = dest.getStrideU();
        int strideV = dest.getStrideV();
        ByteBuffer dataY = dest.getDataY();
        ByteBuffer dataU = dest.getDataU();
        ByteBuffer dataV = dest.getDataV();
        for (int line = 0; line < height; ++line) {
            byte b;
            byte g;
            byte r;
            int px;
            int x;
            if (line % 2 == 0) {
                for (x = 0; x < width; x += 2) {
                    px = src.getPixel(x, line);
                    r = (byte)(px >> 16 & 0xFF);
                    g = (byte)(px >> 8 & 0xFF);
                    b = (byte)(px & 0xFF);
                    dataY.put(line * strideY + x, (byte)((66 * r + 129 * g + 25 * b >> 8) + 16));
                    dataU.put(line / 2 * strideU + x / 2, (byte)((-38 * r + -74 * g + 112 * b >> 8) + 128));
                    dataV.put(line / 2 * strideV + x / 2, (byte)((112 * r + -94 * g + -18 * b >> 8) + 128));
                    px = src.getPixel(x + 1, line);
                    r = (byte)(px >> 16 & 0xFF);
                    g = (byte)(px >> 8 & 0xFF);
                    b = (byte)(px & 0xFF);
                    dataY.put(line * strideY + x, (byte)((66 * r + 129 * g + 25 * b >> 8) + 16));
                }
                continue;
            }
            for (x = 0; x < width; ++x) {
                px = src.getPixel(x, line);
                r = (byte)(px >> 16 & 0xFF);
                g = (byte)(px >> 8 & 0xFF);
                b = (byte)(px & 0xFF);
                dataY.put(line * strideY + x, (byte)((66 * r + 129 * g + 25 * b >> 8) + 16));
            }
        }
    }

    @Nullable
    public final ByteBuffer imageToByteBuffer(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Rect rect = image.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"image.getCropRect()");
        Rect crop = rect;
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planeArray = image.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeArray, (String)"image.getPlanes()");
        Image.Plane[] planes = planeArray;
        byte[] rowData = new byte[planes[0].getRowStride()];
        int bufferSize = width * height * ImageFormat.getBitsPerPixel((int)35) / 8;
        ByteBuffer output = ByteBuffer.allocateDirect(bufferSize);
        int channelOffset = 0;
        int outputStride = 0;
        for (int planeIndex = 0; planeIndex < 3; ++planeIndex) {
            ByteBuffer buffer;
            switch (planeIndex) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)planes[planeIndex].getBuffer(), (String)"planes[planeIndex].getBuffer()");
            int rowStride = planes[planeIndex].getRowStride();
            int pixelStride = planes[planeIndex].getPixelStride();
            int shift = planeIndex == 0 ? 0 : 1;
            int widthShifted = width >> shift;
            int heightShifted = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < heightShifted; ++row) {
                int length = 0;
                if (pixelStride == 1 && outputStride == 1) {
                    length = widthShifted;
                    buffer.get(output.array(), channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (widthShifted - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < widthShifted; ++col) {
                        output.array()[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= heightShifted - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return output;
    }

    @Nullable
    public final YuvImage fastI420ToYuvImage(@NotNull ArrayList<ByteBuffer> yuvPlanes, @NotNull ArrayList<Integer> yuvStrides, int width, int height) {
        int row;
        Intrinsics.checkNotNullParameter(yuvPlanes, (String)"yuvPlanes");
        Intrinsics.checkNotNullParameter(yuvStrides, (String)"yuvStrides");
        byte[] bytes = new byte[width * height * 3 / 2];
        int i = 0;
        for (row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int n = i++;
                Integer n2 = yuvStrides.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"yuvStrides[0]");
                bytes[n] = yuvPlanes.get(0).get(col + row * ((Number)n2).intValue());
            }
        }
        int n = height / 2;
        for (row = 0; row < n; ++row) {
            int n3 = width / 2;
            for (int col = 0; col < n3; ++col) {
                int n4 = i++;
                Integer n5 = yuvStrides.get(2);
                Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"yuvStrides[2]");
                bytes[n4] = yuvPlanes.get(2).get(col + row * ((Number)n5).intValue());
                int n6 = i++;
                Integer n7 = yuvStrides.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"yuvStrides[1]");
                bytes[n6] = yuvPlanes.get(1).get(col + row * ((Number)n7).intValue());
            }
        }
        return new YuvImage(bytes, 17, width, height, null);
    }

    @Nullable
    public final YuvImage i420ToYuvImage(@NotNull ArrayList<ByteBuffer> yuvPlanes, @NotNull ArrayList<Integer> yuvStrides, int width, int height) {
        int col;
        int n;
        int row;
        Intrinsics.checkNotNullParameter(yuvPlanes, (String)"yuvPlanes");
        Intrinsics.checkNotNullParameter(yuvStrides, (String)"yuvStrides");
        Integer n2 = yuvStrides.get(0);
        int n3 = width;
        if (n2 == null || n2 != n3) {
            return this.fastI420ToYuvImage(yuvPlanes, yuvStrides, width, height);
        }
        Integer n4 = yuvStrides.get(1);
        n3 = width / 2;
        if (n4 == null || n4 != n3) {
            return this.fastI420ToYuvImage(yuvPlanes, yuvStrides, width, height);
        }
        Integer n5 = yuvStrides.get(2);
        n3 = width / 2;
        if (n5 == null || n5 != n3) {
            return this.fastI420ToYuvImage(yuvPlanes, yuvStrides, width, height);
        }
        byte[] bytes = new byte[((Number)yuvStrides.get(0)).intValue() * height + ((Number)yuvStrides.get(1)).intValue() * height / 2 + ((Number)yuvStrides.get(2)).intValue() * height / 2];
        ByteBuffer tmp = ByteBuffer.wrap(bytes, 0, width * height);
        Integer n6 = yuvStrides.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)n6, (String)"yuvStrides[0]");
        YuvHelper.copyPlane((ByteBuffer)yuvPlanes.get(0), (int)((Number)n6).intValue(), (ByteBuffer)tmp, (int)0, (int)width, (int)height);
        byte[] tmpBytes = new byte[width / 2 * height / 2];
        tmp = ByteBuffer.wrap(tmpBytes, 0, width / 2 * height / 2);
        Integer n7 = yuvStrides.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"yuvStrides[2]");
        YuvHelper.copyPlane((ByteBuffer)yuvPlanes.get(2), (int)((Number)n7).intValue(), (ByteBuffer)tmp, (int)0, (int)width, (int)height);
        int n8 = height / 2;
        for (row = 0; row < n8; ++row) {
            n = width / 2;
            for (col = 0; col < n; ++col) {
                bytes[width * height + row * width + col * 2] = tmpBytes[row * width / 2 + col];
            }
        }
        Integer n9 = yuvStrides.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)n9, (String)"yuvStrides[1]");
        YuvHelper.copyPlane((ByteBuffer)yuvPlanes.get(1), (int)((Number)n9).intValue(), (ByteBuffer)tmp, (int)0, (int)width, (int)height);
        n8 = height / 2;
        for (row = 0; row < n8; ++row) {
            n = width / 2;
            for (col = 0; col < n; ++col) {
                bytes[width * height + row * width + col * 2 + 1] = tmpBytes[row * width / 2 + col];
            }
        }
        return new YuvImage(bytes, 17, width, height, null);
    }

    @NotNull
    public final int[] maskColorsFromByteBuffer(@NotNull ByteBuffer segmentationMask, int maskWidth, int maskHeight) {
        Intrinsics.checkNotNullParameter((Object)segmentationMask, (String)"segmentationMask");
        int[] colors = new int[maskWidth * maskHeight];
        int n = maskWidth * maskHeight;
        for (int i = 0; i < n; ++i) {
            float foregroundLikelihood = segmentationMask.getFloat();
            colors[i] = (double)foregroundLikelihood > 0.9 ? Color.argb((int)255, (int)0, (int)255, (int)255) : Color.argb((int)0, (int)0, (int)255, (int)255);
        }
        return colors;
    }

    @Nullable
    public final Bitmap getBitmapFromAsset(@NotNull Context context, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        AssetManager assetManager = context.getAssets();
        InputStream istr = null;
        Bitmap bitmap = null;
        try {
            InputStream inputStream = assetManager.open(filename);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(filename)");
            istr = inputStream;
            bitmap = BitmapFactory.decodeStream((InputStream)istr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bitmap;
    }

    @Nullable
    public final Bitmap convertToMutable(@NotNull Bitmap imgIn) {
        Intrinsics.checkNotNullParameter((Object)imgIn, (String)"imgIn");
        Bitmap imgIn2 = imgIn;
        try {
            File file = new File(File.separator + "temp.tmp");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            int width = imgIn2.getWidth();
            int height = imgIn2.getHeight();
            Bitmap.Config config = imgIn2.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"imgIn.config");
            Bitmap.Config type = config;
            FileChannel fileChannel = randomAccessFile.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"randomAccessFile.getChannel()");
            FileChannel channel = fileChannel;
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, imgIn2.getRowBytes() * height);
            Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"channel.map(FileChannel.\u2026t).toLong()\n            )");
            MappedByteBuffer map = mappedByteBuffer;
            imgIn2.copyPixelsToBuffer((Buffer)map);
            imgIn2.recycle();
            System.gc();
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)type);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, type)");
            imgIn2 = bitmap;
            map.position(0);
            imgIn2.copyPixelsFromBuffer((Buffer)map);
            channel.close();
            randomAccessFile.close();
            file.delete();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imgIn2;
    }

    @Nullable
    public final Bitmap overlay(@NotNull Bitmap src, @NotNull Bitmap dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int width = src.getWidth();
        int height = src.getHeight();
        int size = width * height;
        int[] pixSrc = new int[size];
        src.getPixels(pixSrc, 0, width, 0, 0, width, height);
        int[] pixDst = new int[size];
        dst.getPixels(pixDst, 0, width, 0, 0, width, height);
        int[] pixOverlay = new int[size];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = y * width + x;
                int rSrc = pixSrc[index] >> 16 & 0xFF;
                int rDst = pixDst[index] >> 16 & 0xFF;
                int rBlended = this.blendChannelOverlay(rSrc, rDst);
                int gSrc = pixSrc[index] >> 8 & 0xFF;
                int gDst = pixDst[index] >> 8 & 0xFF;
                int gBlended = this.blendChannelOverlay(gSrc, gDst);
                int bSrc = pixSrc[index] & 0xFF;
                int bDst = pixDst[index] & 0xFF;
                int bBlended = this.blendChannelOverlay(bSrc, bDst);
                pixOverlay[index] = Color.rgb((int)rBlended, (int)gBlended, (int)bBlended);
            }
        }
        return Bitmap.createBitmap((int[])pixOverlay, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
    }

    private final int blendChannelOverlay(int A, int B) {
        return B < 128 ? 2 * A * B / 255 : 255 - 2 * (255 - A) * (255 - B) / 255;
    }

    @Nullable
    public final int[] yuv2rgb(@NotNull byte[] yuv, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)yuv, (String)"yuv");
        int total = width * height;
        int[] rgb = new int[total];
        int Y = 0;
        int Cb = 0;
        int Cr = 0;
        int index = 0;
        int R = 0;
        int G = 0;
        int B = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Y = yuv[y * width + x];
                if (Y < 0) {
                    Y += 255;
                }
                if ((x & 1) == 0) {
                    Cr = yuv[(y >> 1) * width + x + total];
                    Cb = yuv[(y >> 1) * width + x + total + 1];
                    Cb = Cb < 0 ? (Cb += 127) : (Cb -= 128);
                    Cr = Cr < 0 ? (Cr += 127) : (Cr -= 128);
                }
                R = Y + Cr + (Cr >> 2) + (Cr >> 3) + (Cr >> 5);
                G = Y - (Cb >> 2) + (Cb >> 4) + (Cb >> 5) - (Cr >> 1) + (Cr >> 3) + (Cr >> 4) + (Cr >> 5);
                B = Y + Cb + (Cb >> 1) + (Cb >> 2) + (Cb >> 6);
                if (R < 0) {
                    R = 0;
                } else if (R > 255) {
                    R = 255;
                }
                if (G < 0) {
                    G = 0;
                } else if (G > 255) {
                    G = 255;
                }
                if (B < 0) {
                    B = 0;
                } else if (B > 255) {
                    B = 255;
                }
                rgb[index++] = -16777216 + (R << 16) + (G << 8) + B;
            }
        }
        return rgb;
    }

    public final void decodeYUV420SP(@NotNull int[] rgb, @NotNull byte[] yuv420sp, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        Intrinsics.checkNotNullParameter((Object)yuv420sp, (String)"yuv420sp");
        int frameSize = width * height;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = (0xFF & yuv420sp[yp]) - 16;
                if (y < 0) {
                    y = 0;
                }
                if ((i & 1) == 0) {
                    v = (0xFF & yuv420sp[uvp++]) - 128;
                    u = (0xFF & yuv420sp[uvp++]) - 128;
                }
                int y1192 = 1192 * y;
                int r = y1192 + 1634 * v;
                int g = y1192 - 833 * v - 400 * u;
                int b = y1192 + 2066 * u;
                if (r < 0) {
                    r = 0;
                } else if (r > 262143) {
                    r = 262143;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 262143) {
                    g = 262143;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 262143) {
                    b = 262143;
                }
                rgb[yp] = 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
                ++i;
                ++yp;
            }
        }
    }

    @Nullable
    public final byte[] YUV_420_888toNV21(int width, int height, @NotNull ByteBuffer yBuffer, int strideY, @NotNull ByteBuffer uBuffer, int strideU, @NotNull ByteBuffer vBuffer, int strideV) {
        Intrinsics.checkNotNullParameter((Object)yBuffer, (String)"yBuffer");
        Intrinsics.checkNotNullParameter((Object)uBuffer, (String)"uBuffer");
        Intrinsics.checkNotNullParameter((Object)vBuffer, (String)"vBuffer");
        int ySize = width * height;
        int uvSize = width * height / 4;
        byte[] nv21 = new byte[ySize + uvSize * 2];
        int rowStride = strideY;
        if (rowStride == width) {
            yBuffer.get(nv21, 0, ySize);
            pos += ySize;
        } else {
            long yBufferPos = -((long)rowStride);
            for (int pos = 0; pos < ySize; pos += width) {
                yBuffer.position((int)(yBufferPos += (long)rowStride));
                yBuffer.get(nv21, pos, width);
            }
        }
        rowStride = strideV;
        int pixelStride = strideV;
        if (pixelStride == 2 && rowStride == width && uBuffer.get(0) == vBuffer.get(1)) {
            byte savePixel = vBuffer.get(1);
            try {
                vBuffer.put(1, ~savePixel);
                if (uBuffer.get(0) == (byte)(~savePixel)) {
                    vBuffer.put(1, savePixel);
                    vBuffer.position(0);
                    uBuffer.position(0);
                    vBuffer.get(nv21, ySize, 1);
                    uBuffer.get(nv21, ySize + 1, uBuffer.remaining());
                    return nv21;
                }
            }
            catch (ReadOnlyBufferException readOnlyBufferException) {
                // empty catch block
            }
            vBuffer.put(1, savePixel);
        }
        int n = height / 2;
        for (int row = 0; row < n; ++row) {
            int n2 = width / 2;
            for (int col = 0; col < n2; ++col) {
                int vuPos = col * pixelStride + row * rowStride;
                nv21[pos++] = vBuffer.get(vuPos);
                nv21[pos++] = uBuffer.get(vuPos);
            }
        }
        return nv21;
    }

    private final ByteBuffer createNV21Buffer(VideoFrame.I420Buffer i420Buffer) {
        int x;
        int y;
        int width = i420Buffer.getWidth();
        int height = i420Buffer.getHeight();
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = (height + 1) / 2;
        int ySize = width * height;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(ySize + width * chromaHeight);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(ySize + width * chromaHeight)");
        ByteBuffer nv21Buffer = byteBuffer;
        byte[] byArray = nv21Buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"nv21Buffer.array()");
        byte[] nv21Data = byArray;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                byte yValue;
                nv21Data[y * width + x] = yValue = i420Buffer.getDataY().get(y * i420Buffer.getStrideY() + x);
            }
        }
        for (y = 0; y < chromaHeight; ++y) {
            for (x = 0; x < chromaWidth; ++x) {
                byte vValue;
                byte uValue = i420Buffer.getDataU().get(y * i420Buffer.getStrideU() + x);
                nv21Data[ySize + y * width + 2 * x + 0] = vValue = i420Buffer.getDataV().get(y * i420Buffer.getStrideV() + x);
                nv21Data[ySize + y * width + 2 * x + 1] = uValue;
            }
        }
        return nv21Buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] compressByteArray(@Nullable byte[] bytes) {
        ByteArrayOutputStream baos = null;
        Deflater dfl = new Deflater();
        dfl.setLevel(9);
        dfl.setInput(bytes);
        dfl.finish();
        baos = new ByteArrayOutputStream();
        byte[] tmp = new byte[4096];
        try {
            while (!dfl.finished()) {
                int size = dfl.deflate(tmp);
                baos.write(tmp, 0, size);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
        }
        return baos.toByteArray();
    }

    @NotNull
    public final Bitmap yuvByteArrayToBitmap(@NotNull byte[] bytes, int width, int height, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RenderScript rs = RenderScript.create((Context)context);
        ScriptIntrinsicYuvToRGB yuvToRgbIntrinsic = ScriptIntrinsicYuvToRGB.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Type.Builder yuvType = new Type.Builder(rs, Element.U8((RenderScript)rs)).setX(bytes.length);
        Allocation input = Allocation.createTyped((RenderScript)rs, (Type)yuvType.create(), (int)1);
        Type.Builder rgbaType = new Type.Builder(rs, Element.RGBA_8888((RenderScript)rs)).setX(width).setY(height);
        Allocation output = Allocation.createTyped((RenderScript)rs, (Type)rgbaType.create(), (int)1);
        input.copyFrom(bytes);
        yuvToRgbIntrinsic.setInput(input);
        yuvToRgbIntrinsic.forEach(output);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        output.copyTo(bitmap);
        input.destroy();
        output.destroy();
        yuvToRgbIntrinsic.destroy();
        rs.destroy();
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }
}

