/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.Track;
import live.hms.video.media.settings.HMSLayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011RJ\u0010\u0003\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0004j\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llive/hms/video/connection/stats/BitrateCalculator;", "", "()V", "prevTrackStatsReceivedTime", "Ljava/util/HashMap;", "", "Lkotlin/Pair;", "", "Ljava/math/BigInteger;", "Lkotlin/collections/HashMap;", "getBitrateFromTrackUpdatePrev", "trackId", "remoteTimeStamp", "bytesTransported", "rid", "(Ljava/lang/String;Ljava/lang/Double;Ljava/math/BigInteger;Ljava/lang/String;)D", "stat", "Llive/hms/video/connection/degredation/Track;", "lib_release"})
public final class BitrateCalculator {
    @NotNull
    private final HashMap<String, Pair<Double, BigInteger>> prevTrackStatsReceivedTime = new HashMap();

    public final double getBitrateFromTrackUpdatePrev(@NotNull Track stat) {
        String string;
        HMSLayer hMSLayer;
        Track.LocalTrack.LocalVideo localVideo;
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        Track.LocalTrack.LocalVideo localVideo2 = localVideo = stat instanceof Track.LocalTrack.LocalVideo ? (Track.LocalTrack.LocalVideo)stat : null;
        return this.getBitrateFromTrackUpdatePrev(stat.getTrackIdentifier(), stat.getRemoteTimestamp(), stat.getBytesTransported(), localVideo == null ? "" : ((hMSLayer = localVideo.getHmsLayer()) == null ? "" : ((string = hMSLayer.name()) == null ? "" : string)));
    }

    public final double getBitrateFromTrackUpdatePrev(@Nullable String trackId, @Nullable Double remoteTimeStamp, @Nullable BigInteger bytesTransported, @NotNull String rid) {
        Intrinsics.checkNotNullParameter((Object)rid, (String)"rid");
        String trackIdentifier = trackId;
        double bitrate = 0.0;
        if (trackIdentifier != null && remoteTimeStamp != null) {
            double d;
            BigInteger prevBytesReceived;
            String simulcastPostFix = rid;
            Pair<Double, BigInteger> prevInfo = this.prevTrackStatsReceivedTime.get(trackIdentifier + '_' + simulcastPostFix);
            Pair<Double, BigInteger> pair = prevInfo;
            Double prevTime = pair == null ? null : (Double)pair.getFirst();
            Pair<Double, BigInteger> pair2 = prevInfo;
            BigInteger bigInteger = prevBytesReceived = pair2 == null ? null : (BigInteger)pair2.getSecond();
            if (prevBytesReceived != null && prevTime != null && bytesTransported != null) {
                double timeDelta = (remoteTimeStamp - prevTime) / (double)1000000;
                d = (double)(0.008f * (bytesTransported.floatValue() - prevBytesReceived.floatValue())) / timeDelta;
            } else {
                d = 0.0;
            }
            bitrate = d;
            Map map = this.prevTrackStatsReceivedTime;
            String string = trackIdentifier + '_' + simulcastPostFix;
            Pair pair3 = new Pair((Object)remoteTimeStamp, (Object)bytesTransported);
            map.put(string, pair3);
        }
        return bitrate;
    }
}

