/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio.manager;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.audio.AudioChangeEvent;
import live.hms.video.audio.AudioManagerFocusChangeCallbacks;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.audio.manager.AudioDeviceMapping;
import live.hms.video.audio.manager.AudioManagerCompat;
import live.hms.video.audio.manager.AudioManagerUtil;
import live.hms.video.audio.manager.HMSAudioManagerApi31;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.PhoneCallState;
import live.hms.video.sdk.IErrorListener;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ab\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007*\u0001\u001c\b\u0007\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020<H\u0002J\b\u0010?\u001a\u00020<H\u0002J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0016J\b\u0010C\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020<2\u0006\u0010E\u001a\u00020\u000bH\u0002J\u0006\u0010F\u001a\u00020<J\b\u0010G\u001a\u00020$H\u0016J\u0010\u0010H\u001a\u00020<2\u0006\u0010=\u001a\u00020\"H\u0016J\b\u0010I\u001a\u00020<H\u0002J\u0010\u0010J\u001a\u00020<2\u0006\u0010K\u001a\u00020BH\u0016J\u0010\u0010L\u001a\u00020<2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020<2\u0006\u0010P\u001a\u000200H\u0016J\u0016\u0010Q\u001a\u00020<2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020:0SH\u0002J\u0010\u0010T\u001a\u00020<2\u0006\u0010U\u001a\u00020$H\u0002J\u0010\u0010V\u001a\u00020<2\u0006\u0010U\u001a\u00020$H\u0002J\b\u0010W\u001a\u00020<H\u0016J\b\u0010X\u001a\u00020<H\u0016J\b\u0010Y\u001a\u00020<H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b)\u0010*R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000204X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Llive/hms/video/audio/manager/HMSAudioManagerApi31;", "Llive/hms/video/audio/HMSAudioManager;", "context", "Landroid/content/Context;", "analytics", "Llive/hms/video/events/AnalyticsEventsService;", "hmsAudioTrackSettings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "audioManagerDeviceChangeListener", "Llive/hms/video/audio/HMSAudioManager$AudioManagerDeviceChangeListener;", "errorListener", "Llive/hms/video/sdk/IErrorListener;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;Llive/hms/video/media/settings/HMSAudioTrackSettings;Llive/hms/video/audio/HMSAudioManager$AudioManagerDeviceChangeListener;Llive/hms/video/sdk/IErrorListener;)V", "TAG", "", "TELEPHONY_LOCK", "", "androidAudioManager", "Llive/hms/video/audio/manager/AudioManagerCompat;", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "getAudioManagerDeviceChangeListener", "()Llive/hms/video/audio/HMSAudioManager$AudioManagerDeviceChangeListener;", "getContext", "()Landroid/content/Context;", "defaultAudioDevice", "Llive/hms/video/audio/manager/AudioManagerUtil$AudioDevice;", "deviceCallback", "live/hms/video/audio/manager/HMSAudioManagerApi31$deviceCallback$1", "Llive/hms/video/audio/manager/HMSAudioManagerApi31$deviceCallback$1;", "getErrorListener", "()Llive/hms/video/sdk/IErrorListener;", "focusChangeCallbacks", "", "Llive/hms/video/audio/AudioManagerFocusChangeCallbacks;", "hasWiredHeadset", "", "getHmsAudioTrackSettings", "()Llive/hms/video/media/settings/HMSAudioTrackSettings;", "mainHandler", "Landroid/os/Handler;", "getMainHandler", "()Landroid/os/Handler;", "mainHandler$delegate", "Lkotlin/Lazy;", "phoneStateChangeListener", "Landroid/telephony/PhoneStateListener;", "savedAudioMode", "", "savedIsMicrophoneMute", "savedIsSpeakerPhoneOn", "state", "Llive/hms/video/audio/HMSAudioManager$AudioManagerState;", "getState", "()Llive/hms/video/audio/HMSAudioManager$AudioManagerState;", "setState", "(Llive/hms/video/audio/HMSAudioManager$AudioManagerState;)V", "userSelectedAudioDevice", "Landroid/media/AudioDeviceInfo;", "addAudioFocusChangeCallback", "", "callback", "createAudioFocusChangeListener", "deInitTelephony", "getAudioDevices", "", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "getSelectedAudioDevice", "initTelephony", "onErrorListener", "initialize", "isStarted", "removeAudioFocusChangeCallback", "requestAudioFocus", "selectAudioDevice", "device", "sendAudioChangeEvent", "event", "Llive/hms/video/audio/AudioChangeEvent;", "setAudioMode", "audioMode", "setAutomaticSelection", "availableCommunicationDevices", "", "setMicrophoneMute", "on", "setSpeakerphoneOn", "start", "stop", "updateAudioDeviceState", "lib_release"})
@RequiresApi(value=31)
public final class HMSAudioManagerApi31
implements HMSAudioManager {
    @NotNull
    private final Context context;
    @Nullable
    private final HMSAudioTrackSettings hmsAudioTrackSettings;
    @NotNull
    private final HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener;
    @Nullable
    private final IErrorListener errorListener;
    @NotNull
    private final String TAG;
    @NotNull
    private final AudioManagerCompat androidAudioManager;
    @NotNull
    private AudioManagerUtil.AudioDevice defaultAudioDevice;
    @Nullable
    private AudioDeviceInfo userSelectedAudioDevice;
    private int savedAudioMode;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    @NotNull
    private final Object TELEPHONY_LOCK;
    @NotNull
    private final Lazy mainHandler$delegate;
    @NotNull
    private HMSAudioManager.AudioManagerState state;
    @NotNull
    private final deviceCallback.1 deviceCallback;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    @NotNull
    private final List<AudioManagerFocusChangeCallbacks> focusChangeCallbacks;
    @Nullable
    private PhoneStateListener phoneStateChangeListener;

    public HMSAudioManagerApi31(@NotNull Context context, @NotNull AnalyticsEventsService analytics, @Nullable HMSAudioTrackSettings hmsAudioTrackSettings, @NotNull HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener, @Nullable IErrorListener errorListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)audioManagerDeviceChangeListener, (String)"audioManagerDeviceChangeListener");
        this.context = context;
        this.hmsAudioTrackSettings = hmsAudioTrackSettings;
        this.audioManagerDeviceChangeListener = audioManagerDeviceChangeListener;
        this.errorListener = errorListener;
        this.TAG = "HMSAudioManagerApi31";
        AudioManagerCompat audioManagerCompat = AudioManagerCompat.create(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)audioManagerCompat, (String)"create(context)");
        this.androidAudioManager = audioManagerCompat;
        this.defaultAudioDevice = AudioManagerUtil.AudioDevice.SPEAKER_PHONE;
        this.savedAudioMode = -2;
        this.TELEPHONY_LOCK = new Object();
        this.mainHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Handler>(this){
            final /* synthetic */ HMSAudioManagerApi31 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Handler invoke() {
                return new Handler(this.this$0.getContext().getMainLooper());
            }
        }));
        this.state = HMSAudioManager.AudioManagerState.UNINITIALIZED;
        this.initialize();
        this.deviceCallback = new AudioDeviceCallback(this){
            final /* synthetic */ HMSAudioManagerApi31 this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onAudioDevicesAdded(@NotNull AudioDeviceInfo[] addedDevices) {
                Collection<AudioManagerUtil.AudioDevice> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)addedDevices, (String)"addedDevices");
                super.onAudioDevicesAdded(addedDevices);
                AudioDeviceInfo[] audioDeviceInfoArray = addedDevices;
                String string = "onAudioDevicesAdded :: ";
                String string2 = HMSAudioManagerApi31.access$getTAG$p(this.this$0);
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void var11_13 = item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    AudioManagerUtil.AudioDevice audioDevice = AudioDeviceMapping.fromPlatformType(it.getType());
                    collection.add(audioDevice);
                }
                collection = (List)destination$iv$iv;
                HMSLogger.d(string2, Intrinsics.stringPlus((String)string, (Object)collection));
                HMSAudioManagerApi31.access$updateAudioDeviceState(this.this$0);
            }

            /*
             * WARNING - void declaration
             */
            public void onAudioDevicesRemoved(@NotNull AudioDeviceInfo[] removedDevices) {
                Collection<AudioManagerUtil.AudioDevice> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)removedDevices, (String)"removedDevices");
                super.onAudioDevicesRemoved(removedDevices);
                AudioDeviceInfo[] audioDeviceInfoArray = removedDevices;
                String string = "onAudioDevicesRemoved :: ";
                String string2 = HMSAudioManagerApi31.access$getTAG$p(this.this$0);
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void var11_13 = item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    AudioManagerUtil.AudioDevice audioDevice = AudioDeviceMapping.fromPlatformType(it.getType());
                    collection.add(audioDevice);
                }
                collection = (List)destination$iv$iv;
                HMSLogger.d(string2, Intrinsics.stringPlus((String)string, (Object)collection));
                HMSAudioManagerApi31.access$updateAudioDeviceState(this.this$0);
            }
        };
        this.focusChangeCallbacks = new ArrayList();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final HMSAudioTrackSettings getHmsAudioTrackSettings() {
        return this.hmsAudioTrackSettings;
    }

    @NotNull
    public final HMSAudioManager.AudioManagerDeviceChangeListener getAudioManagerDeviceChangeListener() {
        return this.audioManagerDeviceChangeListener;
    }

    @Nullable
    public final IErrorListener getErrorListener() {
        return this.errorListener;
    }

    private final Handler getMainHandler() {
        Lazy lazy = this.mainHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @NotNull
    protected final HMSAudioManager.AudioManagerState getState() {
        return this.state;
    }

    protected final void setState(@NotNull HMSAudioManager.AudioManagerState audioManagerState) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioManagerState), (String)"<set-?>");
        this.state = audioManagerState;
    }

    @Override
    public void addAudioFocusChangeCallback(@NotNull AudioManagerFocusChangeCallbacks callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.focusChangeCallbacks.add(callback);
    }

    @Override
    public void removeAudioFocusChangeCallback(@NotNull AudioManagerFocusChangeCallbacks callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.focusChangeCallbacks.remove(callback);
    }

    public final void initialize() {
        if (this.state == HMSAudioManager.AudioManagerState.UNINITIALIZED) {
            HMSLogger.d(this.TAG, "Initialized HMSAudioManagerApi31");
            this.savedAudioMode = this.androidAudioManager.getMode();
            this.savedIsSpeakerPhoneOn = this.androidAudioManager.isSpeakerphoneOn();
            this.savedIsMicrophoneMute = this.androidAudioManager.isMicrophoneMute();
            this.hasWiredHeadset = this.androidAudioManager.isWiredHeadsetOn();
            this.state = HMSAudioManager.AudioManagerState.PREINITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initTelephony(IErrorListener onErrorListener) {
        if (this.hmsAudioTrackSettings != null && this.getMainHandler() != null && this.hmsAudioTrackSettings.getPhoneCallState() == PhoneCallState.DISABLE_MUTE_ON_VOIP_PHONE_CALL_RING) {
            Object object = this.TELEPHONY_LOCK;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.getMainHandler().post(() -> HMSAudioManagerApi31.initTelephony$lambda-1$lambda-0(this, onErrorListener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deInitTelephony() {
        if (this.hmsAudioTrackSettings != null && this.getMainHandler() != null && this.phoneStateChangeListener != null && this.hmsAudioTrackSettings.getPhoneCallState() == PhoneCallState.DISABLE_MUTE_ON_VOIP_PHONE_CALL_RING) {
            Object object = this.TELEPHONY_LOCK;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.getMainHandler().post(() -> HMSAudioManagerApi31.deInitTelephony$lambda-3$lambda-2(this));
            }
        }
    }

    @Override
    public void start() {
        HMSLogger.d(this.TAG, "Started");
        this.createAudioFocusChangeListener();
        this.requestAudioFocus();
        if (this.errorListener != null) {
            this.initTelephony(new IErrorListener(this){
                final /* synthetic */ HMSAudioManagerApi31 this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onError(@NotNull HMSException error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.this$0.getErrorListener().onError(error);
                }
            });
        }
        this.androidAudioManager.registerAudioDeviceCallback(this.deviceCallback, null);
        this.androidAudioManager.setMicrophoneMute(false);
        this.state = HMSAudioManager.AudioManagerState.RUNNING;
        this.setAudioMode(3);
        this.updateAudioDeviceState();
    }

    private final void createAudioFocusChangeListener() {
        this.audioFocusChangeListener = arg_0 -> HMSAudioManagerApi31.createAudioFocusChangeListener$lambda-4(this, arg_0);
    }

    private final void requestAudioFocus() {
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
        AudioFocusRequest.Builder builder = new AudioFocusRequest.Builder(2).setAcceptsDelayedFocusGain(true).setAudioAttributes(audioAttributes);
        AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = this.audioFocusChangeListener;
        Intrinsics.checkNotNull((Object)onAudioFocusChangeListener);
        AudioFocusRequest audioFocusRequest = builder.setOnAudioFocusChangeListener(onAudioFocusChangeListener).build();
        this.androidAudioManager.audioManager.requestAudioFocus(audioFocusRequest);
    }

    private final void sendAudioChangeEvent(AudioChangeEvent event) {
        for (AudioManagerFocusChangeCallbacks callback : this.focusChangeCallbacks) {
            callback.onAudioFocusChange(event);
        }
    }

    @Override
    public boolean isStarted() {
        return this.state == HMSAudioManager.AudioManagerState.RUNNING;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<HMSAudioManager.AudioDevice> getAudioDevices() {
        void $this$mapTo$iv$iv;
        List<AudioDeviceInfo> list = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"androidAudioManager.availableCommunicationDevices");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HMSAudioManager.AudioDevice audioDevice = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType()));
            collection.add(audioDevice);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public HMSAudioManager.AudioDevice getSelectedAudioDevice() {
        int n;
        AudioDeviceInfo audioDeviceInfo = this.androidAudioManager.getCommunicationDevice();
        return AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(audioDeviceInfo == null ? -1 : (n = audioDeviceInfo.getType())));
    }

    @Override
    public void setAudioMode(int audioMode) {
        if (this.isStarted()) {
            this.androidAudioManager.setMode(audioMode);
        }
    }

    @Override
    public void stop() {
        this.androidAudioManager.unregisterAudioDeviceCallback(this.deviceCallback);
        if (this.state == HMSAudioManager.AudioManagerState.UNINITIALIZED && this.userSelectedAudioDevice != null) {
            Log.d((String)this.TAG, (String)"Stopping audio manager after selecting audio device but never initializing. This indicates a service spun up solely to set audio device. Therefore skipping audio device reset.");
        } else {
            this.androidAudioManager.clearCommunicationDevice();
            this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
            this.setMicrophoneMute(this.savedIsMicrophoneMute);
            this.androidAudioManager.setMode(this.savedAudioMode);
        }
        this.deInitTelephony();
        this.androidAudioManager.abandonCallAudioFocus();
        Log.d((String)this.TAG, (String)"Abandoned audio focus for VOICE_CALL streams");
        this.state = HMSAudioManager.AudioManagerState.UNINITIALIZED;
        Log.d((String)this.TAG, (String)"Stopped");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectAudioDevice(@NotNull HMSAudioManager.AudioDevice device) {
        AudioDeviceInfo audioDeviceInfo;
        HMSAudioManager.AudioDevice audioDevice;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)device), (String)"device");
        HMSLogger.d(this.TAG, Intrinsics.stringPlus((String)"Manually Selecting ", (Object)((Object)device)));
        Iterable<Object> iterable = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"androidAudioManager.availableCommunicationDevices");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioDeviceInfo audioDeviceInfo2 = (AudioDeviceInfo)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            audioDevice = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType()));
            object.add(audioDevice);
        }
        CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object object2 = this;
        if (device == HMSAudioManager.AudioDevice.AUTOMATIC) {
            audioDeviceInfo = null;
        } else {
            Object object3;
            block4: {
                iterable = this.androidAudioManager.getAvailableCommunicationDevices();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"androidAudioManager.availableCommunicationDevices");
                iterable = iterable;
                object = object2;
                Iterable<Object> iterable3 = iterable;
                boolean bl = false;
                for (Object object4 : iterable3) {
                    AudioDeviceInfo it = (AudioDeviceInfo)object4;
                    boolean bl2 = false;
                    boolean bl3 = AudioDeviceMapping.fromPlatformType(it.getType()) == AudioDeviceMapping.toSignalMapping(device);
                    if (!bl3) continue;
                    object3 = object4;
                    break block4;
                }
                object3 = null;
            }
            audioDevice = object3;
            object2 = object;
            audioDeviceInfo = (AudioDeviceInfo)audioDevice;
        }
        ((HMSAudioManagerApi31)object2).userSelectedAudioDevice = audioDeviceInfo;
        this.updateAudioDeviceState();
    }

    private final void setSpeakerphoneOn(boolean on) {
        if (this.androidAudioManager.isSpeakerphoneOn() != on) {
            this.androidAudioManager.setSpeakerphoneOn(on);
        }
    }

    private final void setMicrophoneMute(boolean on) {
        if (this.androidAudioManager.isMicrophoneMute() != on) {
            this.androidAudioManager.setMicrophoneMute(on);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAudioDeviceState() {
        List<AudioDeviceInfo> list = this.androidAudioManager.getAvailableCommunicationDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"androidAudioManager.availableCommunicationDevices");
        List<AudioDeviceInfo> availableCommunicationDevices = list;
        AudioDeviceInfo candidate = this.userSelectedAudioDevice;
        if (candidate != null && candidate.getId() != 0) {
            HMSLogger.d(this.TAG, Intrinsics.stringPlus((String)"Candidate found :: ", (Object)((Object)AudioDeviceMapping.fromPlatformType(candidate.getType()))));
            boolean result2 = this.androidAudioManager.setCommunicationDevice(candidate);
            if (result2) {
                Collection<HMSAudioManager.AudioDevice> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                AudioManagerUtil.AudioDevice signalDeviceMapping = AudioDeviceMapping.fromPlatformType(candidate.getType());
                HMSAudioManager.AudioDevice hmsDeviceMapping = AudioDeviceMapping.toHMSMapping(signalDeviceMapping);
                Iterable iterable = availableCommunicationDevices;
                HMSAudioManager.AudioDevice audioDevice = hmsDeviceMapping;
                HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener = this.audioManagerDeviceChangeListener;
                boolean $i$f$map = false;
                void var8_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    HMSAudioManager.AudioDevice audioDevice2 = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType()));
                    collection.add(audioDevice2);
                }
                collection = (List)destination$iv$iv;
                audioManagerDeviceChangeListener.onAudioDeviceChanged(audioDevice, CollectionsKt.toSet((Iterable)collection));
            } else {
                Log.w((String)this.TAG, (String)("Failed to set " + candidate.getId() + " of type " + candidate.getType() + "as communication device. switching to automatic selection"));
                this.setAutomaticSelection(availableCommunicationDevices);
                this.userSelectedAudioDevice = null;
            }
        } else {
            this.setAutomaticSelection(availableCommunicationDevices);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setAutomaticSelection(List<AudioDeviceInfo> availableCommunicationDevices) {
        Iterable $this$mapTo$iv$iv;
        Iterable $i$f$filterNot22;
        Object deviceType;
        AudioDeviceInfo candidate = null;
        HMSLogger.d(this.TAG, "Automatic selection");
        Object object = new AudioManagerUtil.AudioDevice[]{AudioManagerUtil.AudioDevice.BLUETOOTH, AudioManagerUtil.AudioDevice.WIRED_HEADSET, AudioManagerUtil.AudioDevice.SPEAKER_PHONE, AudioManagerUtil.AudioDevice.EARPIECE, AudioManagerUtil.AudioDevice.NONE};
        List searchOrder = CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])object));
        object = searchOrder.iterator();
        while (object.hasNext()) {
            Object v0;
            block9: {
                void $this$filterNotTo$iv$iv2;
                deviceType = (AudioManagerUtil.AudioDevice)((Object)object.next());
                Iterable $this$filterNot$iv = availableCommunicationDevices;
                boolean $i$f$filterNot22 = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo2 = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                    AudioDeviceInfo it = (AudioDeviceInfo)element$iv$iv;
                    boolean bl = false;
                    CharSequence charSequence = it.getProductName();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"it.productName");
                    if (StringsKt.contains((CharSequence)charSequence, (CharSequence)" Watch", (boolean)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filterNot22 = $this$filterNot$iv = (Iterable)((List)destination$iv$iv);
                boolean $this$filterNotTo$iv$iv2 = false;
                for (Object $i$f$filterNotTo2 : $i$f$filterNot22) {
                    AudioDeviceInfo it = (AudioDeviceInfo)$i$f$filterNotTo2;
                    boolean bl = false;
                    if (!(AudioDeviceMapping.fromPlatformType(it.getType()) == deviceType)) continue;
                    v0 = $i$f$filterNotTo2;
                    break block9;
                }
                v0 = null;
            }
            if ((candidate = (AudioDeviceInfo)v0) == null) continue;
            HMSLogger.d(this.TAG, Intrinsics.stringPlus((String)"Automatically selected -> ", (Object)((Object)AudioDeviceMapping.fromPlatformType(candidate.getType()))));
            break;
        }
        if ((object = candidate) == null) {
            Collection<AudioManagerUtil.AudioDevice> collection;
            void $this$map$iv;
            deviceType = availableCommunicationDevices;
            String string = "Tried to switch audio devices but could not find suitable device in list of types: ";
            String string2 = this.TAG;
            boolean $i$f$map = false;
            $i$f$filterNot22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AudioDeviceInfo bl = (AudioDeviceInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                AudioManagerUtil.AudioDevice audioDevice = AudioDeviceMapping.fromPlatformType(it.getType());
                collection.add(audioDevice);
            }
            collection = (List)destination$iv$iv;
            HMSLogger.e(string2, Intrinsics.stringPlus((String)string, (Object)CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null)));
            this.androidAudioManager.clearCommunicationDevice();
        } else {
            HMSLogger.d(this.TAG, Intrinsics.stringPlus((String)"Switching to new device of type ", (Object)((Object)AudioDeviceMapping.fromPlatformType(candidate.getType()))));
            boolean result2 = this.androidAudioManager.setCommunicationDevice(candidate);
            if (result2) {
                Collection<HMSAudioManager.AudioDevice> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                HMSAudioManager.AudioDevice hmsDevice = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(candidate.getType()));
                $this$mapTo$iv$iv = availableCommunicationDevices;
                HMSAudioManager.AudioDevice audioDevice = hmsDevice;
                HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener = this.audioManagerDeviceChangeListener;
                boolean $i$f$map = false;
                void $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    AudioDeviceInfo bl = (AudioDeviceInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    HMSAudioManager.AudioDevice audioDevice2 = AudioDeviceMapping.toHMSMapping(AudioDeviceMapping.fromPlatformType(it.getType()));
                    collection.add(audioDevice2);
                }
                collection = (List)destination$iv$iv;
                audioManagerDeviceChangeListener.onAudioDeviceChanged(audioDevice, CollectionsKt.toSet((Iterable)collection));
            } else {
                Log.w((String)this.TAG, (String)("Failed to set " + candidate.getId() + " as communication device."));
            }
        }
    }

    private static final void initTelephony$lambda-1$lambda-0(HMSAudioManagerApi31 this$0, IErrorListener $onErrorListener) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onErrorListener, (String)"$onErrorListener");
        if (this$0.phoneStateChangeListener == null) {
            this$0.phoneStateChangeListener = new PhoneStateListener(this$0){
                final /* synthetic */ HMSAudioManagerApi31 this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCallStateChanged(int state2, @NotNull String phoneNumber) {
                    Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
                    super.onCallStateChanged(state2, phoneNumber);
                    if (state2 == 2) {
                        HMSLogger.d(HMSAudioManagerApi31.access$getTAG$p(this.this$0), Intrinsics.stringPlus((String)"onCallStateChanged: ", (Object)((Object)AudioChangeEvent.PHONE_RINGING)));
                        HMSAudioManagerApi31.access$sendAudioChangeEvent(this.this$0, AudioChangeEvent.PHONE_RINGING);
                    }
                }
            };
        }
        if ((object = this$0.getContext().getSystemService("phone")) == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager telephonyManager = (TelephonyManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            if (ContextCompat.checkSelfPermission((Context)this$0.getContext(), (String)"android.permission.READ_PHONE_STATE") == 0) {
                telephonyManager.listen(this$0.phoneStateChangeListener, 32);
            } else {
                $onErrorListener.onError(ErrorFactory.ReadPhoneStateError());
            }
        } else {
            telephonyManager.listen(this$0.phoneStateChangeListener, 32);
        }
    }

    private static final void deInitTelephony$lambda-3$lambda-2(HMSAudioManagerApi31 this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.getContext().getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager telephonyManager = (TelephonyManager)object;
        if (ContextCompat.checkSelfPermission((Context)this$0.getContext(), (String)"android.permission.READ_PHONE_STATE") == 0) {
            telephonyManager.listen(this$0.phoneStateChangeListener, 0);
        }
    }

    private static final void createAudioFocusChangeListener$lambda-4(HMSAudioManagerApi31 this$0, int focusChange) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HMSLogger.d(this$0.TAG, Intrinsics.stringPlus((String)"onAudioFocusChange: ", (Object)focusChange));
        int n = focusChange;
        switch (n) {
            case 1: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_GAIN);
                this$0.androidAudioManager.clearCommunicationDevice();
                this$0.updateAudioDeviceState();
                break;
            }
            case 2: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT);
                break;
            }
            case 4: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_EXCLUSIVE);
                break;
            }
            case 3: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK);
                break;
            }
            case -1: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS);
                break;
            }
            case -2: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_LOSS_TRANSIENT);
                break;
            }
            case -3: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK);
                break;
            }
            default: {
                this$0.sendAudioChangeEvent(AudioChangeEvent.DEBUG_INVALID);
            }
        }
    }

    public static final /* synthetic */ String access$getTAG$p(HMSAudioManagerApi31 $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$sendAudioChangeEvent(HMSAudioManagerApi31 $this, AudioChangeEvent event) {
        $this.sendAudioChangeEvent(event);
    }

    public static final /* synthetic */ void access$updateAudioDeviceState(HMSAudioManagerApi31 $this) {
        $this.updateAudioDeviceState();
    }
}

