/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.managers.OnPeerLeaveManager;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSPeerUpdate;
import live.hms.video.sdk.models.role.HMSRole;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llive/hms/video/sdk/managers/OnPeerUpdateManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$Peer;", "store", "Llive/hms/video/sdk/SDKStore;", "onPeerLeaveManager", "Llive/hms/video/sdk/managers/OnPeerLeaveManager;", "<init>", "(Llive/hms/video/sdk/SDKStore;Llive/hms/video/sdk/managers/OnPeerLeaveManager;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "Companion", "lib_release"})
public final class OnPeerUpdateManager
implements IManager<HMSNotifications.Peer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SDKStore store;
    @NotNull
    private final OnPeerLeaveManager onPeerLeaveManager;
    @NotNull
    private static final String TAG = "OnPeerUpdateManager";

    public OnPeerUpdateManager(@NotNull SDKStore store, @NotNull OnPeerLeaveManager onPeerLeaveManager) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)onPeerLeaveManager, (String)"onPeerLeaveManager");
        this.store = store;
        this.onPeerLeaveManager = onPeerLeaveManager;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.Peer params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ArrayList<SDKUpdate> updates2 = new ArrayList<SDKUpdate>();
        HMSPeer hmsPeer = this.getStore().getPeerById(params.getPeerId());
        String prevRole = null;
        String prevName = null;
        String prevMetadata = null;
        boolean wasHandRaised = false;
        if (hmsPeer != null) {
            prevRole = hmsPeer.getHmsRole().getName();
            prevName = hmsPeer.getName();
            prevMetadata = hmsPeer.getMetadata();
            ArrayList<String> arrayList = hmsPeer.getGroups$lib_release();
            boolean bl = wasHandRaised = arrayList != null ? arrayList.contains("_handraise") : false;
            if (!params.isRealTime() && !hmsPeer.isLocal()) {
                updates2.addAll((Collection)this.onPeerLeaveManager.removeFromStoreAndSendUpdates(params.toPeerLeave()));
            }
        } else {
            hmsPeer = this.getStore().add(params.toPeerJoin());
            Object[] objectArray = new HMSPeer[]{hmsPeer};
            updates2.add(new SDKUpdate.PeerListUpdate(CollectionsKt.arrayListOf((Object[])objectArray), null));
        }
        String newRole = params.getRole();
        String newName = params.getInfo().getUserName();
        String newMetadata = params.getInfo().getMetadata();
        ArrayList<String> arrayList = params.getGroups();
        boolean isHandRaised = arrayList != null ? arrayList.contains("_handraise") : false;
        HMSPeer it = hmsPeer;
        boolean bl = false;
        Map<String, HMSRole> map = this.getStore().getRolesMap();
        if (!(map == null || map.isEmpty())) {
            if (!it.isLocal()) {
                HMSRole hMSRole = this.getStore().getRolesMap().get(newRole);
                Intrinsics.checkNotNull((Object)hMSRole);
                it.setHmsRole$lib_release(hMSRole);
                if (!Intrinsics.areEqual((Object)newRole, (Object)prevRole)) {
                    updates2.add(new SDKUpdate.Peer(HMSPeerUpdate.ROLE_CHANGED, it));
                }
            }
            if (!Intrinsics.areEqual((Object)prevMetadata, (Object)newMetadata) && newMetadata != null) {
                it.setMetadata$lib_release(newMetadata);
                updates2.add(new SDKUpdate.Peer(HMSPeerUpdate.METADATA_CHANGED, it));
            }
            if (!Intrinsics.areEqual((Object)prevName, (Object)newName)) {
                it.setName$lib_release(newName);
                updates2.add(new SDKUpdate.Peer(HMSPeerUpdate.NAME_CHANGED, it));
            }
            if (wasHandRaised != isHandRaised) {
                it.setGroups$lib_release(params.getGroups());
                updates2.add(new SDKUpdate.Peer(HMSPeerUpdate.HAND_RAISED_CHANGED, it));
            }
        }
        return updates2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/sdk/managers/OnPeerUpdateManager$Companion;", "", "<init>", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

