/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats.clientside.sampler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.connection.stats.clientside.model.AudioAnalytics;
import live.hms.video.connection.stats.clientside.model.AudioSamplesPublish;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020)J\b\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003J\u001e\u0010.\u001a\u00020-2\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0003J\u0010\u00105\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0006\u00106\u001a\u00020)J\u0010\u00107\u001a\u0002082\b\b\u0002\u0010+\u001a\u00020)J\u0006\u00109\u001a\u00020-J\u0006\u0010:\u001a\u00020-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u001a\u0010\u001f\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0014R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0014\u00a8\u0006;"}, d2={"Llive/hms/video/connection/stats/clientside/sampler/PublishAudioStatsSampler;", "", "SAMPLE_DURATION", "", "trackId", "", "ssrc", "source", "<init>", "(DLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSAMPLE_DURATION", "()D", "getTrackId", "()Ljava/lang/String;", "getSsrc", "getSource", "localAudioSamples", "", "Llive/hms/video/connection/stats/clientside/model/AudioSamplesPublish;", "getLocalAudioSamples", "()Ljava/util/List;", "localAudioSamples$delegate", "Lkotlin/Lazy;", "START_AUDIO_SAMPLE_DURATION", "getSTART_AUDIO_SAMPLE_DURATION", "setSTART_AUDIO_SAMPLE_DURATION", "(D)V", "roundTripTimeMs", "", "jitterMs", "getJitterMs", "totalPacketsLost", "getTotalPacketsLost", "()J", "setTotalPacketsLost", "(J)V", "avgBitrateBps", "getAvgBitrateBps", "avgAvailableOutgoingBitrateBps", "getAvgAvailableOutgoingBitrateBps", "shouldSample", "", "currentTimeStamp", "force", "reset", "", "add", "availableOutgoingBitrate", "bitRate", "jitter", "packetLoss", "", "roundTripTime", "shouldSampleAudio", "hasSample", "getCollectedSamples", "Llive/hms/video/connection/stats/clientside/model/AudioAnalytics;", "resetSamples", "clearCurrentSampledStats", "lib_release"})
@SourceDebugExtension(value={"SMAP\nPublishAudioStatsSampler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishAudioStatsSampler.kt\nlive/hms/video/connection/stats/clientside/sampler/PublishAudioStatsSampler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1863#2,2:104\n*S KotlinDebug\n*F\n+ 1 PublishAudioStatsSampler.kt\nlive/hms/video/connection/stats/clientside/sampler/PublishAudioStatsSampler\n*L\n87#1:104,2\n*E\n"})
public final class PublishAudioStatsSampler {
    private final double SAMPLE_DURATION;
    @NotNull
    private final String trackId;
    @NotNull
    private final String ssrc;
    @NotNull
    private final String source;
    @NotNull
    private final Lazy localAudioSamples$delegate;
    private double START_AUDIO_SAMPLE_DURATION;
    @NotNull
    private final List<Long> roundTripTimeMs;
    @NotNull
    private final List<Double> jitterMs;
    private long totalPacketsLost;
    @NotNull
    private final List<Long> avgBitrateBps;
    @NotNull
    private final List<Long> avgAvailableOutgoingBitrateBps;

    public PublishAudioStatsSampler(double SAMPLE_DURATION, @NotNull String trackId, @NotNull String ssrc, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        Intrinsics.checkNotNullParameter((Object)ssrc, (String)"ssrc");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.SAMPLE_DURATION = SAMPLE_DURATION;
        this.trackId = trackId;
        this.ssrc = ssrc;
        this.source = source;
        this.localAudioSamples$delegate = LazyKt.lazy(PublishAudioStatsSampler::localAudioSamples_delegate$lambda$0);
        this.roundTripTimeMs = new ArrayList();
        this.jitterMs = new ArrayList();
        this.avgBitrateBps = new ArrayList();
        this.avgAvailableOutgoingBitrateBps = new ArrayList();
    }

    public /* synthetic */ PublishAudioStatsSampler(double d, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = "regular";
        }
        this(d, string, string2, string3);
    }

    public final double getSAMPLE_DURATION() {
        return this.SAMPLE_DURATION;
    }

    @NotNull
    public final String getTrackId() {
        return this.trackId;
    }

    @NotNull
    public final String getSsrc() {
        return this.ssrc;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    private final List<AudioSamplesPublish> getLocalAudioSamples() {
        Lazy lazy = this.localAudioSamples$delegate;
        return (List)lazy.getValue();
    }

    public final double getSTART_AUDIO_SAMPLE_DURATION() {
        return this.START_AUDIO_SAMPLE_DURATION;
    }

    public final void setSTART_AUDIO_SAMPLE_DURATION(double d) {
        this.START_AUDIO_SAMPLE_DURATION = d;
    }

    @NotNull
    public final List<Double> getJitterMs() {
        return this.jitterMs;
    }

    public final long getTotalPacketsLost() {
        return this.totalPacketsLost;
    }

    public final void setTotalPacketsLost(long l) {
        this.totalPacketsLost = l;
    }

    @NotNull
    public final List<Long> getAvgBitrateBps() {
        return this.avgBitrateBps;
    }

    @NotNull
    public final List<Long> getAvgAvailableOutgoingBitrateBps() {
        return this.avgAvailableOutgoingBitrateBps;
    }

    public final boolean shouldSample(double currentTimeStamp, boolean force) {
        if (this.shouldSampleAudio(currentTimeStamp) || force) {
            Collection collection = this.getLocalAudioSamples();
            long l = (long)currentTimeStamp;
            int n = this.roundTripTimeMs.isEmpty() ? 0 : (int)CollectionsKt.averageOfLong((Iterable)this.roundTripTimeMs);
            long l2 = this.avgAvailableOutgoingBitrateBps.isEmpty() ? 0L : (long)CollectionsKt.averageOfLong((Iterable)this.avgAvailableOutgoingBitrateBps);
            long l3 = this.avgBitrateBps.isEmpty() ? 0L : (long)CollectionsKt.averageOfLong((Iterable)this.avgBitrateBps);
            float f = this.jitterMs.isEmpty() ? 0.0f : (float)CollectionsKt.averageOfDouble((Iterable)this.jitterMs);
            long l4 = this.totalPacketsLost;
            collection.add(new AudioSamplesPublish(l, n, f, l4, l3, l2));
            this.reset();
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean shouldSample$default(PublishAudioStatsSampler publishAudioStatsSampler, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return publishAudioStatsSampler.shouldSample(d, bl);
    }

    private final void reset() {
        this.START_AUDIO_SAMPLE_DURATION = 0.0;
        this.roundTripTimeMs.clear();
        this.avgAvailableOutgoingBitrateBps.clear();
        this.jitterMs.clear();
        this.totalPacketsLost = 0L;
        this.avgBitrateBps.clear();
    }

    public final void add(double availableOutgoingBitrate, double bitRate) {
        if (!(availableOutgoingBitrate == 0.0)) {
            ((Collection)this.avgAvailableOutgoingBitrateBps).add((long)availableOutgoingBitrate);
        }
        ((Collection)this.avgBitrateBps).add((long)bitRate * 1000L);
    }

    public final void add(double jitter, int packetLoss, double roundTripTime) {
        ((Collection)this.roundTripTimeMs).add((long)(roundTripTime * (double)1000));
        this.totalPacketsLost = packetLoss;
        ((Collection)this.jitterMs).add(jitter * 1000.0);
    }

    private final boolean shouldSampleAudio(double currentTimeStamp) {
        if (this.START_AUDIO_SAMPLE_DURATION <= 0.0) {
            this.START_AUDIO_SAMPLE_DURATION = currentTimeStamp;
            return false;
        }
        if (currentTimeStamp - this.START_AUDIO_SAMPLE_DURATION >= this.SAMPLE_DURATION) {
            this.START_AUDIO_SAMPLE_DURATION = currentTimeStamp;
            return true;
        }
        return false;
    }

    public final boolean hasSample() {
        return !this.getLocalAudioSamples().isEmpty();
    }

    @NotNull
    public final AudioAnalytics getCollectedSamples(boolean force) {
        if (force) {
            this.shouldSample(System.currentTimeMillis(), force);
        }
        List local = new ArrayList();
        Iterable $this$forEach$iv = this.getLocalAudioSamples();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AudioSamplesPublish it = (AudioSamplesPublish)element$iv;
            boolean bl = false;
            local.add(AudioSamplesPublish.copy$default(it, 0L, 0, 0.0f, 0L, 0L, 0L, 63, null));
        }
        String string = this.trackId;
        String string2 = this.ssrc;
        String string3 = this.source;
        return new AudioAnalytics(local, string, string2, string3);
    }

    public static /* synthetic */ AudioAnalytics getCollectedSamples$default(PublishAudioStatsSampler publishAudioStatsSampler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return publishAudioStatsSampler.getCollectedSamples(bl);
    }

    public final void resetSamples() {
        this.getLocalAudioSamples().clear();
    }

    public final void clearCurrentSampledStats() {
        this.resetSamples();
        this.reset();
    }

    private static final List localAudioSamples_delegate$lambda$0() {
        return new ArrayList();
    }
}

