/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio.manager;

import androidx.annotation.RequiresApi;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.audio.manager.AudioManagerUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000eH\u0007R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llive/hms/video/audio/manager/AudioDeviceMapping;", "", "<init>", "()V", "systemDeviceTypeMap", "", "Llive/hms/video/audio/manager/AudioManagerUtil$AudioDevice;", "", "", "getEquivalentPlatformTypes", "audioDevice", "fromPlatformType", "type", "toHMSMapping", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "signalDeviceMapping", "toSignalMapping", "hmsDeviceMapping", "lib_release"})
@RequiresApi(value=31)
public final class AudioDeviceMapping {
    @NotNull
    public static final AudioDeviceMapping INSTANCE = new AudioDeviceMapping();
    @NotNull
    private static final Map<AudioManagerUtil.AudioDevice, List<Integer>> systemDeviceTypeMap;

    private AudioDeviceMapping() {
    }

    @JvmStatic
    @NotNull
    public static final List<Integer> getEquivalentPlatformTypes(@NotNull AudioManagerUtil.AudioDevice audioDevice) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioDevice), (String)"audioDevice");
        List<Integer> list = systemDeviceTypeMap.get((Object)audioDevice);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @JvmStatic
    @NotNull
    public static final AudioManagerUtil.AudioDevice fromPlatformType(int type) {
        for (AudioManagerUtil.AudioDevice kind : AudioManagerUtil.AudioDevice.values()) {
            if (!AudioDeviceMapping.getEquivalentPlatformTypes(kind).contains(type)) continue;
            return kind;
        }
        return AudioManagerUtil.AudioDevice.NONE;
    }

    @JvmStatic
    @NotNull
    public static final HMSAudioManager.AudioDevice toHMSMapping(@NotNull AudioManagerUtil.AudioDevice signalDeviceMapping) {
        HMSAudioManager.AudioDevice audioDevice;
        Intrinsics.checkNotNullParameter((Object)((Object)signalDeviceMapping), (String)"signalDeviceMapping");
        switch (WhenMappings.$EnumSwitchMapping$0[signalDeviceMapping.ordinal()]) {
            case 1: {
                audioDevice = HMSAudioManager.AudioDevice.BLUETOOTH;
                break;
            }
            case 2: {
                audioDevice = HMSAudioManager.AudioDevice.EARPIECE;
                break;
            }
            case 3: {
                audioDevice = HMSAudioManager.AudioDevice.SPEAKER_PHONE;
                break;
            }
            case 4: {
                audioDevice = HMSAudioManager.AudioDevice.WIRED_HEADSET;
                break;
            }
            case 5: {
                audioDevice = HMSAudioManager.AudioDevice.AUTOMATIC;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return audioDevice;
    }

    @JvmStatic
    @NotNull
    public static final AudioManagerUtil.AudioDevice toSignalMapping(@NotNull HMSAudioManager.AudioDevice hmsDeviceMapping) {
        AudioManagerUtil.AudioDevice audioDevice;
        Intrinsics.checkNotNullParameter((Object)((Object)hmsDeviceMapping), (String)"hmsDeviceMapping");
        switch (WhenMappings.$EnumSwitchMapping$1[hmsDeviceMapping.ordinal()]) {
            case 1: {
                audioDevice = AudioManagerUtil.AudioDevice.BLUETOOTH;
                break;
            }
            case 2: {
                audioDevice = AudioManagerUtil.AudioDevice.EARPIECE;
                break;
            }
            case 3: {
                audioDevice = AudioManagerUtil.AudioDevice.SPEAKER_PHONE;
                break;
            }
            case 4: {
                audioDevice = AudioManagerUtil.AudioDevice.WIRED_HEADSET;
                break;
            }
            case 5: {
                audioDevice = AudioManagerUtil.AudioDevice.NONE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return audioDevice;
    }

    static {
        Pair[] pairArray = new Pair[5];
        Object[] objectArray = new Integer[]{7, 26, 23};
        pairArray[0] = TuplesKt.to((Object)((Object)AudioManagerUtil.AudioDevice.BLUETOOTH), (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[1] = TuplesKt.to((Object)((Object)AudioManagerUtil.AudioDevice.EARPIECE), (Object)CollectionsKt.listOf((Object)1));
        objectArray = new Integer[]{2, 24};
        pairArray[2] = TuplesKt.to((Object)((Object)AudioManagerUtil.AudioDevice.SPEAKER_PHONE), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Integer[]{4, 3, 22};
        pairArray[3] = TuplesKt.to((Object)((Object)AudioManagerUtil.AudioDevice.WIRED_HEADSET), (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[4] = TuplesKt.to((Object)((Object)AudioManagerUtil.AudioDevice.NONE), (Object)CollectionsKt.emptyList());
        systemDeviceTypeMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AudioManagerUtil.AudioDevice.values().length];
            try {
                nArray[AudioManagerUtil.AudioDevice.BLUETOOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioManagerUtil.AudioDevice.EARPIECE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioManagerUtil.AudioDevice.SPEAKER_PHONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioManagerUtil.AudioDevice.WIRED_HEADSET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioManagerUtil.AudioDevice.NONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HMSAudioManager.AudioDevice.values().length];
            try {
                nArray[HMSAudioManager.AudioDevice.BLUETOOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.EARPIECE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.SPEAKER_PHONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.WIRED_HEADSET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.AUTOMATIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

