/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.tracks.HMSRemoteAudioTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSTrackUpdate;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Llive/hms/video/sdk/managers/OnTrackUpdateManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;", "store", "Llive/hms/video/sdk/SDKStore;", "<init>", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "data", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "peerId", "", "Companion", "lib_release"})
public final class OnTrackUpdateManager
implements IManager<HMSNotifications.TrackMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SDKStore store;
    @NotNull
    private static final String TAG = "OnTrackUpdateManager";

    public OnTrackUpdateManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.TrackMetadata params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List updates2 = new ArrayList();
        for (HMSNotifications.Track data : params.getTracks()) {
            updates2.addAll((Collection)this.manage(data, params.getPeer().getPeerId(), params));
        }
        return updates2;
    }

    @NotNull
    public final List<SDKUpdate> manage(@NotNull HMSNotifications.Track data, @NotNull String peerId, @Nullable HMSNotifications.TrackMetadata params) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
        List updates2 = new ArrayList();
        HMSPeer hmsPeer = null;
        hmsPeer = this.getStore().getPeerById(peerId);
        if (hmsPeer == null) {
            HMSNotifications.TrackMetadata trackMetadata = params;
            if (trackMetadata != null) {
                HMSNotifications.TrackMetadata it = trackMetadata;
                boolean bl = false;
                hmsPeer = this.getStore().add(it.getPeer().toPeerJoin());
            }
        }
        HMSPeer hMSPeer = hmsPeer;
        if (hMSPeer != null) {
            HMSPeer peer = hMSPeer;
            boolean bl = false;
            if (!(!peer.isLocal())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            HMSTrack hMSTrack = this.getStore().getNativeTrackById(data.getTrackId());
            if (hMSTrack != null) {
                HMSTrack track = hMSTrack;
                boolean bl2 = false;
                if (!(track instanceof HMSRemoteAudioTrack || track instanceof HMSRemoteVideoTrack)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (track.isMute() != data.isMute()) {
                    HMSTrackUpdate type = data.isMute() ? HMSTrackUpdate.TRACK_MUTED : HMSTrackUpdate.TRACK_UNMUTED;
                    updates2.add(new SDKUpdate.Track(type, track, peer));
                }
                if (!Intrinsics.areEqual((Object)track.getDescription(), (Object)data.getDescription())) {
                    updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_DESCRIPTION_CHANGED, track, peer));
                }
                this.getStore().updateRTCTrack(data);
            } else {
                SDKStore.TrackMetadataPair trackMetadataPair = this.getStore().getTrackMetadata(data.getTrackId());
                if (trackMetadataPair != null) {
                    SDKStore.TrackMetadataPair it = trackMetadataPair;
                    boolean bl3 = false;
                    this.getStore().updateTrackMetaData(peerId, data);
                } else {
                    HMSLogger.e(TAG, "onTrackUpdateNotification: Cannot find track for " + data + ", peer=" + peer);
                }
            }
        } else {
            HMSLogger.e(TAG, "onTrackUpdateNotification: Cannot find respective peer for track=" + data + " , store=" + this.getStore());
        }
        return updates2;
    }

    public static /* synthetic */ List manage$default(OnTrackUpdateManager onTrackUpdateManager, HMSNotifications.Track track, String string, HMSNotifications.TrackMetadata trackMetadata, int n, Object object) {
        if ((n & 4) != 0) {
            trackMetadata = null;
        }
        return onTrackUpdateManager.manage(track, string, trackMetadata);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/sdk/managers/OnTrackUpdateManager$Companion;", "", "<init>", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

