/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.services;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.Nullable;
import hms.webrtc.CapturerObserver;
import hms.webrtc.SurfaceTextureHelper;
import hms.webrtc.ThreadUtils;
import hms.webrtc.VideoCapturer;
import hms.webrtc.VideoFrame;
import hms.webrtc.VideoSink;

public class ScreenCapturerAndroidCustom
implements VideoCapturer,
VideoSink {
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private final Intent mediaProjectionPermissionResultData;
    private final MediaProjection.Callback mediaProjectionCallback;
    private int width;
    private int height;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private CapturerObserver capturerObserver;
    private long numCapturedFrames;
    @Nullable
    private MediaProjection mediaProjection;
    private boolean isDisposed;
    @Nullable
    private MediaProjectionManager mediaProjectionManager;

    public ScreenCapturerAndroidCustom(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback) {
        this.mediaProjectionPermissionResultData = mediaProjectionPermissionResultData;
        this.mediaProjectionCallback = mediaProjectionCallback;
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new RuntimeException("capturer is disposed.");
        }
    }

    @Nullable
    public MediaProjection getMediaProjection() {
        return this.mediaProjection;
    }

    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = capturerObserver;
        if (surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.mediaProjectionManager = (MediaProjectionManager)applicationContext.getSystemService("media_projection");
    }

    public synchronized void startCapture(int width, int height, int ignoredFramerate) {
        this.checkNotDisposed();
        this.width = width;
        this.height = height;
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.startListening((VideoSink)this);
    }

    public synchronized void stopCapture() {
        this.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.surfaceTextureHelper.getHandler(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenCapturerAndroidCustom.this.surfaceTextureHelper.stopListening();
                ScreenCapturerAndroidCustom.this.capturerObserver.onCapturerStopped();
                if (ScreenCapturerAndroidCustom.this.virtualDisplay != null) {
                    ScreenCapturerAndroidCustom.this.virtualDisplay.release();
                    ScreenCapturerAndroidCustom.this.virtualDisplay = null;
                }
                if (ScreenCapturerAndroidCustom.this.mediaProjection != null) {
                    ScreenCapturerAndroidCustom.this.mediaProjection.unregisterCallback(ScreenCapturerAndroidCustom.this.mediaProjectionCallback);
                    ScreenCapturerAndroidCustom.this.mediaProjection.stop();
                    ScreenCapturerAndroidCustom.this.mediaProjection = null;
                }
            }
        });
    }

    public synchronized void dispose() {
        this.isDisposed = true;
    }

    public synchronized void changeCaptureFormat(int width, int height, int ignoredFramerate) {
        this.checkNotDisposed();
        this.width = width;
        this.height = height;
        if (this.virtualDisplay == null) {
            return;
        }
        if (this.virtualDisplay != null) {
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.surfaceTextureHelper.getHandler(), () -> {
                this.surfaceTextureHelper.setTextureSize(width, height);
                if (Build.VERSION.SDK_INT >= 28) {
                    Log.d((String)"XYZ", (String)("Resizing virtual display to " + width + "x" + height));
                    this.virtualDisplay.resize(width, height, 400);
                } else {
                    Log.d((String)"XYZ", (String)("Recreating virtual display to " + width + "x" + height));
                    this.virtualDisplay.release();
                    this.createVirtualDisplay();
                }
            });
        }
    }

    private void createVirtualDisplay() {
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.width, this.height, 400, 3, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    public void onFrame(VideoFrame frame) {
        ++this.numCapturedFrames;
        this.capturerObserver.onFrameCaptured(frame);
    }

    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }
}

