/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories;

import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import hms.webrtc.AudioProcessingFactory;
import hms.webrtc.EglBase;
import hms.webrtc.Logging;
import hms.webrtc.PeerConnectionFactory;
import hms.webrtc.VideoDecoderFactory;
import hms.webrtc.VideoEncoderFactory;
import hms.webrtc.audio.AudioDeviceModule;
import hms.webrtc.audio.JavaAudioDeviceModule;
import hms.webrtc.audio.WebRtcAudioRecord;
import hms.webrtc.audio.WebRtcAudioTrack;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import live.hms.video.encoder.video.SimulcastVideoEncoderFactoryWrapper;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.factories.HMSPeerConnectionFactory;
import live.hms.video.factories.HMSVideoDecoderFactory;
import live.hms.video.factories.SafeVariable;
import live.hms.video.factories.noisecancellation.NoiseCancellation;
import live.hms.video.factories.noisecancellation.NoiseCancellationFactoryImpl;
import live.hms.video.factories.noisecancellation.NoiseCancellationStatusChecker;
import live.hms.video.media.capturers.HMSWavCapturer;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.models.enums.AudioMixingMode;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import live.hms.video.utils.SharedEglContext;
import live.hms.video.utils.WertcAudioUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0004\u000e\u0013\u0016\u0019\b\u0000\u0018\u0000 \u0086\u00012\u00020\u0001:\u0002\u0086\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010_\u001a\u00020`H\u0003J\"\u0010a\u001a\n c*\u0004\u0018\u00010b0b2\b\b\u0002\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020`2\u0006\u0010i\u001a\u00020jH\u0003J\b\u0010k\u001a\u00020`H\u0002J\b\u0010l\u001a\u00020`H\u0002J\u001e\u0010m\u001a\u00020`2\u0006\u0010f\u001a\u00020g2\u0006\u0010d\u001a\u00020e2\u0006\u0010n\u001a\u00020eJ\u0010\u0010o\u001a\u00020`2\u0006\u0010p\u001a\u00020\u001eH\u0002J\n\u0010q\u001a\u0004\u0018\u00010rH\u0002J\u0010\u0010s\u001a\u00020`2\u0006\u0010p\u001a\u00020\u001eH\u0002J \u0010t\u001a\u00020:2\u0006\u0010u\u001a\u00020:2\u0006\u0010v\u001a\u00020\u001c2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020`2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010z\u001a\u00020`2\u0006\u0010{\u001a\u00020|H\u0002J\u000e\u0010}\u001a\u00020`2\u0006\u0010~\u001a\u00020\nJ\u0018\u0010\u007f\u001a\u00020`2\u0006\u0010i\u001a\u00020j2\u0006\u0010~\u001a\u00020\nH\u0007J\u0011\u0010\u0080\u0001\u001a\u00020`2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\u0007\u0010\u0083\u0001\u001a\u00020`J\u001a\u0010\u0084\u0001\u001a\u00020`2\u0007\u0010\u0085\u0001\u001a\u00020\u001c2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R \u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000202X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u00107\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010=\u001a\u00020<2\u0006\u0010;\u001a\u00020<8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR+\u0010E\u001a\u00020D2\u0006\u0010;\u001a\u00020D8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bJ\u0010C\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001b\u0010K\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bM\u0010NR+\u0010R\u001a\u00020Q2\u0006\u0010;\u001a\u00020Q8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bW\u0010C\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR+\u0010Y\u001a\u00020X2\u0006\u0010;\u001a\u00020X8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b^\u0010C\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]\u00a8\u0006\u0087\u0001"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory;", "", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "ncStatusChecker", "Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;)V", "_audioMixingMode", "Llive/hms/video/sdk/models/enums/AudioMixingMode;", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "audioBufferCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioBufferCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioBufferCallback$1;", "audioManager", "Landroid/media/AudioManager;", "audioRecordErrorCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioRecordErrorCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioRecordErrorCallback$1;", "audioRecordStateCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioRecordStateCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioRecordStateCallback$1;", "audioTrackErrorCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioTrackErrorCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioTrackErrorCallback$1;", "capacity", "", "combinedByteBuffer", "Ljava/nio/ByteBuffer;", "getContext", "()Landroid/content/Context;", "factory", "Llive/hms/video/factories/SafeVariable;", "Lhms/webrtc/PeerConnectionFactory;", "getFactory", "()Llive/hms/video/factories/SafeVariable;", "setFactory", "(Llive/hms/video/factories/SafeVariable;)V", "inputSampleRate", "isSystemAudioCaptureEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mAudioRecord", "Landroid/media/AudioRecord;", "getNcStatusChecker", "()Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "nextSchedulerId", "Ljava/util/concurrent/atomic/AtomicInteger;", "noiseCancellation", "Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "getNoiseCancellation", "()Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "setNoiseCancellation", "(Llive/hms/video/factories/noisecancellation/NoiseCancellation;)V", "outputSampleRate", "systemAudioByteBuffer", "systemAudioShortArray", "", "<set-?>", "Lhms/webrtc/VideoDecoderFactory;", "videoDecoderFactory", "getVideoDecoderFactory", "()Lhms/webrtc/VideoDecoderFactory;", "setVideoDecoderFactory", "(Lhms/webrtc/VideoDecoderFactory;)V", "videoDecoderFactory$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lhms/webrtc/VideoEncoderFactory;", "videoEncoderFactory", "getVideoEncoderFactory", "()Lhms/webrtc/VideoEncoderFactory;", "setVideoEncoderFactory", "(Lhms/webrtc/VideoEncoderFactory;)V", "videoEncoderFactory$delegate", "wavCapturer", "Llive/hms/video/media/capturers/HMSWavCapturer;", "getWavCapturer", "()Llive/hms/video/media/capturers/HMSWavCapturer;", "wavCapturer$delegate", "Lkotlin/Lazy;", "Lhms/webrtc/audio/WebRtcAudioTrack;", "webRtcAudioTrack", "getWebRtcAudioTrack", "()Lhms/webrtc/audio/WebRtcAudioTrack;", "setWebRtcAudioTrack", "(Lhms/webrtc/audio/WebRtcAudioTrack;)V", "webRtcAudioTrack$delegate", "Lhms/webrtc/audio/WebRtcAudioRecord;", "webrtcAudioRecord", "getWebrtcAudioRecord", "()Lhms/webrtc/audio/WebRtcAudioRecord;", "setWebrtcAudioRecord", "(Lhms/webrtc/audio/WebRtcAudioRecord;)V", "webrtcAudioRecord$delegate", "captureSystemAudio", "", "getPeerConnectionFactoryBuilder", "Lhms/webrtc/PeerConnectionFactory$Builder;", "kotlin.jvm.PlatformType", "isSimulcastEnabled", "", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "initAudioRecorder", "mMediaProjection", "Landroid/media/projection/MediaProjection;", "initPeerConnectionFactory", "initchunk", "initialize", "serverSoftwareEchoCancellationEnabled", "mixAudioBytes", "micAudioByteBuffer", "newDefaultScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "scaleUpMicVolume", "scaleValues", "buff", "len", "scale", "", "sendAECAnalytics", "sendMicCaptureFailedEvent", "errorMessage", "", "setAudioMixingMode", "audioMixingMode", "startAudioMixing", "stopAudioFromRawFile", "hmsActionResultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "stopAudioMixing", "streamAndPlayAudioFromRawFile", "audioResourceId", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSPeerConnectionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSPeerConnectionFactory.kt\nlive/hms/video/factories/HMSPeerConnectionFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,579:1\n1#2:580\n*E\n"})
public final class HMSPeerConnectionFactory {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final NoiseCancellationStatusChecker ncStatusChecker;
    public NoiseCancellation noiseCancellation;
    @NotNull
    private final ReadWriteProperty videoEncoderFactory$delegate;
    @NotNull
    private final ReadWriteProperty videoDecoderFactory$delegate;
    @NotNull
    private SafeVariable<PeerConnectionFactory> factory;
    @NotNull
    private final ReadWriteProperty webrtcAudioRecord$delegate;
    @NotNull
    private final ReadWriteProperty webRtcAudioTrack$delegate;
    @NotNull
    private AudioMixingMode _audioMixingMode;
    @NotNull
    private AtomicInteger nextSchedulerId;
    @NotNull
    private final AudioManager audioManager;
    private final int inputSampleRate;
    private final int outputSampleRate;
    @NotNull
    private final audioRecordErrorCallback.1 audioRecordErrorCallback;
    @NotNull
    private final audioTrackErrorCallback.1 audioTrackErrorCallback;
    @NotNull
    private final audioRecordStateCallback.1 audioRecordStateCallback;
    private ByteBuffer systemAudioByteBuffer;
    private short[] systemAudioShortArray;
    private ByteBuffer combinedByteBuffer;
    private int capacity;
    @Nullable
    private AudioRecord mAudioRecord;
    @NotNull
    private final audioBufferCallback.1 audioBufferCallback;
    @NotNull
    private final AtomicBoolean isSystemAudioCaptureEnabled;
    @NotNull
    private final Lazy wavCapturer$delegate;
    @NotNull
    private static final String TAG = "HMSPeerConnectionFactory";
    @NotNull
    private static final String PREF_AEC_EVENT_KEY = "aec_event";
    private static final boolean PREF_AEC_EVENT_DEFAULT = false;
    private static final int DEFAULT_AUDIO_FORMAT = 2;
    private static final int DEFAULT_AUDIO_SOURCE = 7;
    private static final int INPUT_BITS_PER_SAMPLE = 16;
    private static final int OUTPUT_BITS_PER_SAMPLE = 16;
    private static final int INPUT_NUM_OF_CHANNELS = 1;
    private static final int OUTPUT_NUM_OF_CHANNELS = 1;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final float MIC_VOLUME_SCALE = 5.0f;
    private static final float FILE_VOLUME_SCALE = 0.1f;

    public HMSPeerConnectionFactory(@NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService2, @NotNull NoiseCancellationStatusChecker ncStatusChecker2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)ncStatusChecker2, (String)"ncStatusChecker");
        this.context = context;
        this.analyticsEventsService = analyticsEventsService2;
        this.ncStatusChecker = ncStatusChecker2;
        this.videoEncoderFactory$delegate = Delegates.INSTANCE.notNull();
        this.videoDecoderFactory$delegate = Delegates.INSTANCE.notNull();
        this.factory = new SafeVariable();
        this.webrtcAudioRecord$delegate = Delegates.INSTANCE.notNull();
        this.webRtcAudioTrack$delegate = Delegates.INSTANCE.notNull();
        this._audioMixingMode = AudioMixingMode.TALK_AND_MUSIC;
        this.nextSchedulerId = new AtomicInteger(0);
        Object object = this.context.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object;
        this.inputSampleRate = WertcAudioUtils.Companion.getSampleRate(this.audioManager);
        this.outputSampleRate = WertcAudioUtils.Companion.getSampleRate(this.audioManager);
        this.audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebRtcAudioRecordInitError(@Nullable String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioRecordStartError(@Nullable JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @Nullable String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioRecordError(@Nullable String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }
        };
        this.audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebRtcAudioTrackInitError(@Nullable String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordInitError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioTrackStartError(@Nullable JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @Nullable String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioTrackError(@Nullable String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }
        };
        this.audioRecordStateCallback = new JavaAudioDeviceModule.AudioRecordStateCallback(){

            public void onWebRtcAudioRecordStart() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStart ~~");
            }

            public void onWebRtcAudioRecordStop() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStop ~~");
            }
        };
        this.audioBufferCallback = new WebRtcAudioRecord.AudioBufferCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBuffer(@Nullable ByteBuffer micByteBuffer, int micBytesRead) {
                long startTime = System.currentTimeMillis();
                if (HMSPeerConnectionFactory.access$get_audioMixingMode$p(this.this$0) == AudioMixingMode.TALK_AND_MUSIC || HMSPeerConnectionFactory.access$get_audioMixingMode$p(this.this$0) == AudioMixingMode.MUSIC_ONLY) {
                    HMSLogger.d("AudioMixing", "Mixing system audio and mic data");
                    if (HMSPeerConnectionFactory.access$getWavCapturer(this.this$0).isStarted().get()) {
                        HMSWavCapturer hMSWavCapturer = HMSPeerConnectionFactory.access$getWavCapturer(this.this$0);
                        ByteBuffer byteBuffer = HMSPeerConnectionFactory.access$getSystemAudioByteBuffer$p(this.this$0);
                        if (byteBuffer == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
                            byteBuffer = null;
                        }
                        hMSWavCapturer.readNext10ms(byteBuffer);
                    } else {
                        HMSPeerConnectionFactory.access$getWebrtcAudioRecord(this.this$0).isMixingNeeded(false);
                    }
                    if (HMSPeerConnectionFactory.access$isSystemAudioCaptureEnabled$p(this.this$0).get() && Build.VERSION.SDK_INT >= 29) {
                        HMSPeerConnectionFactory.access$getWebrtcAudioRecord(this.this$0).isMixingNeeded(true);
                        HMSPeerConnectionFactory.access$captureSystemAudio(this.this$0);
                    }
                    ByteBuffer byteBuffer = micByteBuffer;
                    if (byteBuffer != null) {
                        ByteBuffer byteBuffer2 = byteBuffer;
                        HMSPeerConnectionFactory hMSPeerConnectionFactory = this.this$0;
                        ByteBuffer it = byteBuffer2;
                        boolean bl = false;
                        HMSPeerConnectionFactory.access$mixAudioBytes(hMSPeerConnectionFactory, it);
                    }
                } else {
                    HMSLogger.d("AudioMixing", "Not Mixing system audio and mic data :: TALK_MODE");
                    ByteBuffer byteBuffer = micByteBuffer;
                    if (byteBuffer != null) {
                        ByteBuffer it = byteBuffer;
                        boolean bl = false;
                    }
                }
                long endTime = System.currentTimeMillis();
                long timeTaken = endTime - startTime;
                HMSLogger.d("HMSPeerConnectionFactory", " Callback took " + timeTaken + " ms to finish");
            }
        };
        this.isSystemAudioCaptureEnabled = new AtomicBoolean(false);
        this.wavCapturer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HMSWavCapturer>(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HMSWavCapturer invoke() {
                return new HMSWavCapturer(this.this$0.getContext(), 48000, 0, 0, 12, null);
            }
        }));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    @NotNull
    public final NoiseCancellationStatusChecker getNcStatusChecker() {
        return this.ncStatusChecker;
    }

    @NotNull
    public final NoiseCancellation getNoiseCancellation() {
        NoiseCancellation noiseCancellation = this.noiseCancellation;
        if (noiseCancellation != null) {
            return noiseCancellation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"noiseCancellation");
        return null;
    }

    public final void setNoiseCancellation(@NotNull NoiseCancellation noiseCancellation) {
        Intrinsics.checkNotNullParameter((Object)noiseCancellation, (String)"<set-?>");
        this.noiseCancellation = noiseCancellation;
    }

    private final VideoEncoderFactory getVideoEncoderFactory() {
        return (VideoEncoderFactory)this.videoEncoderFactory$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.videoEncoderFactory$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)videoEncoderFactory);
    }

    private final VideoDecoderFactory getVideoDecoderFactory() {
        return (VideoDecoderFactory)this.videoDecoderFactory$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        this.videoDecoderFactory$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)videoDecoderFactory);
    }

    @NotNull
    public final SafeVariable<PeerConnectionFactory> getFactory() {
        return this.factory;
    }

    public final void setFactory(@NotNull SafeVariable<PeerConnectionFactory> safeVariable) {
        Intrinsics.checkNotNullParameter(safeVariable, (String)"<set-?>");
        this.factory = safeVariable;
    }

    private final WebRtcAudioRecord getWebrtcAudioRecord() {
        return (WebRtcAudioRecord)this.webrtcAudioRecord$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setWebrtcAudioRecord(WebRtcAudioRecord webRtcAudioRecord) {
        this.webrtcAudioRecord$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)webRtcAudioRecord);
    }

    private final WebRtcAudioTrack getWebRtcAudioTrack() {
        return (WebRtcAudioTrack)this.webRtcAudioTrack$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setWebRtcAudioTrack(WebRtcAudioTrack webRtcAudioTrack) {
        this.webRtcAudioTrack$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)webRtcAudioTrack);
    }

    private final void scaleUpMicVolume(ByteBuffer micAudioByteBuffer) {
        ShortBuffer micAudioShortBuffer = micAudioByteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] micAudioShortArray = new short[micAudioByteBuffer.limit() / 2];
        micAudioShortBuffer.get(micAudioShortArray);
        this.scaleValues(micAudioShortArray, micAudioShortArray.length, 5.0f);
    }

    @RequiresApi(value=29)
    private final void captureSystemAudio() {
        ByteBuffer byteBuffer;
        AudioRecord audioRecord = this.mAudioRecord;
        Intrinsics.checkNotNull((Object)audioRecord);
        ByteBuffer byteBuffer2 = this.systemAudioByteBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer2 = null;
        }
        if ((byteBuffer = this.systemAudioByteBuffer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer = null;
        }
        int capturedNumOfBytes = audioRecord.read(byteBuffer2, byteBuffer.capacity(), 0);
        HMSLogger.d("AudioMixing", "Read " + capturedNumOfBytes + " bytes of System audio buffer");
    }

    private final void mixAudioBytes(ByteBuffer micAudioByteBuffer) {
        micAudioByteBuffer.position(0);
        ByteBuffer byteBuffer = this.systemAudioByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer = null;
        }
        byteBuffer.position(0);
        ShortBuffer micAudioShortBuffer = micAudioByteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] micAudioShortArray = new short[micAudioByteBuffer.limit() / 2];
        micAudioShortBuffer.get(micAudioShortArray);
        ByteBuffer byteBuffer2 = this.systemAudioByteBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer2 = null;
        }
        ShortBuffer shortBuffer = byteBuffer2.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] sArray = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray = null;
        }
        shortBuffer.get(sArray);
        this.scaleValues(micAudioShortArray, micAudioShortArray.length, 5.0f);
        short[] sArray2 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray2 = null;
        }
        short[] sArray3 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray3 = null;
        }
        this.scaleValues(sArray2, sArray3.length, 0.1f);
        int n = micAudioShortArray.length;
        short[] sArray4 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray4 = null;
        }
        short[] sArray5 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray5 = null;
        }
        byte[] combinedByteArray = HMSUtils.INSTANCE.addAndConvertBuffers(micAudioShortArray, n, sArray4, sArray5.length);
        ByteBuffer byteBuffer3 = ByteBuffer.wrap(combinedByteArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"wrap(combinedByteArray)");
        this.combinedByteBuffer = byteBuffer3;
        micAudioByteBuffer.clear();
        if (this._audioMixingMode == AudioMixingMode.TALK_AND_MUSIC) {
            HMSLogger.d("AudioMixing", "Adding combinedByteBuffer");
            ByteBuffer byteBuffer4 = this.combinedByteBuffer;
            if (byteBuffer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"combinedByteBuffer");
                byteBuffer4 = null;
            }
            micAudioByteBuffer.put(byteBuffer4);
        } else if (this._audioMixingMode == AudioMixingMode.MUSIC_ONLY) {
            HMSLogger.d("AudioMixing", "Adding systemAudioByteBuffer");
            ByteBuffer byteBuffer5 = this.systemAudioByteBuffer;
            if (byteBuffer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
                byteBuffer5 = null;
            }
            micAudioByteBuffer.put(byteBuffer5);
        }
    }

    public final void initialize(@NotNull HMSTrackSettings hmsTrackSettings, boolean isSimulcastEnabled, boolean serverSoftwareEchoCancellationEnabled) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        this.factory.initialize((Function0<PeerConnectionFactory>)((Function0)new Function0<PeerConnectionFactory>(this, hmsTrackSettings, serverSoftwareEchoCancellationEnabled, isSimulcastEnabled){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            final /* synthetic */ HMSTrackSettings $hmsTrackSettings;
            final /* synthetic */ boolean $serverSoftwareEchoCancellationEnabled;
            final /* synthetic */ boolean $isSimulcastEnabled;
            {
                this.this$0 = $receiver;
                this.$hmsTrackSettings = $hmsTrackSettings;
                this.$serverSoftwareEchoCancellationEnabled = $serverSoftwareEchoCancellationEnabled;
                this.$isSimulcastEnabled = $isSimulcastEnabled;
                super(0);
            }

            @NotNull
            public final PeerConnectionFactory invoke() {
                HMSPeerConnectionFactory.access$initPeerConnectionFactory(this.this$0);
                boolean isBuiltInAcousticEchoCancelerSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
                boolean useHardwareAcousticEchoCanceler = false;
                if (isBuiltInAcousticEchoCancelerSupported) {
                    boolean bl;
                    HMSAudioTrackSettings hMSAudioTrackSettings = this.$hmsTrackSettings.getAudioSettings();
                    if ((hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getUseHardwareAcousticEchoCanceler() : null) == null) {
                        bl = !this.$serverSoftwareEchoCancellationEnabled;
                    } else {
                        Boolean bl2 = this.$hmsTrackSettings.getAudioSettings().getUseHardwareAcousticEchoCanceler();
                        bl = bl2 != null ? bl2 : true;
                    }
                    useHardwareAcousticEchoCanceler = bl;
                }
                boolean useHardwareNoiseSuppressor = JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported();
                HMSPeerConnectionFactory.access$setWebrtcAudioRecord(this.this$0, new WebRtcAudioRecord(this.this$0.getContext(), HMSPeerConnectionFactory.access$newDefaultScheduler(this.this$0), HMSPeerConnectionFactory.access$getAudioManager$p(this.this$0), 7, 2, (JavaAudioDeviceModule.AudioRecordErrorCallback)HMSPeerConnectionFactory.access$getAudioRecordErrorCallback$p(this.this$0), (JavaAudioDeviceModule.AudioRecordStateCallback)HMSPeerConnectionFactory.access$getAudioRecordStateCallback$p(this.this$0), null, useHardwareAcousticEchoCanceler, useHardwareNoiseSuppressor));
                HMSPeerConnectionFactory.access$setWebRtcAudioTrack(this.this$0, new WebRtcAudioTrack(this.this$0.getContext(), HMSPeerConnectionFactory.access$getAudioManager$p(this.this$0), null, (JavaAudioDeviceModule.AudioTrackErrorCallback)HMSPeerConnectionFactory.access$getAudioTrackErrorCallback$p(this.this$0), null, false, false));
                JavaAudioDeviceModule customAudioDeviceModule = new JavaAudioDeviceModule(this.this$0.getContext(), HMSPeerConnectionFactory.access$getAudioManager$p(this.this$0), HMSPeerConnectionFactory.access$getWebrtcAudioRecord(this.this$0), HMSPeerConnectionFactory.access$getWebRtcAudioTrack(this.this$0), HMSPeerConnectionFactory.access$getInputSampleRate$p(this.this$0), HMSPeerConnectionFactory.access$getOutputSampleRate$p(this.this$0), false, false);
                PeerConnectionFactory.Builder builder = HMSPeerConnectionFactory.access$getPeerConnectionFactoryBuilder(this.this$0, this.$isSimulcastEnabled, this.$hmsTrackSettings);
                PeerConnectionFactory peerConnectionFactory = builder.setAudioDeviceModule((AudioDeviceModule)customAudioDeviceModule).createPeerConnectionFactory();
                HMSPeerConnectionFactory.access$sendAECAnalytics(this.this$0, this.this$0.getContext());
                Intrinsics.checkNotNullExpressionValue((Object)peerConnectionFactory, (String)"peerConnectionFactory");
                return peerConnectionFactory;
            }
        }));
    }

    @RequiresApi(value=29)
    public final void startAudioMixing(@NotNull MediaProjection mMediaProjection, @NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)mMediaProjection, (String)"mMediaProjection");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        HMSLogger.d("AudioMixing", "starting audio mixing in " + (Object)((Object)audioMixingMode) + " mode");
        this.initAudioRecorder(mMediaProjection);
        this.initchunk();
        this.isSystemAudioCaptureEnabled.set(true);
        this.getWebrtcAudioRecord().setBufferCallback((WebRtcAudioRecord.AudioBufferCallback)this.audioBufferCallback);
        this._audioMixingMode = audioMixingMode;
        this.getWebrtcAudioRecord().isMixingNeeded(true);
    }

    public final void setAudioMixingMode(@NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        HMSLogger.d("AudioMixing", "setting Audio Mixing mode to " + (Object)((Object)audioMixingMode));
        this._audioMixingMode = audioMixingMode;
    }

    @RequiresApi(value=29)
    private final void initAudioRecorder(MediaProjection mMediaProjection) {
        int size = AudioRecord.getMinBufferSize((int)this.inputSampleRate, (int)16, (int)2);
        AudioFormat format = new AudioFormat.Builder().setEncoding(2).setSampleRate(this.inputSampleRate).setChannelMask(4).build();
        AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = new AudioPlaybackCaptureConfiguration.Builder(mMediaProjection).addMatchingUsage(1).addMatchingUsage(0).addMatchingUsage(14).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioPlaybackCaptureConfiguration, (String)"Builder(mMediaProjection\u2026SAGE_GAME)\n      .build()");
        AudioPlaybackCaptureConfiguration playbackConfig = audioPlaybackCaptureConfiguration;
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECORD_AUDIO") != 0) {
            return;
        }
        AudioRecord audioRecord = this.mAudioRecord = new AudioRecord.Builder().setAudioFormat(format).setAudioPlaybackCaptureConfig(playbackConfig).build();
        Intrinsics.checkNotNull((Object)audioRecord);
        audioRecord.startRecording();
    }

    private final void initchunk() {
        int bytesPerFrame = 2;
        this.capacity = bytesPerFrame * (this.inputSampleRate / 100);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.capacity).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(capacity)\u2026(ByteOrder.nativeOrder())");
        this.systemAudioByteBuffer = byteBuffer;
        ByteBuffer byteBuffer2 = this.systemAudioByteBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer2 = null;
        }
        this.systemAudioShortArray = new short[byteBuffer2.capacity() / 2];
    }

    public final void stopAudioMixing() {
        this.isSystemAudioCaptureEnabled.set(false);
        HMSLogger.d("AudioMixing", "stopping Audio mixing");
        this.getWebrtcAudioRecord().isMixingNeeded(false);
    }

    private final PeerConnectionFactory.Builder getPeerConnectionFactoryBuilder(boolean isSimulcastEnabled, HMSTrackSettings hmsTrackSettings) {
        PeerConnectionFactory.Builder builder;
        PeerConnectionFactory.Builder $this$getPeerConnectionFactoryBuilder_u24lambda_u240 = builder = PeerConnectionFactory.builder();
        boolean bl = false;
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        $this$getPeerConnectionFactoryBuilder_u24lambda_u240.setOptions(options);
        HMSVideoTrackSettings hMSVideoTrackSettings = hmsTrackSettings.getVideoSettings();
        this.setVideoEncoderFactory(new SimulcastVideoEncoderFactoryWrapper(SharedEglContext.INSTANCE.getContext(), false, false, hMSVideoTrackSettings != null ? hMSVideoTrackSettings.getForceSoftwareEncoder() : false, 6, null));
        EglBase.Context context = SharedEglContext.INSTANCE.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"SharedEglContext.context");
        HMSVideoTrackSettings hMSVideoTrackSettings2 = hmsTrackSettings.getVideoSettings();
        this.setVideoDecoderFactory((VideoDecoderFactory)new HMSVideoDecoderFactory(context, hMSVideoTrackSettings2 != null ? hMSVideoTrackSettings2.getForceSoftwareDecoder() : false));
        $this$getPeerConnectionFactoryBuilder_u24lambda_u240.setVideoEncoderFactory(this.getVideoEncoderFactory());
        $this$getPeerConnectionFactoryBuilder_u24lambda_u240.setVideoDecoderFactory(this.getVideoDecoderFactory());
        this.setNoiseCancellation(new NoiseCancellationFactoryImpl(this.ncStatusChecker).jniLoad(this.context));
        HMSAudioTrackSettings hMSAudioTrackSettings = hmsTrackSettings.getAudioSettings();
        AudioProcessingFactory audioProcessingFactory = this.getNoiseCancellation().getAudioProcessingFactory(hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getEnableNoiseCancellation() : false);
        if (audioProcessingFactory != null) {
            $this$getPeerConnectionFactoryBuilder_u24lambda_u240.setAudioProcessingFactory(audioProcessingFactory);
        }
        return builder;
    }

    static /* synthetic */ PeerConnectionFactory.Builder getPeerConnectionFactoryBuilder$default(HMSPeerConnectionFactory hMSPeerConnectionFactory, boolean bl, HMSTrackSettings hMSTrackSettings, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return hMSPeerConnectionFactory.getPeerConnectionFactoryBuilder(bl, hMSTrackSettings);
    }

    private final void initPeerConnectionFactory() {
        PeerConnectionFactory.InitializationOptions.Builder builder;
        PeerConnectionFactory.InitializationOptions.Builder $this$initPeerConnectionFactory_u24lambda_u242 = builder = PeerConnectionFactory.InitializationOptions.builder((Context)this.context);
        boolean bl = false;
        $this$initPeerConnectionFactory_u24lambda_u242.setFieldTrials("WebRTC-H264HighProfile/Enabled/WebRTC-MediaCodecVideoEncoder-AutomaticResize/Enabled/WebRTC-UseDifferentiatedCellularCosts/Enabled/");
        $this$initPeerConnectionFactory_u24lambda_u242.setInjectableLogger(HMSPeerConnectionFactory::initPeerConnectionFactory$lambda$2$lambda$1, Logging.Severity.LS_VERBOSE);
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)builder.createInitializationOptions());
    }

    private final short[] scaleValues(short[] buff, int len, float scale) {
        for (int i = 0; i < len; ++i) {
            short oldValue = buff[i];
            int newValue = (int)((float)buff[i] * scale);
            if (newValue > Short.MAX_VALUE) {
                newValue = Short.MAX_VALUE;
            } else if (newValue < Short.MIN_VALUE) {
                newValue = Short.MIN_VALUE;
            }
            buff[i] = (short)newValue;
        }
        return buff;
    }

    private final ScheduledExecutorService newDefaultScheduler() {
        AtomicInteger nextThreadId = new AtomicInteger(0);
        return Executors.newScheduledThreadPool(0, arg_0 -> HMSPeerConnectionFactory.newDefaultScheduler$lambda$3(this, nextThreadId, arg_0));
    }

    private final void sendAECAnalytics(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean isAECEventSent = sharedPreferences.getBoolean(PREF_AEC_EVENT_KEY, false);
        if (!isAECEventSent) {
            boolean isHardwareAECSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
            AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioEchoCancellation(isHardwareAECSupported);
            this.analyticsEventsService.queue(analyticsEvent);
            sharedPreferences.edit().putBoolean(PREF_AEC_EVENT_KEY, true).apply();
        }
    }

    private final void sendMicCaptureFailedEvent(String errorMessage) {
        HMSException hmsException = ErrorFactory.TracksErrors.MicCaptureFailed$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, errorMessage, null, null, 12, null);
        AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioPublishFail(hmsException);
        this.analyticsEventsService.queue(analyticsEvent);
    }

    private final HMSWavCapturer getWavCapturer() {
        Lazy lazy = this.wavCapturer$delegate;
        return (HMSWavCapturer)lazy.getValue();
    }

    public final void streamAndPlayAudioFromRawFile(int audioResourceId, @NotNull HMSActionResultListener hmsActionResultListener) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        this.initchunk();
        try {
            boolean bl = false;
            this.getWavCapturer().loadUrl(audioResourceId);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object task2 = object;
        if (Result.isSuccess-impl((Object)task2)) {
            this.getWebrtcAudioRecord().setBufferCallback((WebRtcAudioRecord.AudioBufferCallback)this.audioBufferCallback);
            this.getWebrtcAudioRecord().isMixingNeeded(true);
            hmsActionResultListener.onSuccess();
        } else {
            hmsActionResultListener.onError(ErrorFactory.GenericErrors.Unknown$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.PLUGIN, "Unable to start wav playback", Result.exceptionOrNull-impl((Object)task2), null, 8, null));
        }
    }

    public final void stopAudioFromRawFile(@NotNull HMSActionResultListener hmsActionResultListener) {
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        boolean isPlaying = this.getWavCapturer().isStarted().get();
        this.getWavCapturer().close();
        this.getWebrtcAudioRecord().isMixingNeeded(false);
        if (isPlaying) {
            hmsActionResultListener.onSuccess();
        } else {
            hmsActionResultListener.onError(ErrorFactory.GenericErrors.Unknown$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.PLUGIN, "Unable to stop because no wav file is playing", null, null, 8, null));
        }
    }

    private static final void initPeerConnectionFactory$lambda$2$lambda$1(String message, Logging.Severity severity, String tag) {
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"severity");
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        HMSLogger.INSTANCE.webRTCLog$lib_release(severity, tag, message);
    }

    private static final Thread newDefaultScheduler$lambda$3(HMSPeerConnectionFactory this$0, AtomicInteger $nextThreadId, Runnable r2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nextThreadId, (String)"$nextThreadId");
        Thread thread = Executors.defaultThreadFactory().newThread(r2);
        String string = "WebRtcAudioRecordScheduler-%s-%s";
        Object[] objectArray = new Object[]{this$0.nextSchedulerId.getAndIncrement(), $nextThreadId.getAndIncrement()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        thread.setName(string2);
        return thread;
    }

    public static final /* synthetic */ void access$initPeerConnectionFactory(HMSPeerConnectionFactory $this) {
        $this.initPeerConnectionFactory();
    }

    public static final /* synthetic */ void access$setWebrtcAudioRecord(HMSPeerConnectionFactory $this, WebRtcAudioRecord webRtcAudioRecord) {
        $this.setWebrtcAudioRecord(webRtcAudioRecord);
    }

    public static final /* synthetic */ ScheduledExecutorService access$newDefaultScheduler(HMSPeerConnectionFactory $this) {
        return $this.newDefaultScheduler();
    }

    public static final /* synthetic */ AudioManager access$getAudioManager$p(HMSPeerConnectionFactory $this) {
        return $this.audioManager;
    }

    public static final /* synthetic */ audioRecordErrorCallback.1 access$getAudioRecordErrorCallback$p(HMSPeerConnectionFactory $this) {
        return $this.audioRecordErrorCallback;
    }

    public static final /* synthetic */ audioRecordStateCallback.1 access$getAudioRecordStateCallback$p(HMSPeerConnectionFactory $this) {
        return $this.audioRecordStateCallback;
    }

    public static final /* synthetic */ void access$setWebRtcAudioTrack(HMSPeerConnectionFactory $this, WebRtcAudioTrack webRtcAudioTrack) {
        $this.setWebRtcAudioTrack(webRtcAudioTrack);
    }

    public static final /* synthetic */ audioTrackErrorCallback.1 access$getAudioTrackErrorCallback$p(HMSPeerConnectionFactory $this) {
        return $this.audioTrackErrorCallback;
    }

    public static final /* synthetic */ WebRtcAudioRecord access$getWebrtcAudioRecord(HMSPeerConnectionFactory $this) {
        return $this.getWebrtcAudioRecord();
    }

    public static final /* synthetic */ WebRtcAudioTrack access$getWebRtcAudioTrack(HMSPeerConnectionFactory $this) {
        return $this.getWebRtcAudioTrack();
    }

    public static final /* synthetic */ int access$getInputSampleRate$p(HMSPeerConnectionFactory $this) {
        return $this.inputSampleRate;
    }

    public static final /* synthetic */ int access$getOutputSampleRate$p(HMSPeerConnectionFactory $this) {
        return $this.outputSampleRate;
    }

    public static final /* synthetic */ PeerConnectionFactory.Builder access$getPeerConnectionFactoryBuilder(HMSPeerConnectionFactory $this, boolean isSimulcastEnabled, HMSTrackSettings hmsTrackSettings) {
        return $this.getPeerConnectionFactoryBuilder(isSimulcastEnabled, hmsTrackSettings);
    }

    public static final /* synthetic */ void access$sendAECAnalytics(HMSPeerConnectionFactory $this, Context context) {
        $this.sendAECAnalytics(context);
    }

    public static final /* synthetic */ void access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory $this, String errorMessage) {
        $this.sendMicCaptureFailedEvent(errorMessage);
    }

    public static final /* synthetic */ AudioMixingMode access$get_audioMixingMode$p(HMSPeerConnectionFactory $this) {
        return $this._audioMixingMode;
    }

    public static final /* synthetic */ HMSWavCapturer access$getWavCapturer(HMSPeerConnectionFactory $this) {
        return $this.getWavCapturer();
    }

    public static final /* synthetic */ ByteBuffer access$getSystemAudioByteBuffer$p(HMSPeerConnectionFactory $this) {
        return $this.systemAudioByteBuffer;
    }

    public static final /* synthetic */ AtomicBoolean access$isSystemAudioCaptureEnabled$p(HMSPeerConnectionFactory $this) {
        return $this.isSystemAudioCaptureEnabled;
    }

    public static final /* synthetic */ void access$captureSystemAudio(HMSPeerConnectionFactory $this) {
        $this.captureSystemAudio();
    }

    public static final /* synthetic */ void access$mixAudioBytes(HMSPeerConnectionFactory $this, ByteBuffer micAudioByteBuffer) {
        $this.mixAudioBytes(micAudioByteBuffer);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "videoEncoderFactory", "getVideoEncoderFactory()Lhms/webrtc/VideoEncoderFactory;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "videoDecoderFactory", "getVideoDecoderFactory()Lhms/webrtc/VideoDecoderFactory;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "webrtcAudioRecord", "getWebrtcAudioRecord()Lhms/webrtc/audio/WebRtcAudioRecord;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "webRtcAudioTrack", "getWebRtcAudioTrack()Lhms/webrtc/audio/WebRtcAudioTrack;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory$Companion;", "", "()V", "BUFFERS_PER_SECOND", "", "CALLBACK_BUFFER_SIZE_MS", "DEFAULT_AUDIO_FORMAT", "DEFAULT_AUDIO_SOURCE", "FILE_VOLUME_SCALE", "", "INPUT_BITS_PER_SAMPLE", "INPUT_NUM_OF_CHANNELS", "MIC_VOLUME_SCALE", "OUTPUT_BITS_PER_SAMPLE", "OUTPUT_NUM_OF_CHANNELS", "PREF_AEC_EVENT_DEFAULT", "", "PREF_AEC_EVENT_KEY", "", "TAG", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

