/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llive/hms/video/network/HMSNetworkManager;", "", "hmsContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectedNetworkType", "", "isConnectedOverWifi", "", "start", "", "stop", "lib_release"})
public class HMSNetworkManager {
    @NotNull
    private final ConnectivityManager connectivityManager;

    public HMSNetworkManager(@NotNull Context hmsContext) {
        Intrinsics.checkNotNullParameter((Object)hmsContext, (String)"hmsContext");
        Object object = hmsContext.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
    }

    @RequiresApi(value=23)
    public final boolean isConnectedOverWifi() {
        Network network = this.connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        Network activeNetwork = network;
        NetworkCapabilities networkCapabilities = this.connectivityManager.getNetworkCapabilities(activeNetwork);
        if (networkCapabilities == null) {
            return false;
        }
        NetworkCapabilities capabilities = networkCapabilities;
        return capabilities.hasTransport(1);
    }

    @NotNull
    public String getConnectedNetworkType() {
        return "";
    }

    public void start() {
    }

    public void stop() {
    }
}

