/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import java.io.Closeable;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.SharedFlow;
import live.hms.video.connection.degredation.StatsBundle;
import live.hms.video.connection.stats.quality.HMSNetworkObserver;
import live.hms.video.connection.stats.quality.HMSNetworkQuality;
import live.hms.video.connection.stats.quality.NetworkQualityCalculator;
import live.hms.video.sdk.NetworkObserverUseCase;
import live.hms.video.sdk.SDKStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fJ\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0006\u0010\u001f\u001a\u00020\u001cR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Llive/hms/video/sdk/NetworkObserverUseCase;", "Ljava/io/Closeable;", "statsFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "Llive/hms/video/connection/degredation/StatsBundle;", "store", "Llive/hms/video/sdk/SDKStore;", "hasJoined", "Lkotlin/Function0;", "", "(Lkotlinx/coroutines/flow/SharedFlow;Llive/hms/video/sdk/SDKStore;Lkotlin/jvm/functions/Function0;)V", "networkObserver", "Llive/hms/video/connection/stats/quality/HMSNetworkObserver;", "networkObserverScope", "Lkotlinx/coroutines/CoroutineScope;", "networkQualityCalculator", "Llive/hms/video/connection/stats/quality/NetworkQualityCalculator;", "getNetworkQualityCalculator", "()Llive/hms/video/connection/stats/quality/NetworkQualityCalculator;", "networkQualityCalculator$delegate", "Lkotlin/Lazy;", "qualityObserverJob", "Lkotlinx/coroutines/Job;", "getStatsFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "getStore", "()Llive/hms/video/sdk/SDKStore;", "addNetworkObserver", "", "observer", "close", "startNetworkObserver", "lib_release"})
public final class NetworkObserverUseCase
implements Closeable {
    @NotNull
    private final SharedFlow<StatsBundle> statsFlow;
    @NotNull
    private final SDKStore store;
    @NotNull
    private final Function0<Boolean> hasJoined;
    @Nullable
    private HMSNetworkObserver networkObserver;
    @NotNull
    private CoroutineScope networkObserverScope;
    @Nullable
    private Job qualityObserverJob;
    @NotNull
    private final Lazy networkQualityCalculator$delegate;

    public NetworkObserverUseCase(@NotNull SharedFlow<StatsBundle> statsFlow2, @NotNull SDKStore store, @NotNull Function0<Boolean> hasJoined) {
        Intrinsics.checkNotNullParameter(statsFlow2, (String)"statsFlow");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter(hasJoined, (String)"hasJoined");
        this.statsFlow = statsFlow2;
        this.store = store;
        this.hasJoined = hasJoined;
        this.networkObserverScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.networkQualityCalculator$delegate = LazyKt.lazy((Function0)networkQualityCalculator.2.INSTANCE);
    }

    @NotNull
    public final SharedFlow<StatsBundle> getStatsFlow() {
        return this.statsFlow;
    }

    @NotNull
    public final SDKStore getStore() {
        return this.store;
    }

    @NotNull
    public final NetworkQualityCalculator getNetworkQualityCalculator() {
        Lazy lazy = this.networkQualityCalculator$delegate;
        return (NetworkQualityCalculator)lazy.getValue();
    }

    public final void addNetworkObserver(@NotNull HMSNetworkObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.networkObserver = observer;
        if (((Boolean)this.hasJoined.invoke()).booleanValue()) {
            this.startNetworkObserver();
        }
    }

    public final void startNetworkObserver() {
        HMSNetworkObserver nullCheckedObserver = this.networkObserver;
        if (nullCheckedObserver != null) {
            Job job = this.qualityObserverJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.qualityObserverJob = BuildersKt.launch$default((CoroutineScope)this.networkObserverScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, nullCheckedObserver, null){
                int label;
                final /* synthetic */ NetworkObserverUseCase this$0;
                final /* synthetic */ HMSNetworkObserver $nullCheckedObserver;
                {
                    this.this$0 = $receiver;
                    this.$nullCheckedObserver = $nullCheckedObserver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getStatsFlow().collect(new FlowCollector(this.this$0, this.$nullCheckedObserver){
                                final /* synthetic */ NetworkObserverUseCase this$0;
                                final /* synthetic */ HMSNetworkObserver $nullCheckedObserver;
                                {
                                    this.this$0 = $receiver;
                                    this.$nullCheckedObserver = $nullCheckedObserver;
                                }

                                @Nullable
                                public final Object emit(@NotNull StatsBundle statsCollection, @NotNull Continuation<? super Unit> $completion) {
                                    long totalPackets = statsCollection.getTotalPackets();
                                    long packetLoss = statsCollection.getPacketLoss();
                                    int quality = this.this$0.getNetworkQualityCalculator().calculateNetworkQuality(totalPackets, packetLoss);
                                    this.$nullCheckedObserver.onNetworkQuality(new HMSNetworkQuality(quality), this.this$0.getStore().getLocalPeer());
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) throw new KotlinNothingValueException();
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void close() {
        Job job = this.qualityObserverJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.networkObserverScope, null, (int)1, null);
        this.networkObserver = null;
        this.networkObserverScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }
}

