/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import androidx.core.math.MathUtils;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import live.hms.video.error.ErrorFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.capturers.camera.CameraControl;
import live.hms.video.media.capturers.camera.CameraExtKt;
import live.hms.video.media.capturers.camera.utils.ImageCaptureModel;
import live.hms.video.sdk.HmsTypedActionResultListener;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera2Session;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.RendererCommon;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0014\u0010>\u001a\u00020;2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@J1\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020D2!\u0010E\u001a\u001d\u0012\u0013\u0012\u00110G\u00a2\u0006\f\bH\u0012\b\bI\u0012\u0004\b\b(J\u0012\u0004\u0012\u00020;0FJ\u0018\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020LH\u0002J\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u000e0PJ\u0006\u0010Q\u001a\u00020\u000eJ\u0012\u0010R\u001a\u00020\u000e2\b\u0010S\u001a\u0004\u0018\u00010TH\u0002J\u0006\u0010U\u001a\u00020\u000eJ\u0006\u0010V\u001a\u00020GJ\u0006\u0010W\u001a\u00020GJ\u0006\u0010X\u001a\u00020GJ\u0006\u0010Y\u001a\u00020GJ\b\u0010Z\u001a\u00020GH\u0002J\u0006\u0010[\u001a\u00020GJ\u0015\u0010\\\u001a\u00020;2\u0006\u0010]\u001a\u00020^H\u0000\u00a2\u0006\u0002\b_J\u0006\u0010`\u001a\u00020;J\u000e\u0010a\u001a\u00020;2\u0006\u0010b\u001a\u00020GJ\u000e\u0010c\u001a\u00020;2\u0006\u0010d\u001a\u00020\u000eJ0\u0010e\u001a\u00020;2\u0006\u0010f\u001a\u00020\u000e2\u0006\u0010g\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020\n2\u0006\u0010i\u001a\u00020\n2\b\b\u0002\u0010j\u001a\u00020kJ\u000e\u0010l\u001a\u00020;2\u0006\u0010m\u001a\u00020\u000eJ\u001a\u0010n\u001a\u00020;2\u0006\u0010m\u001a\u00020\u000e2\b\u0010o\u001a\u0004\u0018\u00010pH\u0002J\u0011\u0010q\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010rR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001b\u0010/\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b0\u0010\u0014R\u001b\u00103\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00102\u001a\u0004\b5\u00106R\u000e\u00108\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006s"}, d2={"Llive/hms/video/media/capturers/camera/CameraControl;", "", "cameraHandler", "Landroid/os/Handler;", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/os/Handler;Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;)V", "IMAGE_BUFFER_SIZE", "", "IMAGE_CAPTURE_TIMEOUT_MILLIS", "", "ZOOM_DEFAULT_VALUE", "", "getAnalyticsEventsService$lib_release", "()Llive/hms/video/events/AnalyticsEventsService;", "cameraCaptureMutex", "Lkotlinx/coroutines/sync/Mutex;", "getCameraHandler", "()Landroid/os/Handler;", "captureFormat", "Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat;", "getCaptureFormat", "()Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat;", "setCaptureFormat", "(Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat;)V", "captureRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "getCaptureRequestBuilder", "()Landroid/hardware/camera2/CaptureRequest$Builder;", "setCaptureRequestBuilder", "(Landroid/hardware/camera2/CaptureRequest$Builder;)V", "getContext", "()Landroid/content/Context;", "currentCameraSession", "Landroid/hardware/camera2/CameraCaptureSession;", "getCurrentCameraSession", "()Landroid/hardware/camera2/CameraCaptureSession;", "setCurrentCameraSession", "(Landroid/hardware/camera2/CameraCaptureSession;)V", "imageReader", "Landroid/media/ImageReader;", "getImageReader", "()Landroid/media/ImageReader;", "setImageReader", "(Landroid/media/ImageReader;)V", "imageReaderHandler", "getImageReaderHandler", "imageReaderHandler$delegate", "Lkotlin/Lazy;", "imageReaderThread", "Landroid/os/HandlerThread;", "getImageReaderThread", "()Landroid/os/HandlerThread;", "imageReaderThread$delegate", "lastLensDistance", "lastZoom", "autoFocusCallbackResult", "", "result", "Landroid/hardware/camera2/CaptureResult;", "captureImageAtMaxResolution", "onImageCapture", "Llive/hms/video/sdk/HmsTypedActionResultListener;", "Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;", "captureImageAtMaxSupportedResolution", "savePath", "Ljava/io/File;", "callback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "isSuccess", "cropRegionForZoom", "Landroid/graphics/Rect;", "ratio", "zoomSensorRect", "getManualFocusRange", "Landroid/util/Range;", "getMaxZoom", "getMaxZoomInternal", "cameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "getMinZoom", "isFlashEnabled", "isFlashSupported", "isManualFocusSupported", "isTapToFocusSupported", "isValidSession", "isZoomSupported", "onCameraSessionUpdate", "session", "Lorg/webrtc/Camera2Session;", "onCameraSessionUpdate$lib_release", "resetZoom", "setFlash", "enable", "setManualFocus", "range", "setTapToFocusAt", "viewX", "viewY", "viewWidth", "viewHeight", "scalingType", "Lorg/webrtc/RendererCommon$ScalingType;", "setZoom", "zoomValue", "setZoomInternal", "currentCameraIndex", "", "takePictureInternal", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
@SourceDebugExtension(value={"SMAP\nCameraControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraControl.kt\nlive/hms/video/media/capturers/camera/CameraControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,640:1\n1#2:641\n*E\n"})
public final class CameraControl {
    @Nullable
    private final Handler cameraHandler;
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @Nullable
    private CameraCaptureSession currentCameraSession;
    @Nullable
    private CaptureRequest.Builder captureRequestBuilder;
    @Nullable
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    @NotNull
    private final Mutex cameraCaptureMutex;
    private final int IMAGE_BUFFER_SIZE;
    @NotNull
    private final Lazy imageReaderThread$delegate;
    @NotNull
    private final Lazy imageReaderHandler$delegate;
    private final long IMAGE_CAPTURE_TIMEOUT_MILLIS;
    @Nullable
    private ImageReader imageReader;
    private final float ZOOM_DEFAULT_VALUE;
    private float lastZoom;
    private float lastLensDistance;

    public CameraControl(@Nullable Handler cameraHandler, @NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.cameraHandler = cameraHandler;
        this.context = context;
        this.analyticsEventsService = analyticsEventsService2;
        this.cameraCaptureMutex = MutexKt.Mutex((boolean)false);
        this.IMAGE_BUFFER_SIZE = 1;
        this.imageReaderThread$delegate = LazyKt.lazy((Function0)imageReaderThread.2.INSTANCE);
        this.imageReaderHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Handler>(this){
            final /* synthetic */ CameraControl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Handler invoke() {
                return new Handler(CameraControl.access$getImageReaderThread(this.this$0).getLooper());
            }
        }));
        this.IMAGE_CAPTURE_TIMEOUT_MILLIS = 5000L;
        this.ZOOM_DEFAULT_VALUE = 1.0f;
    }

    @Nullable
    public final Handler getCameraHandler() {
        return this.cameraHandler;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService$lib_release() {
        return this.analyticsEventsService;
    }

    @Nullable
    public final CameraCaptureSession getCurrentCameraSession() {
        return this.currentCameraSession;
    }

    public final void setCurrentCameraSession(@Nullable CameraCaptureSession cameraCaptureSession) {
        this.currentCameraSession = cameraCaptureSession;
    }

    @Nullable
    public final CaptureRequest.Builder getCaptureRequestBuilder() {
        return this.captureRequestBuilder;
    }

    public final void setCaptureRequestBuilder(@Nullable CaptureRequest.Builder builder) {
        this.captureRequestBuilder = builder;
    }

    @Nullable
    public final CameraEnumerationAndroid.CaptureFormat getCaptureFormat() {
        return this.captureFormat;
    }

    public final void setCaptureFormat(@Nullable CameraEnumerationAndroid.CaptureFormat captureFormat) {
        this.captureFormat = captureFormat;
    }

    private final HandlerThread getImageReaderThread() {
        Lazy lazy = this.imageReaderThread$delegate;
        return (HandlerThread)lazy.getValue();
    }

    private final Handler getImageReaderHandler() {
        Lazy lazy = this.imageReaderHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @Nullable
    public final ImageReader getImageReader() {
        return this.imageReader;
    }

    public final void setImageReader(@Nullable ImageReader imageReader) {
        this.imageReader = imageReader;
    }

    public final void onCameraSessionUpdate$lib_release(@NotNull Camera2Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.captureRequestBuilder = session.getCaptureRequestBuilder();
        this.currentCameraSession = session.getCamera2CaptureSession();
        this.captureFormat = session.getCameraCaptureFormat();
        this.imageReader = session.getImageReader();
    }

    private final boolean isValidSession() {
        return this.cameraHandler != null && this.captureRequestBuilder != null && this.currentCameraSession != null && this.captureFormat != null;
    }

    public final boolean isZoomSupported() {
        if (!this.isValidSession()) {
            return false;
        }
        Object object = this.currentCameraSession;
        if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
            return false;
        }
        Object currentCameraIndex = object;
        Integer n = StringsKt.toIntOrNull((String)currentCameraIndex);
        CameraCharacteristics cameraCharacteristics = n != null ? CameraExtKt.getCameraCharacteristics(n, this.context) : null;
        return this.getMaxZoomInternal(cameraCharacteristics) > this.ZOOM_DEFAULT_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isManualFocusSupported() {
        Object object;
        if (!this.isValidSession()) {
            return false;
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        Object object2 = cameraCaptureSession;
        if (cameraCaptureSession == null) return false;
        CameraDevice cameraDevice = object2.getDevice();
        object2 = cameraDevice;
        if (cameraDevice == null) return false;
        if ((object2 = object2.getId()) == null) {
            return false;
        }
        Object object3 = object = object2;
        boolean bl = false;
        Range<Float> manualFocusRange = CameraExtKt.getLensDistanceRange(this.context, (String)object3);
        Comparable comparable = manualFocusRange.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"manualFocusRange.upper");
        if (!(((Number)((Object)comparable)).floatValue() > 0.0f)) return false;
        Comparable comparable2 = manualFocusRange.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"manualFocusRange.lower");
        if (!(((Number)((Object)comparable2)).floatValue() > 0.0f)) return false;
        return true;
    }

    @NotNull
    public final Range<Float> getManualFocusRange() {
        if (!this.isValidSession()) {
            return new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
        }
        Object object = this.currentCameraSession;
        if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
            return new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
        }
        Object currentCameraIndex = object;
        return CameraExtKt.getLensDistanceRange(this.context, (String)currentCameraIndex);
    }

    public final void setManualFocus(float range) {
        if (!this.isValidSession()) {
            return;
        }
        Object object = this.currentCameraSession;
        if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
            return;
        }
        Object currentCameraIndex = object;
        Range<Float> lensRange = this.getManualFocusRange();
        Comparable comparable = lensRange.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"lensRange.lower");
        float f = ((Number)((Object)comparable)).floatValue();
        Comparable comparable2 = lensRange.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"lensRange.upper");
        this.lastLensDistance = RangesKt.coerceIn((float)range, (float)f, (float)((Number)((Object)comparable2)).floatValue());
        CaptureRequest.Builder builder = this.captureRequestBuilder;
        if (builder != null) {
            builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(this.lastLensDistance));
        }
        CameraControl cameraControl = this;
        try {
            Integer n;
            CameraControl $this$setManualFocus_u24lambda_u241 = cameraControl;
            boolean bl = false;
            if (!$this$setManualFocus_u24lambda_u241.isValidSession()) {
                return;
            }
            CameraCaptureSession cameraCaptureSession = $this$setManualFocus_u24lambda_u241.currentCameraSession;
            if (cameraCaptureSession != null) {
                CaptureRequest.Builder builder2 = $this$setManualFocus_u24lambda_u241.captureRequestBuilder;
                Intrinsics.checkNotNull((Object)builder2);
                n = cameraCaptureSession.setRepeatingRequest(builder2.build(), new CameraCaptureSession.CaptureCallback(){}, $this$setManualFocus_u24lambda_u241.cameraHandler);
            } else {
                n = null;
            }
            Object object2 = Result.constructor-impl(n);
        }
        catch (Throwable throwable) {
            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final boolean isTapToFocusSupported() {
        if (!this.isValidSession()) {
            return false;
        }
        Object object = this.currentCameraSession;
        if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
            return false;
        }
        Object currentCameraIndex = object;
        Integer n = StringsKt.toIntOrNull((String)currentCameraIndex);
        if (n == null || (n = CameraExtKt.getCameraCharacteristics(n, this.context)) == null) {
            return false;
        }
        Integer cameraCharacteristics = n;
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (nArray == null) {
            return false;
        }
        int[] availableAFModes = nArray;
        return !(availableAFModes.length == 0) && CameraExtKt.getFocusMaxMeteringRegionsSupported(this.context, (String)currentCameraIndex) != 0;
    }

    public final float getMaxZoom() {
        if (!this.isValidSession()) {
            return this.ZOOM_DEFAULT_VALUE;
        }
        Object object = this.currentCameraSession;
        if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
            return this.ZOOM_DEFAULT_VALUE;
        }
        Object currentCameraIndex = object;
        Integer n = StringsKt.toIntOrNull((String)currentCameraIndex);
        return this.getMaxZoomInternal(n != null ? CameraExtKt.getCameraCharacteristics(n, this.context) : null);
    }

    public final float getMinZoom() {
        return this.ZOOM_DEFAULT_VALUE;
    }

    public final void setZoom(float zoomValue) {
        block2: {
            if (!this.isValidSession()) {
                return;
            }
            Object object = this.currentCameraSession;
            if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
                return;
            }
            Object currentCameraIndex = object;
            Handler handler = this.cameraHandler;
            if (handler == null) break block2;
            handler.post(() -> CameraControl.setZoom$lambda$2(this, zoomValue, (String)currentCameraIndex));
        }
    }

    public final void resetZoom() {
        block2: {
            Object imageView = null;
            if (!this.isValidSession()) {
                return;
            }
            Object object = this.currentCameraSession;
            if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
                return;
            }
            Object currentCameraIndex = object;
            Handler handler = this.cameraHandler;
            if (handler == null) break block2;
            handler.post(() -> CameraControl.resetZoom$lambda$3(this, (String)currentCameraIndex));
        }
    }

    public final void setTapToFocusAt(float viewX, float viewY, int viewWidth, int viewHeight, @NotNull RendererCommon.ScalingType scalingType) {
        block9: {
            RectF rectF;
            Intrinsics.checkNotNullParameter((Object)scalingType, (String)"scalingType");
            if (!this.isValidSession()) {
                return;
            }
            if (viewX < 0.0f || viewX > (float)viewWidth || viewY < 0.0f || viewY > (float)viewHeight) {
                return;
            }
            CaptureRequest.Builder builder = this.captureRequestBuilder;
            Rect rect = builder != null ? (Rect)builder.get(CaptureRequest.SCALER_CROP_REGION) : null;
            if (rect == null) {
                return;
            }
            Rect cropRegion = rect;
            int cropWidth = cropRegion.width();
            int cropHeight = cropRegion.height();
            Object object = this.currentCameraSession;
            if (object == null || (object = object.getDevice()) == null || (object = object.getId()) == null) {
                object = "1";
            }
            int rotation = CameraExtKt.computeRelativeRotation(this.context, (String)object);
            CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
            boolean isMirror = Intrinsics.areEqual((Object)(cameraCaptureSession != null && (cameraCaptureSession = cameraCaptureSession.getDevice()) != null ? cameraCaptureSession.getId() : null), (Object)"1");
            int rotationValue = (isMirror ? 1 : -1) * rotation;
            CameraEnumerationAndroid.CaptureFormat captureFormat = this.captureFormat;
            CameraEnumerationAndroid.CaptureFormat captureFormat2 = this.captureFormat;
            RectF rectF2 = HMSUtils.INSTANCE.viewToNormalized$lib_release(new RectF(viewX, viewY, viewX, viewY), viewWidth, viewHeight, captureFormat != null ? Integer.valueOf(captureFormat.width) : null, captureFormat2 != null ? Integer.valueOf(captureFormat2.height) : null, isMirror, rotationValue, scalingType);
            if (rectF2 == null) {
                return;
            }
            RectF normalisedRect = rectF2;
            float tempX = normalisedRect.left;
            float tempY = normalisedRect.top;
            RectF $this$setTapToFocusAt_u24lambda_u244 = rectF = new RectF();
            boolean bl = false;
            $this$setTapToFocusAt_u24lambda_u244.left = MathUtils.clamp((float)(tempX - 0.05f), (float)0.0f, (float)1.0f);
            $this$setTapToFocusAt_u24lambda_u244.right = MathUtils.clamp((float)(tempX + 0.05f), (float)0.0f, (float)1.0f);
            $this$setTapToFocusAt_u24lambda_u244.top = MathUtils.clamp((float)(tempY - 0.05f), (float)0.0f, (float)1.0f);
            $this$setTapToFocusAt_u24lambda_u244.bottom = MathUtils.clamp((float)(tempY + 0.05f), (float)0.0f, (float)1.0f);
            RectF clampedNormalisedRect = rectF;
            CameraEnumerationAndroid.CaptureFormat captureFormat3 = this.captureFormat;
            CameraEnumerationAndroid.CaptureFormat captureFormat4 = this.captureFormat;
            RectF rectF3 = HMSUtils.INSTANCE.normalizedToCameraSensor$lib_release(clampedNormalisedRect, captureFormat3 != null ? Integer.valueOf(captureFormat3.width) : null, captureFormat4 != null ? Integer.valueOf(captureFormat4.height) : null, cropWidth, cropHeight, true);
            if (rectF3 == null) {
                return;
            }
            RectF sensorCoordinateRect = rectF3;
            Rect sensorCoordinateRectRound = null;
            sensorCoordinateRectRound = new Rect();
            if (sensorCoordinateRect.width() == 0.0f || sensorCoordinateRect.height() == 0.0f) {
                sensorCoordinateRectRound = new Rect(0, 0, 0, 0);
            } else {
                sensorCoordinateRect.round(sensorCoordinateRectRound);
            }
            CaptureRequest.Builder builder2 = this.captureRequestBuilder;
            if (builder2 != null) {
                CaptureRequest.Builder builder3;
                CaptureRequest.Builder $this$setTapToFocusAt_u24lambda_u245 = builder3 = builder2;
                boolean bl2 = false;
                MeteringRectangle[] meteringRectangleArray = new MeteringRectangle[]{new MeteringRectangle(sensorCoordinateRectRound, 1000)};
                $this$setTapToFocusAt_u24lambda_u245.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)meteringRectangleArray);
                meteringRectangleArray = new MeteringRectangle[]{new MeteringRectangle(sensorCoordinateRectRound, 1000)};
                $this$setTapToFocusAt_u24lambda_u245.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)meteringRectangleArray);
                $this$setTapToFocusAt_u24lambda_u245.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                $this$setTapToFocusAt_u24lambda_u245.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                $this$setTapToFocusAt_u24lambda_u245.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            }
            Handler handler = this.cameraHandler;
            if (handler == null) break block9;
            handler.post(() -> CameraControl.setTapToFocusAt$lambda$7(this));
        }
    }

    public static /* synthetic */ void setTapToFocusAt$default(CameraControl cameraControl, float f, float f2, int n, int n2, RendererCommon.ScalingType scalingType, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
        }
        cameraControl.setTapToFocusAt(f, f2, n, n2, scalingType);
    }

    public final void captureImageAtMaxResolution(@NotNull HmsTypedActionResultListener<ImageCaptureModel> onImageCapture) {
        Intrinsics.checkNotNullParameter(onImageCapture, (String)"onImageCapture");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onImageCapture, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CameraControl this$0;
            final /* synthetic */ HmsTypedActionResultListener<ImageCaptureModel> $onImageCapture;
            {
                this.this$0 = $receiver;
                this.$onImageCapture = $onImageCapture;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        var3_4 = CameraControl.access$getCameraCaptureMutex$p(this.this$0);
                        var5_5 = this.$onImageCapture;
                        var6_6 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$launch;
                        this.L$1 = $this$withLock_u24default$iv;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl31
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var6_6 = (CameraControl)this.L$3;
                        var5_5 = (HmsTypedActionResultListener<ImageCaptureModel>)this.L$2;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 3 sources

                        $i$a$-withLock$default-CameraControl$captureImageAtMaxResolution$1$1 = false;
                        var9_13 = $this$launch;
                        $i$a$-runCatching-CameraControl$captureImageAtMaxResolution$1$1$imageCaptureResult$1 = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var5_5;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 2;
                        v1 = CameraControl.access$takePictureInternal(var6_6, (Continuation)this);
                        ** if (v1 != var16_2) goto lbl46
lbl45:
                        // 1 sources

                        return var16_2;
lbl46:
                        // 1 sources

                        ** GOTO lbl59
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-CameraControl$captureImageAtMaxResolution$1$1 = false;
                        $i$a$-runCatching-CameraControl$captureImageAtMaxResolution$1$1$imageCaptureResult$1 = false;
                        var5_5 = (HmsTypedActionResultListener)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl59:
                            // 2 sources

                            var10_17 = Result.constructor-impl((Object)((ImageCaptureModel)v1));
                            {
                                catch (Throwable var11_15) {
                                    var10_17 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var11_15));
                                }
                            }
                            imageCaptureResult = var10_17;
                            result = (ImageCaptureModel)(Result.isFailure-impl((Object)imageCaptureResult) != false ? null : imageCaptureResult);
                            if ((!Result.isFailure-impl((Object)imageCaptureResult) || Result.exceptionOrNull-impl((Object)imageCaptureResult) == null) && result != null) ** GOTO lbl69
                            var5_5.onError(ErrorFactory.INSTANCE.ImageCaptureException(Result.exceptionOrNull-impl((Object)imageCaptureResult)));
                            ** GOTO lbl86
lbl69:
                            // 1 sources

                            var10_17 = result;
                            var11_16 = null;
                            try {
                                (ImageCaptureModel)var10_17;
                                $i$a$-use-CameraControl$captureImageAtMaxResolution$1$1$1 = false;
                                var5_5.onSuccess(result);
                                var13_20 = Unit.INSTANCE;
                            }
                            catch (Throwable var13_21) {
                                var11_16 = var13_21;
                                throw var13_21;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var10_17, (Throwable)var11_16);
                            }
lbl86:
                            // 2 sources

                            var15_23 = Unit.INSTANCE;
                        }
                        catch (Throwable var15_24) {
                            throw var15_24;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void captureImageAtMaxSupportedResolution(@NotNull File savePath, @NotNull Function1<? super Boolean, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback2, savePath, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CameraControl this$0;
            final /* synthetic */ Function1<Boolean, Unit> $callback;
            final /* synthetic */ File $savePath;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$savePath = $savePath;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean isFlashSupported() {
        boolean bl;
        Object object = this.currentCameraSession;
        if (object != null && (object = object.getDevice()) != null && (object = object.getId()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = CameraExtKt.isFlashAvailable(this.context, (String)it);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isFlashEnabled() {
        boolean bl;
        CaptureRequest.Builder builder = this.captureRequestBuilder;
        if (builder != null) {
            Integer n = (Integer)builder.get(CaptureRequest.FLASH_MODE);
            int n2 = 2;
            bl = n != null && n == n2;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void setFlash(boolean enable) {
        block1: {
            if (!this.isValidSession()) {
                return;
            }
            int mode = enable ? 2 : 0;
            Handler handler = this.cameraHandler;
            if (handler == null) break block1;
            handler.post(() -> CameraControl.setFlash$lambda$10(this, mode));
        }
    }

    private final void setZoomInternal(float zoomValue, String currentCameraIndex) {
        Object object = currentCameraIndex;
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null || (object = CameraExtKt.getCameraCharacteristics((Integer)object, this.context)) == null) {
            return;
        }
        Object cameraCharacteristics = object;
        Rect rect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (rect == null) {
            return;
        }
        Rect zoomSensorRect = rect;
        float currentMaxZoomValue = this.getMaxZoomInternal((CameraCharacteristics)cameraCharacteristics);
        if (Math.abs(currentMaxZoomValue - this.ZOOM_DEFAULT_VALUE) < 0.001f) {
            return;
        }
        boolean isZoomRequired = zoomValue >= this.ZOOM_DEFAULT_VALUE && zoomValue <= currentMaxZoomValue && !(zoomValue == this.lastZoom);
        this.lastZoom = zoomValue;
        if (!isZoomRequired) {
            return;
        }
        Rect zoomRect = this.cropRegionForZoom(zoomValue, zoomSensorRect);
        CaptureRequest.Builder builder = this.captureRequestBuilder;
        if (builder != null) {
            builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoomRect);
        }
        this.lastZoom = zoomValue;
        CameraControl cameraControl = this;
        try {
            Integer n;
            CameraControl $this$setZoomInternal_u24lambda_u2411 = cameraControl;
            boolean bl = false;
            if (!$this$setZoomInternal_u24lambda_u2411.isValidSession()) {
                return;
            }
            CameraCaptureSession cameraCaptureSession = $this$setZoomInternal_u24lambda_u2411.currentCameraSession;
            if (cameraCaptureSession != null) {
                CaptureRequest.Builder builder2 = $this$setZoomInternal_u24lambda_u2411.captureRequestBuilder;
                Intrinsics.checkNotNull((Object)builder2);
                n = cameraCaptureSession.setRepeatingRequest(builder2.build(), new CameraCaptureSession.CaptureCallback(){}, $this$setZoomInternal_u24lambda_u2411.cameraHandler);
            } else {
                n = null;
            }
            Object object2 = Result.constructor-impl(n);
        }
        catch (Throwable throwable) {
            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final void autoFocusCallbackResult(CaptureResult result2) {
        Integer n = (Integer)result2.get(CaptureResult.CONTROL_AF_STATE);
        if (n == null) {
            return;
        }
        int afState = ((Number)n).intValue();
        if (4 == afState || 5 == afState) {
            CaptureRequest.Builder builder = this.captureRequestBuilder;
            if (builder != null) {
                CaptureRequest.Builder builder2;
                CaptureRequest.Builder $this$autoFocusCallbackResult_u24lambda_u2412 = builder2 = builder;
                boolean bl = false;
                $this$autoFocusCallbackResult_u24lambda_u2412.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                $this$autoFocusCallbackResult_u24lambda_u2412.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                $this$autoFocusCallbackResult_u24lambda_u2412.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            }
            try {
                Integer n2;
                boolean bl = false;
                if (!this.isValidSession()) {
                    return;
                }
                CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
                if (cameraCaptureSession != null) {
                    CaptureRequest.Builder builder3 = this.captureRequestBuilder;
                    Intrinsics.checkNotNull((Object)builder3);
                    n2 = cameraCaptureSession.setRepeatingRequest(builder3.build(), new CameraCaptureSession.CaptureCallback(){}, this.cameraHandler);
                } else {
                    n2 = null;
                }
                Object object = Result.constructor-impl(n2);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final float getMaxZoomInternal(CameraCharacteristics cameraCharacteristics) {
        if (cameraCharacteristics == null) {
            return this.ZOOM_DEFAULT_VALUE;
        }
        Float zoomValue = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (zoomValue != null) {
            return zoomValue.floatValue();
        }
        return this.ZOOM_DEFAULT_VALUE;
    }

    private final Rect cropRegionForZoom(float ratio, Rect zoomSensorRect) {
        int xCenter = zoomSensorRect.width() / 2;
        int yCenter = zoomSensorRect.height() / 2;
        int xDelta = (int)(0.5f * (float)zoomSensorRect.width() / ratio);
        int yDelta = (int)(0.5f * (float)zoomSensorRect.height() / ratio);
        return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
    }

    private final Object takePictureInternal(Continuation<? super ImageCaptureModel> $completion) {
        CaptureRequest.Builder builder;
        CaptureRequest.Builder captureRequest;
        CaptureRequest.Builder builder2;
        CaptureRequest.Builder builder3;
        CameraDevice cameraDevice;
        ImageReader imageReader;
        Continuation<? super ImageCaptureModel> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        if (this.imageReader == null || !this.isValidSession()) {
            cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new NullPointerException("imageReader null, should be initlaised"))));
        }
        do {
            imageReader = this.imageReader;
            Intrinsics.checkNotNull((Object)imageReader);
        } while (imageReader.acquireNextImage() != null);
        ArrayBlockingQueue<Image> imageQueue = new ArrayBlockingQueue<Image>(this.IMAGE_BUFFER_SIZE);
        ImageReader imageReader2 = this.imageReader;
        Intrinsics.checkNotNull((Object)imageReader2);
        imageReader2.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(imageQueue){
            final /* synthetic */ ArrayBlockingQueue<Image> $imageQueue;
            {
                this.$imageQueue = $imageQueue;
            }

            public final void onImageAvailable(ImageReader reader) {
                Image image = reader.acquireNextImage();
                this.$imageQueue.add(image);
            }
        }, this.getImageReaderHandler());
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        if (cameraCaptureSession != null && (cameraDevice = cameraCaptureSession.getDevice()) != null && (builder3 = cameraDevice.createCaptureRequest(2)) != null) {
            CaptureRequest.Builder builder4;
            CaptureRequest.Builder $this$takePictureInternal_u24lambda_u2416_u24lambda_u2414 = builder4 = builder3;
            boolean bl2 = false;
            ImageReader imageReader3 = this.imageReader;
            Intrinsics.checkNotNull((Object)imageReader3);
            $this$takePictureInternal_u24lambda_u2416_u24lambda_u2414.addTarget(imageReader3.getSurface());
            builder2 = builder4;
        } else {
            builder2 = captureRequest = null;
        }
        if (captureRequest == null) {
            cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new NullPointerException("current camera session not found"))));
        }
        if ((builder = this.captureRequestBuilder) != null && (builder = (Rect)builder.get(CaptureRequest.SCALER_CROP_REGION)) != null) {
            CaptureRequest.Builder it = builder;
            boolean bl3 = false;
            CaptureRequest.Builder builder5 = captureRequest;
            if (builder5 != null) {
                builder5.set(CaptureRequest.SCALER_CROP_REGION, (Object)it);
            }
        }
        CameraCaptureSession cameraCaptureSession2 = this.currentCameraSession;
        if (cameraCaptureSession2 != null) {
            CaptureRequest.Builder builder6 = captureRequest;
            Intrinsics.checkNotNull(builder6);
            Boxing.boxInt((int)cameraCaptureSession2.capture(builder6.build(), new CameraCaptureSession.CaptureCallback(this, (Continuation<? super ImageCaptureModel>)cont, imageQueue){
                final /* synthetic */ CameraControl this$0;
                final /* synthetic */ Continuation<ImageCaptureModel> $cont;
                final /* synthetic */ ArrayBlockingQueue<Image> $imageQueue;
                {
                    this.this$0 = $receiver;
                    this.$cont = $cont;
                    this.$imageQueue = $imageQueue;
                }

                public void onCaptureCompleted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull TotalCaptureResult result2) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    super.onCaptureCompleted(session, request, result2);
                    Long resultTimestamp = (Long)result2.get(CaptureResult.SENSOR_TIMESTAMP);
                    TimeoutException exc = new TimeoutException("Image dequeuing took too long");
                    Runnable timeoutRunnable2 = new Runnable(this.$cont, exc){
                        final /* synthetic */ Continuation<ImageCaptureModel> $cont;
                        final /* synthetic */ TimeoutException $exc;
                        {
                            this.$cont = $cont;
                            this.$exc = $exc;
                        }

                        public final void run() {
                            this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.$exc)));
                        }
                    };
                    CameraControl.access$getImageReaderHandler(this.this$0).postDelayed(timeoutRunnable2, CameraControl.access$getIMAGE_CAPTURE_TIMEOUT_MILLIS$p(this.this$0));
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.$cont.getContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$imageQueue, resultTimestamp, this.this$0, timeoutRunnable2, this.$cont, result2, null){
                        int label;
                        final /* synthetic */ ArrayBlockingQueue<Image> $imageQueue;
                        final /* synthetic */ Long $resultTimestamp;
                        final /* synthetic */ CameraControl this$0;
                        final /* synthetic */ Runnable $timeoutRunnable;
                        final /* synthetic */ Continuation<ImageCaptureModel> $cont;
                        final /* synthetic */ TotalCaptureResult $result;
                        {
                            this.$imageQueue = $imageQueue;
                            this.$resultTimestamp = $resultTimestamp;
                            this.this$0 = $receiver;
                            this.$timeoutRunnable = $timeoutRunnable;
                            this.$cont = $cont;
                            this.$result = $result;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    while (true) {
                                        Image image = this.$imageQueue.take();
                                        if (Build.VERSION.SDK_INT >= 29 && image.getFormat() != 1768253795) {
                                            Long l = this.$resultTimestamp;
                                            if (l == null || image.getTimestamp() != l.longValue()) continue;
                                        }
                                        CameraControl.access$getImageReaderHandler(this.this$0).removeCallbacks(this.$timeoutRunnable);
                                        ImageReader imageReader = this.this$0.getImageReader();
                                        Intrinsics.checkNotNull((Object)imageReader);
                                        imageReader.setOnImageAvailableListener(null, null);
                                        while (this.$imageQueue.size() > 0) {
                                            this.$imageQueue.take().close();
                                        }
                                        Context context = this.this$0.getContext();
                                        CameraCaptureSession cameraCaptureSession = this.this$0.getCurrentCameraSession();
                                        Intrinsics.checkNotNull((Object)cameraCaptureSession);
                                        String string = cameraCaptureSession.getDevice().getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentCameraSession!!.device.id");
                                        int rotation = CameraExtKt.computeRelativeRotation(context, string);
                                        Context context2 = this.this$0.getContext();
                                        CameraCaptureSession cameraCaptureSession2 = this.this$0.getCurrentCameraSession();
                                        Intrinsics.checkNotNull((Object)cameraCaptureSession2);
                                        String string2 = cameraCaptureSession2.getDevice().getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentCameraSession!!.device.id");
                                        Integer n = (Integer)CameraExtKt.getCameraCharacteristics(context2, string2).get(CameraCharacteristics.LENS_FACING);
                                        boolean mirrored = n != null && n == 0;
                                        int exifOrientation = CameraExtKt.computeExifOrientation(rotation, mirrored);
                                        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"image");
                                        CaptureResult captureResult = (CaptureResult)this.$result;
                                        Integer n2 = Boxing.boxInt((int)exifOrientation);
                                        ImageReader imageReader2 = this.this$0.getImageReader();
                                        Intrinsics.checkNotNull((Object)imageReader2);
                                        this.$cont.resumeWith(Result.constructor-impl((Object)new ImageCaptureModel(image, captureResult, n2, imageReader2.getImageFormat())));
                                    }
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }, this.cameraHandler));
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private static final void setZoom$lambda$2(CameraControl this$0, float $zoomValue, String $currentCameraIndex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentCameraIndex, (String)"$currentCameraIndex");
        this$0.setZoomInternal($zoomValue, $currentCameraIndex);
    }

    private static final void resetZoom$lambda$3(CameraControl this$0, String $currentCameraIndex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentCameraIndex, (String)"$currentCameraIndex");
        this$0.setZoomInternal(this$0.getMinZoom(), $currentCameraIndex);
    }

    private static final void setTapToFocusAt$lambda$7(CameraControl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.currentCameraSession != null) {
            CameraControl cameraControl = this$0;
            try {
                Integer n;
                CameraControl $this$setTapToFocusAt_u24lambda_u247_u24lambda_u246 = cameraControl;
                boolean bl = false;
                CameraCaptureSession cameraCaptureSession = $this$setTapToFocusAt_u24lambda_u247_u24lambda_u246.currentCameraSession;
                if (cameraCaptureSession != null) {
                    CaptureRequest.Builder builder = $this$setTapToFocusAt_u24lambda_u247_u24lambda_u246.captureRequestBuilder;
                    Intrinsics.checkNotNull((Object)builder);
                    n = cameraCaptureSession.setRepeatingRequest(builder.build(), new CameraCaptureSession.CaptureCallback($this$setTapToFocusAt_u24lambda_u247_u24lambda_u246){
                        final /* synthetic */ CameraControl $this_runCatching;
                        {
                            this.$this_runCatching = $receiver;
                        }

                        public void onCaptureProgressed(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull CaptureResult partialResult) {
                            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                            Intrinsics.checkNotNullParameter((Object)partialResult, (String)"partialResult");
                            super.onCaptureProgressed(session, request, partialResult);
                            CameraControl.access$autoFocusCallbackResult(this.$this_runCatching, partialResult);
                        }

                        public void onCaptureCompleted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull TotalCaptureResult result2) {
                            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                            super.onCaptureCompleted(session, request, result2);
                            CameraControl.access$autoFocusCallbackResult(this.$this_runCatching, (CaptureResult)result2);
                        }
                    }, $this$setTapToFocusAt_u24lambda_u247_u24lambda_u246.cameraHandler);
                } else {
                    n = null;
                }
                Object object = Result.constructor-impl(n);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private static final void setFlash$lambda$10(CameraControl this$0, int $mode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Integer n;
            boolean bl = false;
            CaptureRequest.Builder builder = this$0.captureRequestBuilder;
            if (builder != null) {
                builder.set(CaptureRequest.FLASH_MODE, (Object)$mode);
            }
            CameraCaptureSession cameraCaptureSession = this$0.currentCameraSession;
            if (cameraCaptureSession != null) {
                CaptureRequest.Builder builder2 = this$0.captureRequestBuilder;
                Intrinsics.checkNotNull((Object)builder2);
                n = cameraCaptureSession.setRepeatingRequest(builder2.build(), new CameraCaptureSession.CaptureCallback(){}, this$0.cameraHandler);
            } else {
                n = null;
            }
            Object object = Result.constructor-impl(n);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public static final /* synthetic */ Mutex access$getCameraCaptureMutex$p(CameraControl $this) {
        return $this.cameraCaptureMutex;
    }

    public static final /* synthetic */ Object access$takePictureInternal(CameraControl $this, Continuation $completion) {
        return $this.takePictureInternal((Continuation<? super ImageCaptureModel>)$completion);
    }

    public static final /* synthetic */ void access$autoFocusCallbackResult(CameraControl $this, CaptureResult result2) {
        $this.autoFocusCallbackResult(result2);
    }

    public static final /* synthetic */ Handler access$getImageReaderHandler(CameraControl $this) {
        return $this.getImageReaderHandler();
    }

    public static final /* synthetic */ long access$getIMAGE_CAPTURE_TIMEOUT_MILLIS$p(CameraControl $this) {
        return $this.IMAGE_CAPTURE_TIMEOUT_MILLIS;
    }

    public static final /* synthetic */ HandlerThread access$getImageReaderThread(CameraControl $this) {
        return $this.getImageReaderThread();
    }
}

