/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.signal.jsonrpc;

import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import live.hms.video.connection.models.HMSSessionDescription;
import live.hms.video.connection.models.HMSTrickle;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.groups.GroupJoinLeaveResponse;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.polls.HMSPollResponseBuilder;
import live.hms.video.polls.models.HmsPollState;
import live.hms.video.polls.models.answer.PollAnswerResponse;
import live.hms.video.polls.network.HMSPollLeaderboardResponse;
import live.hms.video.polls.network.PollCreateResponse;
import live.hms.video.polls.network.PollGetResponsesReply;
import live.hms.video.polls.network.PollLeaderboardResponse;
import live.hms.video.polls.network.PollListResponse;
import live.hms.video.polls.network.PollQuestionGetResponse;
import live.hms.video.polls.network.PollResultsResponse;
import live.hms.video.polls.network.SetQuestionsResponse;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.models.EVENT_TYPE;
import live.hms.video.sdk.models.FindPeerResponse;
import live.hms.video.sdk.models.HMSHLSConfig;
import live.hms.video.sdk.models.HMSHLSTimedMetadata;
import live.hms.video.sdk.models.HMSMessageSendResponse;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRecordingConfig;
import live.hms.video.sdk.models.IRetryAttemptTracking;
import live.hms.video.sdk.models.PeerNameSearchResponse;
import live.hms.video.sdk.models.TranscriptionStartResponse;
import live.hms.video.sdk.models.TranscriptionStopResponse;
import live.hms.video.sdk.models.TranscriptionsMode;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sessionstore.SessionMetadataResult;
import live.hms.video.sessionstore.SetMetadataListenerResult;
import live.hms.video.sessionstore.SetSessionMetadataResult;
import live.hms.video.signal.HMSSignalMethod;
import live.hms.video.signal.ISignal;
import live.hms.video.signal.ISignalEventsObserver;
import live.hms.video.signal.jsonrpc.HMSWebSocketListener;
import live.hms.video.signal.jsonrpc.JSONRpcSignal;
import live.hms.video.signal.jsonrpc.models.HMSParams;
import live.hms.video.signal.jsonrpc.models.JsonRpcRequest;
import live.hms.video.transport.models.TransportFailureCategory;
import live.hms.video.utils.CoroutineExceptionTrackerKt;
import live.hms.video.utils.ExtensionUtilsKt;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.IdHelper;
import live.hms.video.whiteboard.network.HMSCreateWhiteBoardResponse;
import live.hms.video.whiteboard.network.HMSGetWhiteBoardResponse;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00e0\u00012\u00020\u00012\u00020\u0002:\u0004\u00df\u0001\u00e0\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\"\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0016J7\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J5\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0019\u00108\u001a\u00020#2\u0006\u00109\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0019\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J#\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\n2\b\u00109\u001a\u0004\u0018\u00010@H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJE\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020\u00072\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010\n2\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010(2\u0006\u0010H\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010IJ)\u0010B\u001a\u00020#2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ\b\u0010N\u001a\u00020#H\u0016J\u0019\u0010O\u001a\u00020P2\u0006\u00103\u001a\u00020QH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010RJ\u0019\u0010S\u001a\u00020T2\u0006\u00103\u001a\u00020UH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\u0019\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J!\u0010\\\u001a\u00020\u00072\u0006\u0010]\u001a\u00020\n2\u0006\u0010^\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010_J\u0010\u0010`\u001a\u00020#2\u0006\u0010`\u001a\u00020aH\u0016JI\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010\n2\b\u0010e\u001a\u0004\u0018\u00010\n2\u001a\u0010f\u001a\u0016\u0012\u0004\u0012\u00020\n\u0018\u00010\u001cj\n\u0012\u0004\u0012\u00020\n\u0018\u0001`\u001e2\u0006\u0010g\u001a\u00020hH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\u001b\u0010j\u001a\u00020k2\b\u0010?\u001a\u0004\u0018\u00010\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0019\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J!\u0010o\u001a\u00020#2\u0006\u0010L\u001a\u00020\n2\u0006\u0010d\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010pJ\u0019\u0010q\u001a\u00020r2\u0006\u0010d\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0019\u0010s\u001a\u00020r2\u0006\u0010d\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J!\u0010t\u001a\u00020#2\u0006\u0010L\u001a\u00020\n2\u0006\u0010d\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010pJE\u0010u\u001a\u00020$2\u0006\u0010<\u001a\u00020\n2\u0006\u0010v\u001a\u00020\n2\u0006\u0010w\u001a\u00020\u00072\b\u0010x\u001a\u0004\u0018\u00010$2\b\u0010y\u001a\u0004\u0018\u00010z2\u0006\u0010{\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010|J\u0010\u0010}\u001a\u00020#2\u0006\u0010~\u001a\u00020\u0007H\u0016J\u0018\u0010\u007f\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J2\u0010x\u001a\u00020$2\u0006\u0010x\u001a\u00020$2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010(2\u0006\u0010%\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0082\u0001J#\u0010\u0083\u0001\u001a\u00020#2\u0007\u0010\u0084\u0001\u001a\u00020 2\u0007\u0010\u0085\u0001\u001a\u00020h2\u0006\u0010]\u001a\u00020\nH\u0016J(\u0010\u0086\u0001\u001a\u00020#2\u0007\u0010\u0084\u0001\u001a\u00020 2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0016J\u001b\u0010\u008b\u0001\u001a\u00020#2\u0007\u0010\u0084\u0001\u001a\u00020 2\u0007\u0010\u008c\u0001\u001a\u00020\nH\u0016J\u001c\u0010\u008d\u0001\u001a\u00020#2\u0007\u0010\u0084\u0001\u001a\u00020 2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u001b\u0010\u008e\u0001\u001a\u00020#2\u0007\u0010\u008f\u0001\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J$\u0010\u0090\u0001\u001a\u00020c2\u0007\u0010\u0091\u0001\u001a\u00020\n2\u0006\u0010g\u001a\u00020hH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J/\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0006\u0010g\u001a\u00020h2\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0098\u0001J\u001e\u0010\u0099\u0001\u001a\u00030\u009a\u00012\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u009d\u0001J\u001e\u0010\u009e\u0001\u001a\u00030\u009f\u00012\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a2\u0001J2\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u00012\u0007\u0010\u00a7\u0001\u001a\u00020h2\t\u0010\u00a8\u0001\u001a\u0004\u0018\u00010\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a9\u0001J\u001e\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\b\u0010\u00a0\u0001\u001a\u00030\u00ac\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ad\u0001J\u001c\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\u0007\u0010\u00b0\u0001\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u001e\u0010\u00b1\u0001\u001a\u00030\u00b2\u00012\b\u0010\u00b1\u0001\u001a\u00030\u00b3\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b4\u0001J\u001b\u0010\u00b5\u0001\u001a\u00020#2\u0007\u0010\u00b0\u0001\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u001b\u0010\u00b6\u0001\u001a\u00020#2\u0007\u0010\u00b0\u0001\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\"\u0010\u00b7\u0001\u001a\u00020#2\u0006\u0010L\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010pJ1\u0010\u00b8\u0001\u001a\u00020#2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u00ba\u0001\u001a\u00020\n2\n\u0010\u00bb\u0001\u001a\u0005\u0018\u00010\u00bc\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00bd\u0001J-\u0010\u00be\u0001\u001a\u00020#2\u0007\u0010\u00bf\u0001\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00072\u0007\u0010\u00ba\u0001\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00c0\u0001J\u001c\u0010\u00c1\u0001\u001a\u00030\u00c2\u00012\u0006\u00103\u001a\u000204H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00c3\u0001J/\u0010\u00c4\u0001\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0007\u0010\u00c5\u0001\u001a\u00020\n2\u0011\b\u0002\u0010\u00c6\u0001\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001aH\u0002J#\u0010\u00c7\u0001\u001a\u00020#2\u000e\u0010\u00c8\u0001\u001a\t\u0012\u0005\u0012\u00030\u00c9\u00010(H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ca\u0001J#\u0010\u00cb\u0001\u001a\u00030\u00cc\u00012\r\u0010\u00cd\u0001\u001a\b\u0012\u0004\u0012\u00020\n0(H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ca\u0001J\u001f\u0010\u00ce\u0001\u001a\u00020#2\n\u0010\u00cf\u0001\u001a\u0005\u0018\u00010\u00d0\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d1\u0001J\u001d\u0010\u00d2\u0001\u001a\u00020#2\b\u0010\u00d3\u0001\u001a\u00030\u00d4\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d5\u0001J\u001d\u0010\u00d6\u0001\u001a\u00020#2\b\u0010\u00cf\u0001\u001a\u00030\u00d7\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d8\u0001J\u001f\u0010\u00d9\u0001\u001a\u00020#2\n\u0010\u00cf\u0001\u001a\u0005\u0018\u00010\u00d0\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d1\u0001J\u001d\u0010\u00da\u0001\u001a\u00020#2\b\u0010\u00d3\u0001\u001a\u00030\u00d4\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d5\u0001J\u0013\u0010\u00db\u0001\u001a\u00020#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00dc\u0001J\u0019\u0010\u00dd\u0001\u001a\u00020#2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010(H\u0016J\u0012\u0010\u00de\u0001\u001a\u00020#2\u0007\u0010\u00de\u0001\u001a\u00020\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00e1\u0001"}, d2={"Llive/hms/video/signal/jsonrpc/JSONRpcSignal;", "Llive/hms/video/signal/ISignal;", "Llive/hms/video/signal/jsonrpc/HMSWebSocketListener;", "observer", "Llive/hms/video/signal/ISignalEventsObserver;", "(Llive/hms/video/signal/ISignalEventsObserver;)V", "_isConnected", "", "callbacks", "Ljava/util/HashMap;", "", "Llive/hms/video/signal/jsonrpc/JSONRpcSignal$Callback;", "Lkotlin/collections/HashMap;", "isConnected", "()Z", "isJoinCompleted", "isLeaveInProgress", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "getMutex", "()Lkotlinx/coroutines/sync/Mutex;", "mutex$delegate", "Lkotlin/Lazy;", "getObserver", "()Llive/hms/video/signal/ISignalEventsObserver;", "onRoleChangeDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "pendingTrickle", "Ljava/util/ArrayList;", "Llive/hms/video/connection/models/HMSTrickle;", "Lkotlin/collections/ArrayList;", "socket", "Lokhttp3/WebSocket;", "webSocketOpenDeferred", "answer", "", "Llive/hms/video/connection/models/HMSSessionDescription;", "nodeInfo", "bulkRoleChangeRequest", "ofRoles", "", "Llive/hms/video/sdk/models/role/HMSRole;", "toRole", "force", "hmsActionResultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "(Ljava/util/List;Llive/hms/video/sdk/models/role/HMSRole;ZLlive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "call", "T", "method", "Llive/hms/video/signal/HMSSignalMethod;", "params", "Llive/hms/video/signal/jsonrpc/models/HMSParams;", "c", "Ljava/lang/Class;", "(Llive/hms/video/signal/HMSSignalMethod;Llive/hms/video/signal/jsonrpc/models/HMSParams;Ljava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeMetadata", "metadata", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeName", "name", "changeSessionMetadata", "Llive/hms/video/sessionstore/SetSessionMetadataResult;", "key", "Lcom/google/gson/JsonElement;", "(Ljava/lang/String;Lcom/google/gson/JsonElement;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeTrackState", "mute", "type", "Llive/hms/video/media/tracks/HMSTrackType;", "source", "roles", "requestedByPeerId", "(ZLlive/hms/video/media/tracks/HMSTrackType;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hmsTrack", "Llive/hms/video/media/tracks/HMSTrack;", "peerId", "(Llive/hms/video/media/tracks/HMSTrack;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "createPoll", "Llive/hms/video/polls/network/PollCreateResponse;", "Llive/hms/video/signal/jsonrpc/models/HMSParams$SetPollParams;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams$SetPollParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createQuestion", "Llive/hms/video/polls/network/SetQuestionsResponse;", "Llive/hms/video/signal/jsonrpc/models/HMSParams$PollQuestionsSet;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams$PollQuestionsSet;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createWhiteBoard", "Llive/hms/video/whiteboard/network/HMSCreateWhiteBoardResponse;", "options", "Llive/hms/video/signal/jsonrpc/models/HMSParams$Options;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endRoom", "reason", "lock", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "event", "Llive/hms/video/events/AnalyticsEvent;", "findPeer", "Llive/hms/video/sdk/models/FindPeerResponse;", "groupName", "roleName", "peerIds", "limit", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSessionMetadata", "Llive/hms/video/sessionstore/SessionMetadataResult;", "getWhiteBoard", "Llive/hms/video/whiteboard/network/HMSGetWhiteBoardResponse;", "id", "groupAdd", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "groupJoin", "Llive/hms/video/groups/GroupJoinLeaveResponse;", "groupLeave", "groupRemove", "join", "data", "serverSideSubscribeDegradation", "offer", "retryAttemptTracking", "Llive/hms/video/sdk/models/IRetryAttemptTracking;", "simulcastEnabled", "(Ljava/lang/String;Ljava/lang/String;ZLlive/hms/video/connection/models/HMSSessionDescription;Llive/hms/video/sdk/models/IRetryAttemptTracking;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "leave", "notifyServer", "notify", "tracks", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "(Llive/hms/video/connection/models/HMSSessionDescription;Ljava/util/List;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onClosed", "webSocket", "code", "onFailure", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "onOpen", "open", "uri", "peerIteratorNext", "iteratorId", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "peerNameSearch", "Llive/hms/video/sdk/models/PeerNameSearchResponse;", "query", "offset", "", "(Ljava/lang/String;IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollAddResponse", "Llive/hms/video/polls/models/answer/PollAnswerResponse;", "hmsPollResponseBuilder", "Llive/hms/video/polls/HMSPollResponseBuilder;", "(Llive/hms/video/polls/HMSPollResponseBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollGetLeaderboard", "Llive/hms/video/polls/network/PollLeaderboardResponse;", "param", "Llive/hms/video/signal/jsonrpc/models/HMSParams$PollLeaderboardQuery;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams$PollLeaderboardQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollGetList", "Llive/hms/video/polls/network/PollListResponse;", "state", "Llive/hms/video/polls/models/HmsPollState;", "count", "start", "(Llive/hms/video/polls/models/HmsPollState;ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollGetResponses", "Llive/hms/video/polls/network/PollGetResponsesReply;", "Llive/hms/video/signal/jsonrpc/models/HMSParams$PollResponsesQuery;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams$PollResponsesQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollGetResults", "Llive/hms/video/polls/network/PollResultsResponse;", "pollId", "pollQuestionsGet", "Llive/hms/video/polls/network/PollQuestionGetResponse;", "Llive/hms/video/signal/jsonrpc/models/HMSParams$PollQuestionsGet;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams$PollQuestionsGet;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollStart", "pollStop", "removePeer", "roleChangeAccept", "token", "role", "requestedBy", "Llive/hms/video/sdk/models/HMSPeer;", "(Ljava/lang/String;Ljava/lang/String;Llive/hms/video/sdk/models/HMSPeer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "roleChangeRequest", "forPeerId", "(Ljava/lang/String;ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendMessage", "Llive/hms/video/sdk/models/HMSMessageSendResponse;", "(Llive/hms/video/signal/jsonrpc/models/HMSParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendSocketMessage", "message", "deferred", "setHlsSessionMetadata", "metadataModelList", "Llive/hms/video/sdk/models/HMSHLSTimedMetadata;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setMetadataListener", "Llive/hms/video/sessionstore/SetMetadataListenerResult;", "tags", "startHLSStreaming", "config", "Llive/hms/video/sdk/models/HMSHLSConfig;", "(Llive/hms/video/sdk/models/HMSHLSConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startRealTimeTranscription", "mode", "Llive/hms/video/sdk/models/TranscriptionsMode;", "(Llive/hms/video/sdk/models/TranscriptionsMode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startRtmpOrRecording", "Llive/hms/video/sdk/models/HMSRecordingConfig;", "(Llive/hms/video/sdk/models/HMSRecordingConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopHLSStreaming", "stopRealTimeTranscription", "stopRtmpAndRecording", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackUpdate", "trickle", "Callback", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nJSONRpcSignal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONRpcSignal.kt\nlive/hms/video/signal/jsonrpc/JSONRpcSignal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,834:1\n1855#2,2:835\n*S KotlinDebug\n*F\n+ 1 JSONRpcSignal.kt\nlive/hms/video/signal/jsonrpc/JSONRpcSignal\n*L\n219#1:835,2\n*E\n"})
public final class JSONRpcSignal
extends HMSWebSocketListener
implements ISignal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ISignalEventsObserver observer;
    private boolean _isConnected;
    @NotNull
    private CompletableDeferred<Boolean> webSocketOpenDeferred;
    @NotNull
    private CompletableDeferred<Boolean> onRoleChangeDeferred;
    @Nullable
    private WebSocket socket;
    @NotNull
    private final HashMap<String, Callback> callbacks;
    @NotNull
    private final Lazy mutex$delegate;
    @NotNull
    private final ArrayList<HMSTrickle> pendingTrickle;
    private boolean isJoinCompleted;
    private boolean isLeaveInProgress;
    @NotNull
    public static final String TAG = "JsonRPCSignal";

    public JSONRpcSignal(@NotNull ISignalEventsObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observer = observer;
        this.webSocketOpenDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.onRoleChangeDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.callbacks = new HashMap();
        this.mutex$delegate = LazyKt.lazy((Function0)mutex.2.INSTANCE);
        this.pendingTrickle = new ArrayList();
    }

    @Override
    @NotNull
    public ISignalEventsObserver getObserver() {
        return this.observer;
    }

    @Override
    public boolean isConnected() {
        return this._isConnected;
    }

    @Override
    @Nullable
    public Object setMetadataListener(@NotNull List<String> tags, @NotNull Continuation<? super SetMetadataListenerResult> $completion) {
        HMSParams.ListenMetadataChangeRequest params = new HMSParams.ListenMetadataChangeRequest(tags, null, 2, null);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super SetMetadataListenerResult>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.ListenMetadataChangeRequest $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.LISTEN_METADATA_CHANGE, this.$params, SetMetadataListenerResult.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super SetMetadataListenerResult> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    private final Mutex getMutex() {
        Lazy lazy = this.mutex$delegate;
        return (Mutex)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final <T> Object call(HMSSignalMethod var1_1, HMSParams var2_2, Class<T> var3_3, Continuation<? super T> var4_4) {
        if (!(var4_4 instanceof call.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSONRpcSignal.access$call(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                id = IdHelper.INSTANCE.makeCallSignalId();
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                message = new JsonRpcRequest(id, (HMSSignalMethod)method, (HMSParams)params).toJson();
                ((Map)this.callbacks).put(id, new Callback((CompletableDeferred<String>)deferred, message, var1_1));
                HMSLogger.d("JsonRPCSignal", "Sending ws message: [size=" + message.length() + "] " + message);
                this.sendSocketMessage(this.socket, message, (CompletableDeferred<String>)deferred);
                $continuation.L$0 = this;
                $continuation.L$1 = c;
                $continuation.L$2 = id;
                $continuation.label = 1;
                v0 = deferred.await($continuation);
                ** if (v0 != var12_7) goto lbl28
lbl27:
                // 1 sources

                return var12_7;
lbl28:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                id = (String)$continuation.L$2;
                c = (Class)$continuation.L$1;
                this = (JSONRpcSignal)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl37:
                    // 2 sources

                    result = (String)v0;
                    this.callbacks.remove(id);
                    var9_14 = GsonUtils.INSTANCE.getGson().fromJson(result, c);
                    return var9_14;
                }
                catch (UninitializedPropertyAccessException var8_12) {
                    throw ErrorFactory.GenericErrors.NotConnected$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.NONE, "Websocket was either not initialized or not connected", null, null, 12, null);
                }
            }
            catch (Throwable var8_13) {
                throw var8_13;
            }
            {
                finally {
                    this.callbacks.remove(id);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendSocketMessage(WebSocket socket, String message, CompletableDeferred<String> deferred) {
        Boolean sendResultIsSuccessful;
        if (socket == null && deferred != null) {
            deferred.completeExceptionally((Throwable)ErrorFactory.WebSocketConnectionErrors.WebSocketNotAvailable$default(ErrorFactory.WebSocketConnectionErrors.INSTANCE, ErrorFactory.Action.NONE, "Websocket is not ready yet or has been destroyed", null, null, 12, null));
            return;
        }
        WebSocket webSocket = socket;
        Boolean bl = sendResultIsSuccessful = webSocket != null ? Boolean.valueOf(webSocket.send(message)) : null;
        if (sendResultIsSuccessful != null && Intrinsics.areEqual((Object)sendResultIsSuccessful, (Object)false) && deferred != null) {
            deferred.completeExceptionally((Throwable)ErrorFactory.WebSocketConnectionErrors.WebSocketConnectionLost$default(ErrorFactory.WebSocketConnectionErrors.INSTANCE, ErrorFactory.Action.NONE, "WebSocket Disconnected", null, null, 12, null));
        }
    }

    static /* synthetic */ void sendSocketMessage$default(JSONRpcSignal jSONRpcSignal, WebSocket webSocket, String string, CompletableDeferred completableDeferred, int n, Object object) {
        if ((n & 4) != 0) {
            completableDeferred = null;
        }
        jSONRpcSignal.sendSocketMessage(webSocket, string, (CompletableDeferred<String>)completableDeferred);
    }

    private final void notify(HMSSignalMethod method, HMSParams params) {
        String message = new JsonRpcRequest(method, params).toJson();
        HMSLogger.d(TAG, "Sending ws message: [size=" + message.length() + "] " + message);
        this.sendSocketMessage(this.socket, message, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object open(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof open.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.open(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                HMSLogger.d("JsonRPCSignal", "open: Connecting WebSocket to endpoint=" + uri + " \u23f0");
                if (this.webSocketOpenDeferred.isCompleted()) {
                    this.webSocketOpenDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                }
                this.socket = OkHttpFactory.INSTANCE.makeWebSocket(uri, this);
                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.label = 1;
                v0 = this.webSocketOpenDeferred.await((Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                uri = (String)$continuation.L$1;
                this = (JSONRpcSignal)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                this._isConnected = true;
                HMSLogger.d("JsonRPCSignal", "open: WebSocket connected to endpoint=" + uri + " \u2705");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object join(@NotNull String var1_1, @NotNull String var2_2, boolean var3_3, @Nullable HMSSessionDescription var4_4, @Nullable IRetryAttemptTracking var5_5, boolean var6_6, @NotNull Continuation<? super HMSSessionDescription> var7_7) {
        if (!(var7_7 instanceof join.1)) ** GOTO lbl-1000
        var17_8 = var7_7;
        if ((var17_8.label & -2147483648) != 0) {
            var17_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_7){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.join(null, null, false, null, null, false, (Continuation<? super HMSSessionDescription>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                params = new HMSParams.Join(var1_1, var2_2, (HMSSessionDescription)offer, false, serverSideSubscribeDegradation != false, simulcastEnabled != false, 8, null);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super HMSSessionDescription>, Object>(this, params, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ HMSParams.Join $params;
                    {
                        this.this$0 = $receiver;
                        this.$params = $params;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.JOIN, this.$params, HMSSessionDescription.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super HMSSessionDescription> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, EVENT_TYPE.JOIN_RETRIES, (IRetryAttemptTracking)retryAttemptTracking, 0, (Continuation)$continuation, 36, null);
                if (v0 == var18_10) {
                    return var18_10;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (JSONRpcSignal)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                res = (HMSSessionDescription)v0;
                this.isJoinCompleted = true;
                $this$forEach$iv = this.pendingTrickle;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (HMSTrickle)element$iv;
                    $i$a$-forEach-JSONRpcSignal$join$2 = false;
                    this.trickle(it);
                }
                this.pendingTrickle.clear();
                return res;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object offer(@NotNull HMSSessionDescription offer2, @NotNull List<HMSNotifications.Track> tracks, @NotNull String nodeInfo, @NotNull Continuation<? super HMSSessionDescription> $completion) {
        HashMap<String, HMSNotifications.Track> tracksMap = new HashMap<String, HMSNotifications.Track>();
        for (HMSNotifications.Track track : tracks) {
            if (!StringsKt.contains$default((CharSequence)offer2.getDescription(), (CharSequence)track.getTrackId(), (boolean)false, (int)2, null)) continue;
            ((Map)tracksMap).put(track.getTrackId(), track);
        }
        HMSParams.SendOffer params = new HMSParams.SendOffer(offer2, tracksMap, nodeInfo);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super HMSSessionDescription>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.SendOffer $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.OFFER, this.$params, HMSSessionDescription.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super HMSSessionDescription> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 56, null);
    }

    @Override
    public void answer(@NotNull HMSSessionDescription answer, @NotNull String nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        this.notify(HMSSignalMethod.ANSWER, new HMSParams.Answer(answer));
    }

    @Override
    public void trickle(@NotNull HMSTrickle trickle) {
        Intrinsics.checkNotNullParameter((Object)trickle, (String)"trickle");
        if (this.isJoinCompleted) {
            this.notify(HMSSignalMethod.TRICKLE, HMSParams.Trickle.Companion.from(trickle));
        } else {
            this.pendingTrickle.add(trickle);
        }
    }

    @Override
    @Nullable
    public Object sendMessage(@NotNull HMSParams params, @NotNull Continuation<? super HMSMessageSendResponse> $completion) {
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super HMSMessageSendResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.BROADCAST, this.$params, HMSMessageSendResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super HMSMessageSendResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    public void trackUpdate(@NotNull List<HMSNotifications.Track> tracks) {
        Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
        HashMap tracksMap = new HashMap();
        for (HMSNotifications.Track track : tracks) {
            ((Map)tracksMap).put(track.getTrackId(), track);
        }
        HMSParams.TrackUpdate params = new HMSParams.TrackUpdate(tracksMap, null, 2, null);
        this.notify(HMSSignalMethod.TRACK_UPDATE, params);
    }

    @Override
    public void leave(boolean notifyServer) {
        this.isLeaveInProgress = true;
        if (notifyServer) {
            this.notify(HMSSignalMethod.LEAVE, new HMSParams.Leave("1.0"));
        }
        this.close();
    }

    @Override
    @Nullable
    public Object bulkRoleChangeRequest(@NotNull List<HMSRole> ofRoles, @NotNull HMSRole toRole, boolean force, @NotNull HMSActionResultListener hmsActionResultListener, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, ofRoles, force, toRole, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ List<HMSRole> $ofRoles;
            final /* synthetic */ boolean $force;
            final /* synthetic */ HMSRole $toRole;
            {
                this.this$0 = $receiver;
                this.$ofRoles = $ofRoles;
                this.$force = $force;
                this.$toRole = $toRole;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable iterable = this.$ofRoles;
                        HMSSignalMethod hMSSignalMethod = HMSSignalMethod.ROLE_CHANGE_REQUEST;
                        JSONRpcSignal jSONRpcSignal = this.this$0;
                        boolean $i$f$map = false;
                        void var4_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            HMSRole hMSRole = (HMSRole)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getName());
                        }
                        collection = (List)destination$iv$iv;
                        String string = this.$toRole.getName();
                        boolean bl = this.$force;
                        List list = collection;
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(jSONRpcSignal, hMSSignalMethod, new HMSParams.BulkRoleChangeRequest(list, bl, string), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object roleChangeRequest(@NotNull String forPeerId, boolean force, @NotNull String role, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, forPeerId, force, role, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $forPeerId;
            final /* synthetic */ boolean $force;
            final /* synthetic */ String $role;
            {
                this.this$0 = $receiver;
                this.$forPeerId = $forPeerId;
                this.$force = $force;
                this.$role = $role;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.ROLE_CHANGE_REQUEST, new HMSParams.RoleChangeRequest(this.$forPeerId, this.$force, this.$role), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object roleChangeAccept(@NotNull String token, @NotNull String role, @Nullable HMSPeer requestedBy, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, token, role, requestedBy, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $token;
            final /* synthetic */ String $role;
            final /* synthetic */ HMSPeer $requestedBy;
            {
                this.this$0 = $receiver;
                this.$token = $token;
                this.$role = $role;
                this.$requestedBy = $requestedBy;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HMSPeer hMSPeer = this.$requestedBy;
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.ROLE_CHANGE, new HMSParams.RoleChangeAccept(this.$token, this.$role, hMSPeer != null ? hMSPeer.getPeerID() : null), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object removePeer(@NotNull String peerId, @NotNull String reason2, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, peerId, reason2, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $peerId;
            final /* synthetic */ String $reason;
            {
                this.this$0 = $receiver;
                this.$peerId = $peerId;
                this.$reason = $reason;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.PEER_LEAVE_REQUEST, new HMSParams.RemovePeerRequest(this.$peerId, this.$reason), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object endRoom(@NotNull String var1_1, boolean var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof endRoom.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.endRoom(null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, lock != false, (String)reason, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ boolean $lock;
                    final /* synthetic */ String $reason;
                    {
                        this.this$0 = $receiver;
                        this.$lock = $lock;
                        this.$reason = $reason;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.END_ROOM, new HMSParams.EndRoomRequest(this.$lock, this.$reason), JsonObject.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, null, null, 0, (Continuation)$continuation, 60, null);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object changeTrackState(@NotNull HMSTrack hmsTrack, @NotNull String peerId, boolean mute, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, peerId, hmsTrack, mute, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $peerId;
            final /* synthetic */ HMSTrack $hmsTrack;
            final /* synthetic */ boolean $mute;
            {
                this.this$0 = $receiver;
                this.$peerId = $peerId;
                this.$hmsTrack = $hmsTrack;
                this.$mute = $mute;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.TRACK_UPDATE_REQUEST, new HMSParams.TrackUpdateRequest(this.$peerId, this.$hmsTrack.getTrackId(), this.$hmsTrack.getStream$lib_release().getId(), this.$mute), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object changeTrackState(boolean mute, @Nullable HMSTrackType type, @Nullable String source, @Nullable List<String> roles, @NotNull String requestedByPeerId, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, roles, type, source, mute, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ List<String> $roles;
            final /* synthetic */ HMSTrackType $type;
            final /* synthetic */ String $source;
            final /* synthetic */ boolean $mute;
            {
                this.this$0 = $receiver;
                this.$roles = $roles;
                this.$type = $type;
                this.$source = $source;
                this.$mute = $mute;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.CHANGE_TRACK_MUTE_STATE_REQUEST, new HMSParams.TrackUpdateAllRequest(null, this.$roles, this.$type, this.$source, this.$mute), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object startRtmpOrRecording(@NotNull HMSRecordingConfig config, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, config, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSRecordingConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.RTMP_START, new HMSParams.RtmpStart(this.$config.getMeetingUrl(), this.$config.getRtmpUrls(), this.$config.getRecord(), this.$config.getResolution(), null, 16, null), JSONObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object startHLSStreaming(@Nullable HMSHLSConfig config, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, config, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSHLSConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HMSHLSConfig hMSHLSConfig = this.$config;
                        HMSHLSConfig hMSHLSConfig2 = this.$config;
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.HLS_START, new HMSParams.HLSStart(hMSHLSConfig != null ? hMSHLSConfig.getMeetingURLVariants() : null, hMSHLSConfig2 != null ? hMSHLSConfig2.getHmsHlsRecordingConfig() : null), JSONObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object stopHLSStreaming(@Nullable HMSHLSConfig config, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, config, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSHLSConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HMSHLSConfig hMSHLSConfig = this.$config;
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.HLS_STOP, new HMSParams.HLSStop(hMSHLSConfig != null ? hMSHLSConfig.getMeetingURLVariants() : null), JSONObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object stopRtmpAndRecording(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof stopRtmpAndRecording.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stopRtmpAndRecording((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.RTMP_STOP, new HMSParams.RtmpStop(null, 1, null), JSONObject.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, null, null, 0, (Continuation)$continuation, 60, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                result = (JSONObject)v0;
                HMSLogger.d("JsonRPCSignal", "Result was " + result);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object changeName(@NotNull String name, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, name, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.PEER_UPDATE, new HMSParams.PeerMetadataUpdate(this.$name, null, null, 4, null), JSONObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object changeMetadata(@NotNull String metadata, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, metadata, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $metadata;
            {
                this.this$0 = $receiver;
                this.$metadata = $metadata;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.PEER_UPDATE, new HMSParams.PeerMetadataUpdate(null, this.$metadata, null, 4, null), JSONObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getSessionMetadata(@Nullable String key, @NotNull Continuation<? super SessionMetadataResult> $completion) {
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super SessionMetadataResult>, Object>(this, key, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.GET_METADATA, new HMSParams.SessionMetadataRequest(this.$key, null, 2, null), SessionMetadataResult.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super SessionMetadataResult> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object changeSessionMetadata(@NotNull String key, @Nullable JsonElement metadata, @NotNull Continuation<? super SetSessionMetadataResult> $completion) {
        HMSParams.SetSessionMetadata param = new HMSParams.SetSessionMetadata(key, metadata, null, null, 12, null);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super SetSessionMetadataResult>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.SetSessionMetadata $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.SET_METADATA, this.$param, SetSessionMetadataResult.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super SetSessionMetadataResult> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object setHlsSessionMetadata(@NotNull List<HMSHLSTimedMetadata> metadataModelList, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JSONObject>, Object>(this, metadataModelList, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ List<HMSHLSTimedMetadata> $metadataModelList;
            {
                this.this$0 = $receiver;
                this.$metadataModelList = $metadataModelList;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String string = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.HLS_TIMED_METADATA, new HMSParams.SetHLSSessionMetadata(this.$metadataModelList, string, null, 4, null), JSONObject.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JSONObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void event(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.notify(HMSSignalMethod.ANALYTICS, HMSParams.Event.Companion.from(event));
    }

    @Override
    public void close() {
        close.isClosed.1 isClosed2;
        HMSLogger.d(TAG, "close: closing socket");
        WebSocket webSocket = this.socket;
        Object object = isClosed2 = webSocket != null ? Boolean.valueOf(webSocket.close(1000, "Closing")) : close.isClosed.1.INSTANCE;
        if (Intrinsics.areEqual((Object)((Object)isClosed2), (Object)true)) {
            HMSLogger.d(TAG, "Successfully closed");
        } else {
            HMSLogger.e(TAG, "Could not close socket");
        }
        this.socket = null;
    }

    @Override
    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        super.onOpen(webSocket, response);
        this.webSocketOpenDeferred.complete((Object)true);
    }

    @Override
    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        HMSLogger.INSTANCE.w(TAG, "OnFailure of web socket");
        this._isConnected = false;
        if (this.onRoleChangeDeferred.isActive()) {
            this.onRoleChangeDeferred.completeExceptionally(t);
        }
        this.onRoleChangeDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        if (this.isLeaveInProgress) {
            this.isLeaveInProgress = false;
            return;
        }
        super.onFailure(webSocket, t, response);
        String string = t.getMessage();
        if (string == null) {
            string = "WebSocket Disconnected";
        }
        HMSException error = ErrorFactory.WebSocketConnectionErrors.WebSocketConnectionLost$default(ErrorFactory.WebSocketConnectionErrors.INSTANCE, ErrorFactory.Action.NONE, string, t, null, 8, null);
        if (response != null && (response.code() == 401 || response.code() == 403)) {
            WebSocket webSocket2 = this.socket;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"endpoint", (Object)String.valueOf(webSocket2 != null && (webSocket2 = webSocket2.request()) != null ? webSocket2.url() : null)), TuplesKt.to((Object)"response_code", (Object)response.code()), TuplesKt.to((Object)"response", (Object)response.toString())};
            error = ErrorFactory.APIErrors.INSTANCE.HTTPError(response.code(), ErrorFactory.Action.INIT, "Token Not Authorized", t, MapsKt.hashMapOf((Pair[])pairArray));
        }
        if (this.webSocketOpenDeferred.isCompleted()) {
            this.getObserver().onFailure(error);
        } else {
            this.webSocketOpenDeferred.completeExceptionally((Throwable)error);
        }
    }

    @Override
    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super.onMessage(webSocket, text);
        JsonObject response = (JsonObject)GsonUtils.INSTANCE.getGson().fromJson(text, JsonObject.class);
        HMSLogger.d(TAG, "message on ws : " + response);
        if (response.has("id")) {
            String id = response.get("id").getAsString();
            if (this.callbacks.containsKey(id)) {
                Callback callback = this.callbacks.remove(id);
                Intrinsics.checkNotNull((Object)callback);
                Callback cb = callback;
                if (response.has("result")) {
                    CompletableDeferred<String> completableDeferred = cb.getDeferred();
                    String string = response.get("result").toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.get(\"result\").toString()");
                    completableDeferred.complete((Object)string);
                } else {
                    HMSLogger.e(TAG, "Server Side Error: [size=" + text.length() + "] " + text);
                    JsonObject error = response.getAsJsonObject("error");
                    int n = error.get("code").getAsInt();
                    ErrorFactory.Action action = cb.getMethod().toErrorAction();
                    String string = error.get("message").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.get(\"message\").asString");
                    HMSException ex = ErrorFactory.WebsocketMethodErrors.ServerErrors$default(ErrorFactory.WebsocketMethodErrors.INSTANCE, n, action, string, null, null, 24, null);
                    cb.getDeferred().completeExceptionally((Throwable)ex);
                }
            } else {
                BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)CoroutineExceptionTrackerKt.exceptionSurfacer(TAG)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, response, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ JsonObject $response;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ISignalEventsObserver iSignalEventsObserver = this.this$0.getObserver();
                                JsonObject jsonObject = this.$response;
                                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"response");
                                this.label = 1;
                                Object object3 = iSignalEventsObserver.onNotification(jsonObject, (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        } else if (response.has("method")) {
            String methodStr = response.get("method").getAsString();
            if (Intrinsics.areEqual((Object)methodStr, (Object)"on-policy-change") && !this.onRoleChangeDeferred.isCompleted()) {
                this.onRoleChangeDeferred.complete((Object)true);
            }
            Intrinsics.checkNotNullExpressionValue((Object)methodStr, (String)"methodStr");
            HMSSignalMethod method = HMSSignalMethod.Companion.from(methodStr);
            if (method == HMSSignalMethod.SDK_NOTIFICATION) {
                String method2;
                JsonElement jsonElement = response.get("method");
                String string = method2 = jsonElement != null ? jsonElement.getAsString() : null;
                if (method2 == null) {
                    HMSLogger.INSTANCE.w(TAG, "Ignoring notification with no method: " + response);
                    return;
                }
                JsonObject jsonObject = response.get("params").getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"response.get(\"params\").asJsonObject");
                HMSNotifications params = HMSNotifications.Companion.from(method2, jsonObject);
                if (params instanceof HMSNotifications.Unsupported) {
                    HMSLogger.INSTANCE.w(TAG, "Ignoring unsupported notification: " + response);
                    return;
                }
                if (Intrinsics.areEqual((Object)method2, (Object)"node-info") || Intrinsics.areEqual((Object)method2, (Object)"on-policy-change")) {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)CoroutineExceptionTrackerKt.exceptionSurfacer(TAG)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, method2, response, null){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        int label;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ String $method;
                        final /* synthetic */ JsonObject $response;
                        {
                            this.this$0 = $receiver;
                            this.$method = $method;
                            this.$response = $response;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var2_3 = JSONRpcSignal.access$getMutex(this.this$0);
                                    var4_4 = this.$method;
                                    var5_5 = this.this$0;
                                    var6_6 = this.$response;
                                    owner$iv = null;
                                    $i$f$withLock = false;
                                    this.L$0 = $this$withLock_u24default$iv;
                                    this.L$1 = var4_4;
                                    this.L$2 = var5_5;
                                    this.L$3 = var6_6;
                                    this.label = 1;
                                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                    if (v0 == var10_2) {
                                        return var10_2;
                                    }
                                    ** GOTO lbl31
                                }
                                case 1: {
                                    $i$f$withLock = false;
                                    var6_6 = (JsonObject)this.L$3;
                                    var5_5 = (JSONRpcSignal)this.L$2;
                                    var4_4 = (String)this.L$1;
                                    owner$iv = null;
                                    $this$withLock_u24default$iv = (Mutex)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl31:
                                    // 3 sources

                                    $i$a$-withLock$default-JSONRpcSignal$onMessage$2$1 = false;
                                    HMSLogger.d("SFUMIGRATION", var4_4 + " received. Taking lock");
                                    v1 = var5_5.getObserver();
                                    Intrinsics.checkNotNullExpressionValue((Object)var6_6, (String)"response");
                                    this.L$0 = $this$withLock_u24default$iv;
                                    this.L$1 = var4_4;
                                    this.L$2 = null;
                                    this.L$3 = null;
                                    this.label = 2;
                                    v2 = v1.onNotification(var6_6, (Continuation<? super Unit>)this);
                                    ** if (v2 != var10_2) goto lbl44
lbl43:
                                    // 1 sources

                                    return var10_2;
lbl44:
                                    // 1 sources

                                    ** GOTO lbl55
                                }
                                case 2: {
                                    $i$f$withLock = false;
                                    $i$a$-withLock$default-JSONRpcSignal$onMessage$2$1 = false;
                                    var4_4 = (String)this.L$1;
                                    owner$iv = null;
                                    $this$withLock_u24default$iv = (Mutex)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl55:
                                        // 2 sources

                                        HMSLogger.d("SFUMIGRATION", var4_4 + " Handling done. Unlocking ");
                                        var9_13 = Unit.INSTANCE;
                                    }
                                    catch (Throwable var9_14) {
                                        throw var9_14;
                                    }
                                    finally {
                                        $this$withLock_u24default$iv.unlock(owner$iv);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                } else {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)CoroutineExceptionTrackerKt.exceptionSurfacer(TAG)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, response, null){
                        int label;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ JsonObject $response;
                        {
                            this.this$0 = $receiver;
                            this.$response = $response;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    ISignalEventsObserver iSignalEventsObserver = this.this$0.getObserver();
                                    JsonObject jsonObject = this.$response;
                                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"response");
                                    this.label = 1;
                                    Object object3 = iSignalEventsObserver.onNotification(jsonObject, (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
                return;
            }
            JsonObject jsonObject = response.get("params").getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"response.get(\"params\").asJsonObject");
            HMSParams params = HMSParams.Companion.fromReceivedParams(method, jsonObject);
            if (params instanceof HMSParams.Unsupported) {
                HMSLogger.INSTANCE.w(TAG, "Ignoring unsupported notification: " + response.get("params"));
                return;
            }
            HMSLogger.INSTANCE.v(TAG, "[method=" + (Object)((Object)method) + "] Received params=" + params);
            switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                case 1: {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, params, null){
                        int label;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ HMSParams $params;
                        {
                            this.this$0 = $receiver;
                            this.$params = $params;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    ISignalEventsObserver iSignalEventsObserver = this.this$0.getObserver();
                                    HMSParams hMSParams = this.$params;
                                    Intrinsics.checkNotNull((Object)hMSParams, (String)"null cannot be cast to non-null type live.hms.video.signal.jsonrpc.models.HMSParams.Trickle");
                                    iSignalEventsObserver.onTrickle(((HMSParams.Trickle)hMSParams).toTrickle());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                case 2: {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, params, null){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int label;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ HMSParams $params;
                        {
                            this.this$0 = $receiver;
                            this.$params = $params;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var2_3 = JSONRpcSignal.access$getMutex(this.this$0);
                                    var4_4 = this.this$0;
                                    var5_5 = this.$params;
                                    owner$iv = null;
                                    $i$f$withLock = false;
                                    this.L$0 = $this$withLock_u24default$iv;
                                    this.L$1 = var4_4;
                                    this.L$2 = var5_5;
                                    this.label = 1;
                                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                    if (v0 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl28
                                }
                                case 1: {
                                    $i$f$withLock = false;
                                    var5_5 = (HMSParams)this.L$2;
                                    var4_4 = (JSONRpcSignal)this.L$1;
                                    owner$iv = null;
                                    $this$withLock_u24default$iv = (Mutex)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl28:
                                    // 3 sources

                                    $i$a$-withLock$default-JSONRpcSignal$onMessage$5$1 = false;
                                    v1 = var4_4.getObserver();
                                    Intrinsics.checkNotNull((Object)var5_5, (String)"null cannot be cast to non-null type live.hms.video.signal.jsonrpc.models.HMSParams.Offer");
                                    this.L$0 = $this$withLock_u24default$iv;
                                    this.L$1 = null;
                                    this.L$2 = null;
                                    this.label = 2;
                                    v2 = v1.onOffer(((HMSParams.Offer)var5_5).toSDP(), (Continuation<? super Unit>)this);
                                    ** if (v2 != var9_2) goto lbl39
lbl38:
                                    // 1 sources

                                    return var9_2;
lbl39:
                                    // 1 sources

                                    ** GOTO lbl49
                                }
                                case 2: {
                                    $i$f$withLock = false;
                                    $i$a$-withLock$default-JSONRpcSignal$onMessage$5$1 = false;
                                    owner$iv = null;
                                    $this$withLock_u24default$iv = (Mutex)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl49:
                                        // 2 sources

                                        var8_12 = Unit.INSTANCE;
                                    }
                                    catch (Throwable var8_13) {
                                        throw var8_13;
                                    }
                                    finally {
                                        $this$withLock_u24default$iv.unlock(owner$iv);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                case 3: {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(params, this, method, null){
                        int label;
                        final /* synthetic */ HMSParams $params;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ HMSSignalMethod $method;
                        {
                            this.$params = $params;
                            this.this$0 = $receiver;
                            this.$method = $method;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    HMSParams hMSParams = this.$params;
                                    Intrinsics.checkNotNull((Object)hMSParams, (String)"null cannot be cast to non-null type live.hms.video.signal.jsonrpc.models.HMSParams.OnError");
                                    HMSParams.OnError cfr_ignored_0 = (HMSParams.OnError)hMSParams;
                                    this.this$0.getObserver().onServerError(ErrorFactory.WebsocketMethodErrors.ServerErrors$default(ErrorFactory.WebsocketMethodErrors.INSTANCE, ((HMSParams.OnError)this.$params).getCode(), this.$method.toErrorAction(), ((HMSParams.OnError)this.$params).getMessage(), null, null, 24, null));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                default: {
                    HMSLogger.INSTANCE.w(TAG, "Received unknown " + (Object)((Object)method) + " message from server, [size=" + text.length() + "] " + text);
                    break;
                }
            }
        } else {
            HMSLogger.INSTANCE.w(TAG, "WebSocket message has no `method` or `id` field, message=" + response);
        }
    }

    @Override
    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason2) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason2, (String)"reason");
        super.onClosed(webSocket, code, reason2);
        HMSLogger.INSTANCE.w(TAG, "onClosed signal with reason = " + reason2);
        this.isLeaveInProgress = false;
        this._isConnected = false;
    }

    @Override
    @Nullable
    public Object createPoll(@NotNull HMSParams.SetPollParams params, @NotNull Continuation<? super PollCreateResponse> $completion) {
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super PollCreateResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.SetPollParams $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_INFO_SET, this.$params, PollCreateResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PollCreateResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object createQuestion(@NotNull HMSParams.PollQuestionsSet var1_1, @NotNull Continuation<? super SetQuestionsResponse> var2_2) {
        if (!(var2_2 instanceof createQuestion.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createQuestion(null, (Continuation<? super SetQuestionsResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Log.d((String)"PollsSetQuestionz", (String)("Params: " + ExtensionUtilsKt.toJsonObject(params)));
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, (HMSParams.PollQuestionsSet)params, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ HMSParams.PollQuestionsSet $params;
                    {
                        this.this$0 = $receiver;
                        this.$params = $params;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_QUESTIONS_SET, this.$params, JsonObject.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, null, null, 0, (Continuation)$continuation, 60, null);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                result = (JsonObject)v0;
                Log.d((String)"PollsSetQuestions", (String)("Setz: " + result));
                v1 = GsonUtils.INSTANCE.getGson().fromJson((JsonElement)result, SetQuestionsResponse.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"gson.fromJson(result, Se\u2026ionsResponse::class.java)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object pollStart(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof pollStart.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.pollStart(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Log.d((String)"PollStart", (String)"starting");
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, (String)pollId, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ String $pollId;
                    {
                        this.this$0 = $receiver;
                        this.$pollId = $pollId;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_START, new HMSParams.PollStartRequest(this.$pollId, null, 2, null), JsonObject.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, null, null, 0, (Continuation)$continuation, 60, null);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                result = (JsonObject)v0;
                Log.d((String)"WebsocketMessageZ", (String)("Start: " + result));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object pollStop(@NotNull String pollId, @NotNull Continuation<? super Unit> $completion) {
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, pollId, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $pollId;
            {
                this.this$0 = $receiver;
                this.$pollId = $pollId;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_STOP, new HMSParams.PollStopRequest(this.$pollId, null, 2, null), JsonObject.class, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object pollQuestionsGet(@NotNull HMSParams.PollQuestionsGet pollQuestionsGet2, @NotNull Continuation<? super PollQuestionGetResponse> $completion) {
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super PollQuestionGetResponse>, Object>(this, pollQuestionsGet2, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.PollQuestionsGet $pollQuestionsGet;
            {
                this.this$0 = $receiver;
                this.$pollQuestionsGet = $pollQuestionsGet;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_QUESTIONS_GET, this.$pollQuestionsGet, PollQuestionGetResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PollQuestionGetResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object pollAddResponse(@NotNull HMSPollResponseBuilder hmsPollResponseBuilder, @NotNull Continuation<? super PollAnswerResponse> $completion) {
        HMSPollResponseBuilder $this$pollAddResponse_u24lambda_u241 = hmsPollResponseBuilder;
        boolean bl = false;
        HMSParams.PollResponseSet param = new HMSParams.PollResponseSet($this$pollAddResponse_u24lambda_u241.getHmsPoll().getPollId(), $this$pollAddResponse_u24lambda_u241.getAllAnswers$lib_release(), null, 4, null);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super PollAnswerResponse>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.PollResponseSet $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_RESPONSE, this.$param, PollAnswerResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PollAnswerResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object pollGetResponses(@NotNull HMSParams.PollResponsesQuery var1_1, @NotNull Continuation<? super PollGetResponsesReply> var2_2) {
        if (!(var2_2 instanceof pollGetResponses.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.pollGetResponses(null, (Continuation<? super PollGetResponsesReply>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, (HMSParams.PollResponsesQuery)param, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ HMSParams.PollResponsesQuery $param;
                    {
                        this.this$0 = $receiver;
                        this.$param = $param;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_RESPONSES, this.$param, JsonObject.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, null, null, 0, (Continuation)$continuation, 60, null);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                it = (JsonObject)v0;
                $i$a$-let-JSONRpcSignal$pollGetResponses$4 = false;
                Log.d((String)"PrintingResponses", (String)String.valueOf(it));
                $i$a$-let-JSONRpcSignal$pollGetResponses$5 = false;
                v1 = (PollGetResponsesReply)GsonUtils.INSTANCE.getGson().fromJson((JsonElement)it, PollGetResponsesReply.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"override suspend fun pol\u2026ly::class.java)\n    }\n  }");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object pollGetResults(@NotNull String pollId, @NotNull Continuation<? super PollResultsResponse> $completion) {
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super PollResultsResponse>, Object>(this, pollId, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $pollId;
            {
                this.this$0 = $receiver;
                this.$pollId = $pollId;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_RESULT, new HMSParams.PollResultsQuery(this.$pollId, null, 2, null), PollResultsResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PollResultsResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object pollGetLeaderboard(@NotNull HMSParams.PollLeaderboardQuery var1_1, @NotNull Continuation<? super PollLeaderboardResponse> var2_2) {
        if (!(var2_2 instanceof pollGetLeaderboard.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.pollGetLeaderboard(null, (Continuation<? super PollLeaderboardResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, (HMSParams.PollLeaderboardQuery)param, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ HMSParams.PollLeaderboardQuery $param;
                    {
                        this.this$0 = $receiver;
                        this.$param = $param;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_LEADERBOARD, this.$param, JsonObject.class, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

                    @Nullable
                    public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                        return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
                    }
                }, null, null, null, 0, (Continuation)$continuation, 60, null);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                r = (JsonObject)v0;
                response = (HMSPollLeaderboardResponse)GsonUtils.INSTANCE.getGson().fromJson((JsonElement)r, HMSPollLeaderboardResponse.class);
                return response.mapToPollLeaderboardResponse();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object createWhiteBoard(@NotNull HMSParams.Options options, @NotNull Continuation<? super HMSCreateWhiteBoardResponse> $completion) {
        KFunction kFunction = (KFunction)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        };
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super HMSCreateWhiteBoardResponse>, Object>(this, options, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.Options $options;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.WHITEBOARD_CREATE, this.$options, HMSCreateWhiteBoardResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super HMSCreateWhiteBoardResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)kFunction, null, null, null, 0, $completion, 28, null);
    }

    @Override
    @Nullable
    public Object getWhiteBoard(@NotNull String id, @NotNull Continuation<? super HMSGetWhiteBoardResponse> $completion) {
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super HMSGetWhiteBoardResponse>, Object>(this, id, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.WHITEBOARD_GET, new HMSParams.HMSWhiteBoardGetOption(this.$id), HMSGetWhiteBoardResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super HMSGetWhiteBoardResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object pollGetList(@NotNull HmsPollState state2, int count, @Nullable String start2, @NotNull Continuation<? super PollListResponse> $completion) {
        HMSParams.PollListQuery param = new HMSParams.PollListQuery(count, start2, state2, null, 8, null);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super PollListResponse>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.PollListQuery $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.POLL_LIST, this.$param, PollListResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PollListResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object groupJoin(@NotNull String groupName, @NotNull Continuation<? super GroupJoinLeaveResponse> $completion) {
        HMSParams.GroupJoin param = new HMSParams.GroupJoin(groupName);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super GroupJoinLeaveResponse>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.GroupJoin $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.GROUP_JOIN, this.$param, GroupJoinLeaveResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super GroupJoinLeaveResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object groupLeave(@NotNull String groupName, @NotNull Continuation<? super GroupJoinLeaveResponse> $completion) {
        HMSParams.GroupLeave param = new HMSParams.GroupLeave(groupName, null, 2, null);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super GroupJoinLeaveResponse>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.GroupLeave $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.GROUP_LEAVE, this.$param, GroupJoinLeaveResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super GroupJoinLeaveResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object groupAdd(@NotNull String peerId, @NotNull String groupName, @NotNull Continuation<? super Unit> $completion) {
        HMSParams.GroupAdd param = new HMSParams.GroupAdd(groupName, peerId, null, 4, null);
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.GroupAdd $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.GROUP_ADD, this.$param, JsonObject.class, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object groupRemove(@NotNull String peerId, @NotNull String groupName, @NotNull Continuation<? super Unit> $completion) {
        HMSParams.GroupRemove param = new HMSParams.GroupRemove(groupName, peerId, null, 4, null);
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, param, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.GroupRemove $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.GROUP_REMOVE, this.$param, JsonObject.class, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object findPeer(@Nullable String groupName, @Nullable String roleName, @Nullable ArrayList<String> peerIds, int limit, @NotNull Continuation<? super FindPeerResponse> $completion) {
        HMSParams.FindPeer params = new HMSParams.FindPeer(groupName, roleName, peerIds, limit);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super FindPeerResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.FindPeer $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.FIND_PEER, this.$params, FindPeerResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super FindPeerResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object peerIteratorNext(@NotNull String iteratorId, int limit, @NotNull Continuation<? super FindPeerResponse> $completion) {
        HMSParams.PeerIteratorNext params = new HMSParams.PeerIteratorNext(iteratorId, limit);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super FindPeerResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.PeerIteratorNext $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.PEER_ITER_NEXT, this.$params, FindPeerResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super FindPeerResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    @Override
    @Nullable
    public Object startRealTimeTranscription(@NotNull TranscriptionsMode mode, @NotNull Continuation<? super Unit> $completion) {
        HMSParams.StartTranscription params = new HMSParams.StartTranscription(mode);
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super TranscriptionStartResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.StartTranscription $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.TRANSCRIPTION_START, this.$params, TranscriptionStartResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super TranscriptionStartResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object stopRealTimeTranscription(@NotNull TranscriptionsMode mode, @NotNull Continuation<? super Unit> $completion) {
        HMSParams.StopTranscription params = new HMSParams.StopTranscription(mode);
        Object object = ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super TranscriptionStopResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.StopTranscription $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.TRANSCRIPTION_STOP, this.$params, TranscriptionStopResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super TranscriptionStopResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object peerNameSearch(@NotNull String query, int limit, long offset, @NotNull Continuation<? super PeerNameSearchResponse> $completion) {
        HMSParams.PeerNameSearch params = new HMSParams.PeerNameSearch(query, limit, offset);
        return ExtensionUtilsKt.withRetry$default((Function1)new Function1<Continuation<? super PeerNameSearchResponse>, Object>(this, params, null){
            int label;
            final /* synthetic */ JSONRpcSignal this$0;
            final /* synthetic */ HMSParams.PeerNameSearch $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JSONRpcSignal.access$call(this.this$0, HMSSignalMethod.PEER_NAME_SEARCH, this.$params, PeerNameSearchResponse.class, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PeerNameSearchResponse> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<TransportFailureCategory, Continuation<? super CompletableDeferred<Long>>, Object>((Object)this.getObserver()){

            @Nullable
            public final Object invoke(@NotNull TransportFailureCategory p0, @NotNull Continuation<? super CompletableDeferred<Long>> $completion) {
                return ((ISignalEventsObserver)this.receiver).getDependency(p0, $completion);
            }
        }, null, null, null, 0, $completion, 60, null);
    }

    public static final /* synthetic */ Object access$call(JSONRpcSignal $this, HMSSignalMethod method, HMSParams params, Class c, Continuation $completion) {
        return $this.call(method, params, c, $completion);
    }

    public static final /* synthetic */ Mutex access$getMutex(JSONRpcSignal $this) {
        return $this.getMutex();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Llive/hms/video/signal/jsonrpc/JSONRpcSignal$Callback;", "", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "message", "method", "Llive/hms/video/signal/HMSSignalMethod;", "(Lkotlinx/coroutines/CompletableDeferred;Ljava/lang/String;Llive/hms/video/signal/HMSSignalMethod;)V", "getDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "getMessage", "()Ljava/lang/String;", "getMethod", "()Llive/hms/video/signal/HMSSignalMethod;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
    private static final class Callback {
        @NotNull
        private final CompletableDeferred<String> deferred;
        @NotNull
        private final String message;
        @NotNull
        private final HMSSignalMethod method;

        public Callback(@NotNull CompletableDeferred<String> deferred, @NotNull String message, @NotNull HMSSignalMethod method) {
            Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            this.deferred = deferred;
            this.message = message;
            this.method = method;
        }

        @NotNull
        public final CompletableDeferred<String> getDeferred() {
            return this.deferred;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final HMSSignalMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final CompletableDeferred<String> component1() {
            return this.deferred;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final HMSSignalMethod component3() {
            return this.method;
        }

        @NotNull
        public final Callback copy(@NotNull CompletableDeferred<String> deferred, @NotNull String message, @NotNull HMSSignalMethod method) {
            Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            return new Callback(deferred, message, method);
        }

        public static /* synthetic */ Callback copy$default(Callback callback, CompletableDeferred completableDeferred, String string, HMSSignalMethod hMSSignalMethod, int n, Object object) {
            if ((n & 1) != 0) {
                completableDeferred = callback.deferred;
            }
            if ((n & 2) != 0) {
                string = callback.message;
            }
            if ((n & 4) != 0) {
                hMSSignalMethod = callback.method;
            }
            return callback.copy(completableDeferred, string, hMSSignalMethod);
        }

        @NotNull
        public String toString() {
            return "Callback(deferred=" + this.deferred + ", message=" + this.message + ", method=" + (Object)((Object)this.method) + ')';
        }

        public int hashCode() {
            int result2 = this.deferred.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            result2 = result2 * 31 + this.method.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Callback)) {
                return false;
            }
            Callback callback = (Callback)other;
            if (!Intrinsics.areEqual(this.deferred, callback.deferred)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)callback.message)) {
                return false;
            }
            return this.method == callback.method;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSSignalMethod.values().length];
            try {
                nArray[HMSSignalMethod.TRICKLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSSignalMethod.OFFER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSSignalMethod.SERVER_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/signal/jsonrpc/JSONRpcSignal$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

