/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\t"}, d2={"Llive/hms/video/sdk/SignatureChecker;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isReleaseSigned", "", "()Z", "mContext", "lib_release"})
public final class SignatureChecker {
    private final boolean isReleaseSigned;

    public SignatureChecker(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.isReleaseSigned = this.isReleaseSigned(applicationContext);
    }

    public final boolean isReleaseSigned() {
        return this.isReleaseSigned;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReleaseSigned(Context mContext) {
        X509Certificate cert;
        X509Certificate x509Certificate;
        Signature[] signatureArray;
        PackageManager packageManager = mContext.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"mContext.packageManager");
        PackageManager pm = packageManager;
        String string = mContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mContext.packageName");
        String packageName = string;
        int flags = Build.VERSION.SDK_INT >= 28 ? 0x8000000 : 64;
        PackageInfo packageInfo = null;
        try {
            PackageInfo packageInfo2 = pm.getPackageInfo(packageName, flags);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"pm.getPackageInfo(packageName, flags)");
            packageInfo = packageInfo2;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            Signature[] signatureArray2 = packageInfo.signingInfo.hasMultipleSigners() ? packageInfo.signingInfo.getApkContentsSigners() : packageInfo.signingInfo.getSigningCertificateHistory();
            signatureArray = signatureArray2;
            Intrinsics.checkNotNullExpressionValue((Object)signatureArray2, (String)"{\n            // Followi\u2026tificateHistory\n        }");
        } else {
            signatureArray = packageInfo.signatures;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo.signatures, (String)"{\n            packageInfo.signatures\n        }");
        }
        Signature[] signatures = signatureArray;
        byte[] byArray = signatures[0].toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signatures[0].toByteArray()");
        byte[] certBytes = byArray;
        InputStream input = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
            Certificate certificate = cf.generateCertificate(input);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            x509Certificate = (X509Certificate)certificate;
        }
        catch (CertificateException e) {
            e.printStackTrace();
            x509Certificate = null;
        }
        X509Certificate x509Certificate2 = cert = x509Certificate;
        if (Intrinsics.areEqual((Object)(x509Certificate2 != null ? x509Certificate2.getSigAlgName() : null), (Object)"SHA256withRSA")) return true;
        X509Certificate x509Certificate3 = cert;
        Object object = x509Certificate3;
        if (x509Certificate3 == null) return false;
        Principal principal = ((X509Certificate)object).getIssuerDN();
        object = principal;
        if (principal == null) return false;
        String string2 = object.getName();
        object = string2;
        if (string2 == null) return false;
        if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"CN=Android Debug", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

