/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.tracks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.sdk.HMSAddSinkResultListener;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoSink;
import org.webrtc.VideoTrack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Llive/hms/video/media/tracks/HMSVideoTrack;", "Llive/hms/video/media/tracks/HMSTrack;", "stream", "Llive/hms/video/media/streams/HMSMediaStream;", "nativeTrack", "Lorg/webrtc/VideoTrack;", "source", "", "(Llive/hms/video/media/streams/HMSMediaStream;Lorg/webrtc/VideoTrack;Ljava/lang/String;)V", "TAG", "<set-?>", "", "isAdded", "isAdded$lib_release", "()Z", "isDegraded", "setDegraded$lib_release", "(Z)V", "isDisposed", "isDisposed$lib_release", "setDisposed$lib_release", "type", "Llive/hms/video/media/tracks/HMSTrackType;", "getType", "()Llive/hms/video/media/tracks/HMSTrackType;", "addSink", "", "sink", "Lorg/webrtc/VideoSink;", "resultListener", "Llive/hms/video/sdk/HMSAddSinkResultListener;", "removeSink", "toString", "lib_release"})
public class HMSVideoTrack
extends HMSTrack {
    @NotNull
    private final String TAG;
    @NotNull
    private final HMSTrackType type;
    private boolean isAdded;
    private boolean isDegraded;
    private boolean isDisposed;

    public HMSVideoTrack(@NotNull HMSMediaStream stream, @NotNull VideoTrack nativeTrack, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nativeTrack, (String)"nativeTrack");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(stream, (MediaStreamTrack)nativeTrack, source);
        this.TAG = "HMSVideoTrack";
        this.type = HMSTrackType.VIDEO;
    }

    @Override
    @NotNull
    public HMSTrackType getType() {
        return this.type;
    }

    public final boolean isAdded$lib_release() {
        return this.isAdded;
    }

    public boolean isDegraded() {
        return this.isDegraded;
    }

    public void setDegraded$lib_release(boolean bl) {
        this.isDegraded = bl;
    }

    public final boolean isDisposed$lib_release() {
        return this.isDisposed;
    }

    public final void setDisposed$lib_release(boolean bl) {
        this.isDisposed = bl;
    }

    public void addSink(@NotNull VideoSink sink, @Nullable HMSAddSinkResultListener resultListener) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            if (this.isDisposed) {
                throw new IllegalStateException("native video  track has been disposed");
            }
            MediaStreamTrack mediaStreamTrack = this.getNativeTrack$lib_release();
            Intrinsics.checkNotNull((Object)mediaStreamTrack, (String)"null cannot be cast to non-null type org.webrtc.VideoTrack");
            ((VideoTrack)mediaStreamTrack).addSink(sink);
            this.isAdded = true;
        }
        catch (IllegalStateException exception) {
            HMSLogger.e(this.TAG, " native track has been disposed");
        }
    }

    public static /* synthetic */ void addSink$default(HMSVideoTrack hMSVideoTrack, VideoSink videoSink, HMSAddSinkResultListener hMSAddSinkResultListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSink");
        }
        if ((n & 2) != 0) {
            hMSAddSinkResultListener = null;
        }
        hMSVideoTrack.addSink(videoSink, hMSAddSinkResultListener);
    }

    public void removeSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            if (this.isDisposed) {
                throw new IllegalStateException("native video  track has been disposed");
            }
            MediaStreamTrack mediaStreamTrack = this.getNativeTrack$lib_release();
            Intrinsics.checkNotNull((Object)mediaStreamTrack, (String)"null cannot be cast to non-null type org.webrtc.VideoTrack");
            ((VideoTrack)mediaStreamTrack).removeSink(sink);
            this.isAdded = false;
        }
        catch (IllegalStateException exception) {
            HMSLogger.e(this.TAG, " native track has been disposed");
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "HMSVideoTrack{trackId=" + this.getTrackId() + ", isEnabled=" + this.isEnabled$lib_release() + ", isDegraded:" + this.isDegraded() + '}';
    }
}

