/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import androidx.core.content.PermissionChecker;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.error.ErrorFactory;
import live.hms.video.utils.CheckedPermissions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Llive/hms/video/utils/HMSPermissionsChecker;", "", "()V", "checkedPermissions", "", "Llive/hms/video/utils/CheckedPermissions;", "checkPermissionAndThrowError", "", "context", "Landroid/content/Context;", "permission", "", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSPermissionsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSPermissionsChecker.kt\nlive/hms/video/utils/HMSPermissionsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class HMSPermissionsChecker {
    @NotNull
    private final List<CheckedPermissions> checkedPermissions;

    public HMSPermissionsChecker() {
        Object[] objectArray = new CheckedPermissions[]{new CheckedPermissions("android.permission.RECORD_AUDIO", ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "microphone", "RECORD_AUDIO permission not received.", false, null, null, 48, null)), new CheckedPermissions("android.permission.CAMERA", ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", "CAMERA permission not received.", false, null, null, 48, null))};
        this.checkedPermissions = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void checkPermissionAndThrowError(@NotNull Context context, @NotNull String permission2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permission2, (String)"permission");
            Iterable iterable = this.checkedPermissions;
            for (Object t : iterable) {
                CheckedPermissions it = (CheckedPermissions)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPermission(), (Object)permission2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        CheckedPermissions check = v0;
        if (PermissionChecker.checkSelfPermission((Context)context, (String)check.getPermission()) != 0) {
            throw check.getErrorToThrow();
        }
    }
}

