/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.Image;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.capturers.camera.utils.YuvByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Llive/hms/video/media/capturers/camera/utils/YuvToRgbConverter;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bytes", "", "inputAllocation", "Landroid/renderscript/Allocation;", "outputAllocation", "rs", "Landroid/renderscript/RenderScript;", "kotlin.jvm.PlatformType", "scriptYuvToRgb", "Landroid/renderscript/ScriptIntrinsicYuvToRGB;", "yuvBits", "Ljava/nio/ByteBuffer;", "needCreateAllocations", "", "image", "Landroid/media/Image;", "yuvBuffer", "Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer;", "yuvToRgb", "", "output", "Landroid/graphics/Bitmap;", "lib_release"})
public final class YuvToRgbConverter {
    private final RenderScript rs;
    private final ScriptIntrinsicYuvToRGB scriptYuvToRgb;
    @Nullable
    private ByteBuffer yuvBits;
    @NotNull
    private byte[] bytes;
    @Nullable
    private Allocation inputAllocation;
    @Nullable
    private Allocation outputAllocation;

    public YuvToRgbConverter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.rs = RenderScript.create((Context)context);
        this.scriptYuvToRgb = ScriptIntrinsicYuvToRGB.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        this.bytes = new byte[0];
    }

    public final synchronized void yuvToRgb(@NotNull Image image, @NotNull Bitmap output) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        YuvByteBuffer yuvBuffer = new YuvByteBuffer(image, this.yuvBits);
        this.yuvBits = yuvBuffer.getBuffer();
        if (this.needCreateAllocations(image, yuvBuffer)) {
            Type.Builder yuvType = new Type.Builder(this.rs, Element.U8((RenderScript)this.rs)).setX(image.getWidth()).setY(image.getHeight()).setYuvFormat(yuvBuffer.getType());
            this.inputAllocation = Allocation.createTyped((RenderScript)this.rs, (Type)yuvType.create(), (int)1);
            this.bytes = new byte[yuvBuffer.getBuffer().capacity()];
            Type.Builder rgbaType = new Type.Builder(this.rs, Element.RGBA_8888((RenderScript)this.rs)).setX(image.getWidth()).setY(image.getHeight());
            this.outputAllocation = Allocation.createTyped((RenderScript)this.rs, (Type)rgbaType.create(), (int)1);
        }
        yuvBuffer.getBuffer().get(this.bytes);
        Allocation allocation = this.inputAllocation;
        Intrinsics.checkNotNull((Object)allocation);
        allocation.copyFrom(this.bytes);
        Allocation allocation2 = this.inputAllocation;
        Intrinsics.checkNotNull((Object)allocation2);
        allocation2.copyFrom(this.bytes);
        this.scriptYuvToRgb.setInput(this.inputAllocation);
        this.scriptYuvToRgb.forEach(this.outputAllocation);
        Allocation allocation3 = this.outputAllocation;
        Intrinsics.checkNotNull((Object)allocation3);
        allocation3.copyTo(output);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needCreateAllocations(Image image, YuvByteBuffer yuvBuffer) {
        if (this.inputAllocation == null) return true;
        Allocation allocation = this.inputAllocation;
        Intrinsics.checkNotNull((Object)allocation);
        if (allocation.getType().getX() != image.getWidth()) return true;
        Allocation allocation2 = this.inputAllocation;
        Intrinsics.checkNotNull((Object)allocation2);
        if (allocation2.getType().getY() != image.getHeight()) return true;
        Allocation allocation3 = this.inputAllocation;
        Intrinsics.checkNotNull((Object)allocation3);
        if (allocation3.getType().getYuv() != yuvBuffer.getType()) return true;
        if (this.bytes.length != yuvBuffer.getBuffer().capacity()) return false;
        return true;
    }
}

