/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.audio.BluetoothErrorType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/hms/video/audio/BluetoothPermissionHandler;", "", "()V", "BLUETOOTH_CONNECT_PERMISSION", "", "getBLUETOOTH_CONNECT_PERMISSION", "()Ljava/lang/String;", "hasAndroid12Permissions", "", "context", "Landroid/content/Context;", "hasBluetoothError", "Llive/hms/video/audio/BluetoothErrorType;", "hasPermission", "permission", "isDeviceAndroid12AndAbove", "isTargetingAndroid12AndAbove", "lib_release"})
public final class BluetoothPermissionHandler {
    @NotNull
    private final String BLUETOOTH_CONNECT_PERMISSION;

    public BluetoothPermissionHandler() {
        this.BLUETOOTH_CONNECT_PERMISSION = "android.permission.BLUETOOTH_CONNECT";
    }

    @NotNull
    public final String getBLUETOOTH_CONNECT_PERMISSION() {
        return this.BLUETOOTH_CONNECT_PERMISSION;
    }

    private final boolean hasPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @Nullable
    public final BluetoothErrorType hasBluetoothError(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean noBluetoothPermission = !this.hasPermission(context, "android.permission.BLUETOOTH") && (!this.isDeviceAndroid12AndAbove() || !this.isTargetingAndroid12AndAbove(context));
        boolean noBluetoothConnectPermissionOn12 = this.isDeviceAndroid12AndAbove() && this.isTargetingAndroid12AndAbove(context) && !this.hasAndroid12Permissions(context);
        BluetoothErrorType error = null;
        if (noBluetoothPermission) {
            error = BluetoothErrorType.NO_BLUETOOTH_PERMISSON;
        } else if (noBluetoothConnectPermissionOn12) {
            error = BluetoothErrorType.NO_BLUETOOTH_CONNECT_PERMISSION;
        }
        return error;
    }

    private final boolean isDeviceAndroid12AndAbove() {
        return Build.VERSION.SDK_INT > 30;
    }

    private final boolean isTargetingAndroid12AndAbove(Context context) {
        return context.getApplicationInfo().targetSdkVersion > 30;
    }

    @RequiresApi(api=23)
    private final boolean hasAndroid12Permissions(Context context) {
        return context.checkSelfPermission(this.BLUETOOTH_CONNECT_PERMISSION) == 0;
    }
}

