/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.media.audiofx.AudioEffect;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Llive/hms/video/utils/AudioEchoCancellationUtils;", "", "()V", "Companion", "lib_release"})
public final class AudioEchoCancellationUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    @Nullable
    private static AudioEffect.Descriptor[] cachedEffects;

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0012"}, d2={"Llive/hms/video/utils/AudioEchoCancellationUtils$Companion;", "", "()V", "AOSP_ACOUSTIC_ECHO_CANCELER", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "getAOSP_ACOUSTIC_ECHO_CANCELER", "()Ljava/util/UUID;", "cachedEffects", "", "Landroid/media/audiofx/AudioEffect$Descriptor;", "[Landroid/media/audiofx/AudioEffect$Descriptor;", "getAvailableEffects", "()[Landroid/media/audiofx/AudioEffect$Descriptor;", "isEffectTypeAvailable", "", "effectType", "blockListedUuid", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public final UUID getAOSP_ACOUSTIC_ECHO_CANCELER() {
            return AOSP_ACOUSTIC_ECHO_CANCELER;
        }

        private final AudioEffect.Descriptor[] getAvailableEffects() {
            if (cachedEffects != null) {
                return cachedEffects;
            }
            cachedEffects = AudioEffect.queryEffects();
            return cachedEffects;
        }

        public final boolean isEffectTypeAvailable(@NotNull UUID effectType, @NotNull UUID blockListedUuid) {
            AudioEffect.Descriptor[] effects;
            Intrinsics.checkNotNullParameter((Object)effectType, (String)"effectType");
            Intrinsics.checkNotNullParameter((Object)blockListedUuid, (String)"blockListedUuid");
            AudioEffect.Descriptor[] descriptorArray = this.getAvailableEffects();
            if (descriptorArray == null) {
                return false;
            }
            for (AudioEffect.Descriptor d : effects = descriptorArray) {
                if (!Intrinsics.areEqual((Object)d.type, (Object)effectType)) continue;
                return !Intrinsics.areEqual((Object)d.uuid, (Object)blockListedUuid);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

