/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.protocol.http.control;

import java.io.IOException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.protocol.http.control.KeyWaiter;
import org.jmeterplugins.protocol.http.control.NanoHTTPD;

public class ServerRunner {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static void run(Class serverClass) {
        try {
            ServerRunner.executeInstance((NanoHTTPD)serverClass.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void executeInstance(NanoHTTPD server) {
        if (null != server) {
            try {
                server.start();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't start server:" + ioe);
                return;
            }
            log.info("Server started");
            if (server instanceof KeyWaiter) {
                ((KeyWaiter)((Object)server)).waitForKey();
            }
            if (server.isAlive()) {
                server.stop();
            }
        }
        log.info("Server stopped.");
    }
}

