/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import kg.apc.io.DatagramChannelWithTimeouts;
import kg.apc.jmeter.samplers.AbstractIPSampler;
import kg.apc.jmeter.samplers.UDPTrafficDecoder;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UDPSampler
extends AbstractIPSampler
implements UDPTrafficDecoder,
ThreadListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String ENCODECLASS = "encodeclass";
    public static final String WAITRESPONSE = "waitresponse";
    public static final String CLOSECHANNEL = "closechannel";
    private DatagramChannel channel;
    private UDPTrafficDecoder encoder;

    public boolean isWaitResponse() {
        return this.getPropertyAsBoolean(WAITRESPONSE);
    }

    public boolean isCloseChannel() {
        return this.getPropertyAsBoolean(CLOSECHANNEL);
    }

    public String getEncoderClass() {
        return this.getPropertyAsString(ENCODECLASS);
    }

    public void setWaitResponse(boolean selected) {
        this.setProperty(WAITRESPONSE, selected);
    }

    public void setCloseChannel(boolean selected) {
        this.setProperty(CLOSECHANNEL, selected);
    }

    public void setEncoderClass(String text) {
        this.setProperty(ENCODECLASS, text);
    }

    @Override
    protected AbstractSelectableChannel getChannel() throws IOException {
        DatagramChannel c;
        if (this.isWaitResponse()) {
            c = DatagramChannelWithTimeouts.open();
            ((DatagramChannelWithTimeouts)c).setReadTimeout(this.getTimeoutAsInt());
        } else {
            c = DatagramChannel.open();
        }
        int port = Integer.parseInt(this.getPort());
        c.connect(new InetSocketAddress(this.getHostName(), port));
        return c;
    }

    @Override
    public ByteBuffer encode(String data) {
        try {
            return ByteBuffer.wrap(data.getBytes("Windows-1252"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] decode(byte[] buf) {
        return buf;
    }

    @Override
    protected byte[] processIO(SampleResult res) throws Exception {
        if (this.channel == null || !this.channel.isOpen()) {
            try {
                this.channel = (DatagramChannel)this.getChannel();
            }
            catch (IOException ex) {
                log.error("Cannot open channel", (Throwable)ex);
            }
        }
        ByteBuffer sendBuf = this.encoder.encode(this.getRequestData());
        while (sendBuf.remaining() > 0) {
            this.channel.write(sendBuf);
        }
        if (!this.isWaitResponse()) {
            res.latencyEnd();
            res.sampleEnd();
            if (this.isCloseChannel()) {
                this.channel.close();
            }
            return new byte[0];
        }
        try {
            ByteArrayOutputStream response = this.readResponse(res);
            if (this.isCloseChannel()) {
                this.channel.close();
            }
            return this.encoder.decode(response.toByteArray());
        }
        catch (IOException ex) {
            this.channel.close();
            throw ex;
        }
    }

    private ByteArrayOutputStream readResponse(SampleResult res) throws IOException {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        int cnt = 0;
        ByteBuffer recvBuf = this.getRecvBuf();
        recvBuf.clear();
        cnt = this.channel.read(recvBuf);
        if (cnt != -1) {
            res.latencyEnd();
            recvBuf.flip();
            byte[] bytes = new byte[cnt];
            recvBuf.get(bytes);
            response.write(bytes);
            recvBuf.clear();
        }
        res.sampleEnd();
        res.setBytes(response.size());
        return response;
    }

    public void threadStarted() {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(this.getEncoderClass());
            Object o = c.newInstance();
            if (!(o instanceof UDPTrafficDecoder)) {
                throw new ClassNotFoundException("Class does not implement " + UDPTrafficDecoder.class.getCanonicalName());
            }
            this.encoder = (UDPTrafficDecoder)o;
            log.debug("Using decoder: " + this.encoder);
        }
        catch (Exception ex) {
            if (!this.getEncoderClass().isEmpty()) {
                log.warn("Problem loading encoder " + this.getEncoderClass() + ", raw data will be used", (Throwable)ex);
            }
            this.encoder = this;
        }
    }

    public void threadFinished() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException ex) {
            log.error("Cannot close channel", (Throwable)ex);
        }
    }

    public boolean interrupt() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                log.warn("Exception while interrupting channel: ", (Throwable)ex);
                return false;
            }
        }
        return true;
    }
}

