/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import kg.apc.jmeter.EndOfFileException;
import kg.apc.jmeter.RuntimeEOFException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class RawRequestSourcePreProcessor
extends AbstractTestElement
implements PreProcessor,
NoThreadClone,
TestStateListener {
    public static final String regexp = "\\s";
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String VARIABLE_NAME = "variable_name";
    public static final String FILENAME = "filename";
    public static final String REWIND = "rewind";
    public static final String ENCODE_HEX = "isHex";
    private FileChannel file;
    private ByteBuffer metaBuf = null;
    private ByteBuffer oneByte = null;
    public static final Charset binaryCharset = Charset.forName("UTF8");

    public synchronized void process() {
        String rawData;
        if (this.file == null) {
            log.info("Creating file object: " + this.getFileName());
            try {
                this.file = new FileInputStream(this.getFileName()).getChannel();
            }
            catch (FileNotFoundException ex) {
                log.error(this.getFileName(), (Throwable)ex);
                return;
            }
        }
        try {
            rawData = this.readNextChunk(this.getNextChunkSize());
        }
        catch (EndOfFileException ex) {
            if (this.getRewindOnEOF()) {
                if (log.isDebugEnabled()) {
                    log.debug("Rewind file");
                }
                try {
                    this.file.position(0L);
                }
                catch (IOException ex1) {
                    log.error("Cannot rewind", (Throwable)ex1);
                }
                this.process();
                return;
            }
            log.info("End of file reached: " + this.getFileName());
            if (JMeterContextService.getContext().getThread() != null) {
                JMeterContextService.getContext().getThread().stop();
            }
            throw new RuntimeEOFException("End of file reached", ex);
        }
        catch (IOException ex) {
            log.error("Error reading next chunk", (Throwable)ex);
            throw new RuntimeException("Error reading next chunk", ex);
        }
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        if (vars != null) {
            vars.put(this.getVarName(), rawData);
        }
    }

    private synchronized String readNextChunk(int capacity) throws IOException {
        if (capacity == 0) {
            throw new EndOfFileException("Zero chunk size, possibly end of file reached.");
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity);
        byte[] dst = new byte[capacity];
        int cnt = this.file.read(buf);
        if (cnt != capacity) {
            throw new IOException("Expected chunk size (" + capacity + ") differs from read bytes count (" + cnt + ")");
        }
        buf.flip();
        buf.get(dst);
        if (log.isDebugEnabled()) {
            log.debug("Chunk : " + new String(dst));
        }
        if (this.isHexEncode()) {
            return JOrphanUtils.baToHexString((byte[])dst);
        }
        return new String(dst, binaryCharset);
    }

    private int getNextChunkSize() throws IOException {
        this.metaBuf.clear();
        while (true) {
            byte b;
            if ((b = this.getOneByte()) == 10 || b == 13) {
                byte b2 = this.getOneByte();
                if (b2 != 10) {
                    this.file.position(this.file.position() - 1L);
                }
                if (this.metaBuf.position() <= 0) continue;
                break;
            }
            this.metaBuf.put(b);
        }
        byte[] bLine = new byte[this.metaBuf.position()];
        this.metaBuf.rewind();
        this.metaBuf.get(bLine);
        String sLine = new String(bLine).trim();
        String[] ar = sLine.split(regexp);
        if (log.isDebugEnabled()) {
            log.debug("Chunk size: " + ar[0]);
        }
        int res = 0;
        try {
            res = Integer.parseInt(ar[0]);
        }
        catch (NumberFormatException ex) {
            log.error("Error reading chunk size near: " + sLine, (Throwable)ex);
            throw new IOExceptionWithCause((Throwable)ex);
        }
        return res;
    }

    private byte getOneByte() throws IOException {
        this.oneByte.rewind();
        if (this.file.read(this.oneByte) < 1) {
            throw new EndOfFileException(this.getFileName());
        }
        return this.oneByte.get(0);
    }

    public String getVarName() {
        return this.getPropertyAsString(VARIABLE_NAME);
    }

    public void setVarName(String name) {
        this.setProperty(VARIABLE_NAME, name);
    }

    public String getFileName() {
        return this.getPropertyAsString(FILENAME);
    }

    public void setFileName(String filename) {
        this.setProperty(FILENAME, filename);
        this.file = null;
    }

    public void setRewindOnEOF(boolean isRew) {
        this.setProperty((JMeterProperty)new BooleanProperty(REWIND, isRew));
    }

    public boolean getRewindOnEOF() {
        return this.getPropertyAsBoolean(REWIND);
    }

    public boolean isHexEncode() {
        return this.getPropertyAsBoolean(ENCODE_HEX);
    }

    public void setEncodeHex(boolean b) {
        this.setProperty(ENCODE_HEX, b);
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
        this.metaBuf = ByteBuffer.allocateDirect(1024);
        this.oneByte = ByteBuffer.allocateDirect(1);
    }

    public void testEnded() {
    }

    public void testEnded(String host) {
    }
}

