/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.io.File;
import java.io.IOException;
import kg.apc.io.FileSystem;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopTestNowException;
import org.apache.log.Logger;

public class LockFile
extends ConfigTestElement
implements TestStateListener {
    public static Logger log = LoggingManager.getLoggerForClass();
    public static final String FILENAME = "filename";
    public static final String FILEMASK = "filemask";

    public void testStarted() {
        this.testStarted(null);
    }

    public void testStarted(String string) {
        log.debug("Test started captured");
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            String path;
            log.info("Checking lockfile at " + this.getFilename());
            File file = new File(this.getFilename());
            try {
                path = file.getParentFile() != null ? file.getParentFile().getCanonicalPath() : new File(".").getCanonicalPath();
            }
            catch (IOException ex) {
                log.error("Failed to get path");
                throw new JMeterStopTestNowException("Failed to get path");
            }
            log.info("and by wildcard at " + path + this.getFilemask());
            if (file.exists()) {
                log.error("Lock file found: " + this.getFilename());
                throw new JMeterStopTestNowException("Lock file found: " + this.getFilename());
            }
            if (this.getFilemask() != null && this.getFilemask().length() > 0 && FileSystem.checkFileExistByPattern(path, this.getFilemask())) {
                log.error("Lock file found by pattern " + this.getFilemask());
                throw new JMeterStopTestNowException("Lock file found by pattern " + this.getFilemask());
            }
            try {
                log.info("Create lockfile at " + this.getFilename());
                file.createNewFile();
            }
            catch (IOException e) {
                log.error("Could not create lock file: " + e.getLocalizedMessage());
                throw new JMeterStopTestNowException("Could not create lock file: " + e.getLocalizedMessage());
            }
        }
        log.debug("Filename: " + this.getFilename());
        log.warn("No lockfile set. Ignore.");
    }

    public void testEnded() {
        this.testEnded(null);
    }

    public void testEnded(String string) {
        File file;
        log.debug("Test ended captured");
        if (this.getFilename() != null && this.getFilename().length() > 0 && (file = new File(this.getFilename())).exists()) {
            log.info("Remove lockfile from " + this.getFilename());
            file.delete();
        }
    }

    public String getFilename() {
        log.debug("Return filename: " + this.getPropertyAsString(FILENAME));
        return this.getPropertyAsString(FILENAME);
    }

    public void setFilename(String filename) {
        log.debug("Set filename to: " + filename);
        this.setProperty(FILENAME, filename);
    }

    public String getFilemask() {
        log.debug("Return filemask: " + this.getPropertyAsString(FILEMASK));
        return this.getPropertyAsString(FILEMASK);
    }

    public void setFilemask(String filemask) {
        log.debug("Set filemask to: " + filemask);
        this.setProperty(FILEMASK, filemask);
    }
}

