/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.io;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DatagramChannelWithTimeouts
extends DatagramChannel {
    protected DatagramChannel channel;
    protected Selector selector;
    private long readTimeout = 10000L;
    protected SelectionKey channelKey;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean fastFirstPacketRead;

    protected DatagramChannelWithTimeouts() throws IOException {
        super(null);
        log.debug("Creating DatagramChannel");
        this.selector = Selector.open();
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.channelKey = this.channel.register(this.selector, 1);
    }

    public static DatagramChannel open() throws IOException {
        return new DatagramChannelWithTimeouts();
    }

    @Override
    public DatagramChannel bind(SocketAddress socketAddress) throws IOException {
        return this.channel.bind(socketAddress);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    @Override
    public <T> DatagramChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        return this.channel.setOption((SocketOption)socketOption, (Object)t);
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.channel.getOption(socketOption);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.channel.supportedOptions();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesRead = 0;
        while (this.selector.select(this.readTimeout) > 0) {
            int cnt;
            if (log.isDebugEnabled()) {
                log.debug("Loop " + bytesRead);
            }
            if (this.selector.selectedKeys() != null) {
                this.selector.selectedKeys().remove(this.channelKey);
            }
            if ((cnt = this.channel.read(dst)) < 1) {
                if (bytesRead < 1) {
                    bytesRead = -1;
                }
                return bytesRead;
            }
            bytesRead += cnt;
            if (this.fastFirstPacketRead) continue;
            this.fastFirstPacketRead = true;
            return bytesRead;
        }
        if (bytesRead < 1) {
            throw new SocketTimeoutException("Timeout exceeded while reading from socket");
        }
        return bytesRead;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        this.fastFirstPacketRead = false;
        int size = src.remaining();
        for (res = 0; res < size; res += this.channel.write(src)) {
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.channel.close();
        this.selector.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        throw new UnsupportedOperationException("This class is blocking implementation of SocketChannel");
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void setReadTimeout(int t) {
        this.readTimeout = t;
    }

    @Override
    public DatagramSocket socket() {
        return this.channel.socket();
    }

    @Override
    public DatagramChannel disconnect() throws IOException {
        return this.channel.disconnect();
    }

    @Override
    public SocketAddress receive(ByteBuffer dst) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DatagramChannel connect(SocketAddress remote) throws IOException {
        return this.channel.connect(remote);
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return null;
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        return this.channel.join(inetAddress, networkInterface);
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress1) throws IOException {
        return this.channel.join(inetAddress, networkInterface, inetAddress1);
    }
}

