/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.protocol.http.control;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public abstract class NanoHTTPD {
    public static final int SOCKET_READ_TIMEOUT = 5000;
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    private static final String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";
    private final String hostname;
    private final int myPort;
    protected ServerSocket myServerSocket;
    private Set<Socket> openConnections = new HashSet<Socket>();
    protected Thread myThread;
    private AsyncRunner asyncRunner;
    private TempFileManagerFactory tempFileManagerFactory;

    public NanoHTTPD(int port) {
        this(null, port);
    }

    public NanoHTTPD(String hostname, int port) {
        this.hostname = hostname;
        this.myPort = port;
        this.setTempFileManagerFactory(new DefaultTempFileManagerFactory());
        this.setAsyncRunner(new DefaultAsyncRunner());
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(Socket closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(ServerSocket closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void start() throws IOException {
        this.myServerSocket = new ServerSocket();
        this.myServerSocket.bind(this.hostname != null ? new InetSocketAddress(this.hostname, this.myPort) : new InetSocketAddress(this.myPort));
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    try {
                        final Socket finalAccept = NanoHTTPD.this.myServerSocket.accept();
                        NanoHTTPD.this.registerConnection(finalAccept);
                        finalAccept.setSoTimeout(5000);
                        final InputStream inputStream = finalAccept.getInputStream();
                        NanoHTTPD.this.asyncRunner.exec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                OutputStream outputStream = null;
                                try {
                                    outputStream = finalAccept.getOutputStream();
                                    TempFileManager tempFileManager = NanoHTTPD.this.tempFileManagerFactory.create();
                                    HTTPSession session = new HTTPSession(tempFileManager, inputStream, outputStream, finalAccept.getInetAddress());
                                    while (!finalAccept.isClosed()) {
                                        session.execute();
                                    }
                                }
                                catch (Exception e) {
                                    if (!(e instanceof SocketException) || !"NanoHttpd Shutdown".equals(e.getMessage())) {
                                        e.printStackTrace();
                                    }
                                }
                                finally {
                                    NanoHTTPD.safeClose(outputStream);
                                    NanoHTTPD.safeClose(inputStream);
                                    NanoHTTPD.safeClose(finalAccept);
                                    NanoHTTPD.this.unRegisterConnection(finalAccept);
                                }
                            }
                        });
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                } while (!NanoHTTPD.this.myServerSocket.isClosed());
            }
        });
        this.myThread.setDaemon(true);
        this.myThread.setName("NanoHttpd Main Listener");
        this.myThread.start();
    }

    public void stop() {
        try {
            NanoHTTPD.safeClose(this.myServerSocket);
            this.closeAllConnections();
            this.myThread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void registerConnection(Socket socket) {
        this.openConnections.add(socket);
    }

    public synchronized void unRegisterConnection(Socket socket) {
        this.openConnections.remove(socket);
    }

    public synchronized void closeAllConnections() {
        for (Socket socket : this.openConnections) {
            NanoHTTPD.safeClose(socket);
        }
    }

    public final int getListeningPort() {
        return this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
    }

    public final boolean wasStarted() {
        return this.myServerSocket != null && this.myThread != null;
    }

    public final boolean isAlive() {
        return this.wasStarted() && !this.myServerSocket.isClosed() && this.myThread.isAlive();
    }

    @Deprecated
    public Response serve(String uri, Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        return new Response(Response.Status.NOT_FOUND, MIME_PLAINTEXT, "Not Found");
    }

    public Response serve(IHTTPSession session) {
        HashMap<String, String> files = new HashMap<String, String>();
        Method method = session.getMethod();
        if (Method.PUT.equals((Object)method) || Method.POST.equals((Object)method)) {
            try {
                session.parseBody(files);
            }
            catch (IOException ioe) {
                return new Response(Response.Status.INTERNAL_ERROR, MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
            catch (ResponseException re) {
                return new Response(re.getStatus(), MIME_PLAINTEXT, re.getMessage());
            }
        }
        Map<String, String> parms = session.getParms();
        parms.put(QUERY_STRING_PARAMETER, session.getQueryParameterString());
        return this.serve(session.getUri(), method, session.getHeaders(), parms, files);
    }

    protected String decodePercent(String str) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(str, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    protected Map<String, List<String>> decodeParameters(Map<String, String> parms) {
        return this.decodeParameters(parms.get(QUERY_STRING_PARAMETER));
    }

    protected Map<String, List<String>> decodeParameters(String queryString) {
        HashMap<String, List<String>> parms = new HashMap<String, List<String>>();
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String propertyValue;
                String propertyName;
                String e = st.nextToken();
                int sep = e.indexOf(61);
                String string = propertyName = sep >= 0 ? this.decodePercent(e.substring(0, sep)).trim() : this.decodePercent(e).trim();
                if (!parms.containsKey(propertyName)) {
                    parms.put(propertyName, new ArrayList());
                }
                if ((propertyValue = sep >= 0 ? this.decodePercent(e.substring(sep + 1)) : null) == null) continue;
                ((List)parms.get(propertyName)).add(propertyValue);
            }
        }
        return parms;
    }

    public void setAsyncRunner(AsyncRunner asyncRunner) {
        this.asyncRunner = asyncRunner;
    }

    public void setTempFileManagerFactory(TempFileManagerFactory tempFileManagerFactory) {
        this.tempFileManagerFactory = tempFileManagerFactory;
    }

    public class CookieHandler
    implements Iterable<String> {
        private HashMap<String, String> cookies = new HashMap();
        private ArrayList<Cookie> queue = new ArrayList();

        public CookieHandler(Map<String, String> httpHeaders) {
            String raw = httpHeaders.get("cookie");
            if (raw != null) {
                String[] tokens;
                for (String token : tokens = raw.split(";")) {
                    String[] data = token.trim().split("=");
                    if (data.length != 2) continue;
                    this.cookies.put(data[0], data[1]);
                }
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.cookies.keySet().iterator();
        }

        public String read(String name) {
            return this.cookies.get(name);
        }

        public void set(String name, String value, int expires) {
            this.queue.add(new Cookie(name, value, Cookie.getHTTPTime(expires)));
        }

        public void set(Cookie cookie) {
            this.queue.add(cookie);
        }

        public void delete(String name) {
            this.set(name, "-delete-", -30);
        }

        public void unloadQueue(Response response) {
            for (Cookie cookie : this.queue) {
                response.addHeader("Set-Cookie", cookie.getHTTPHeader());
            }
        }
    }

    public static class Cookie {
        private String n;
        private String v;
        private String e;

        public Cookie(String name, String value, String expires) {
            this.n = name;
            this.v = value;
            this.e = expires;
        }

        public Cookie(String name, String value) {
            this(name, value, 30);
        }

        public Cookie(String name, String value, int numDays) {
            this.n = name;
            this.v = value;
            this.e = Cookie.getHTTPTime(numDays);
        }

        public String getHTTPHeader() {
            String fmt = "%s=%s; expires=%s";
            return String.format(fmt, this.n, this.v, this.e);
        }

        public static String getHTTPTime(int days) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.add(5, days);
            return dateFormat.format(calendar.getTime());
        }
    }

    protected class HTTPSession
    implements IHTTPSession {
        public static final int BUFSIZE = 8192;
        private final TempFileManager tempFileManager;
        private final OutputStream outputStream;
        private PushbackInputStream inputStream;
        private int splitbyte;
        private int rlen;
        private String uri;
        private Method method;
        private Map<String, String> parms;
        private Map<String, String> headers;
        private CookieHandler cookies;
        private String queryParameterString;

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new PushbackInputStream(inputStream, 8192);
            this.outputStream = outputStream;
        }

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new PushbackInputStream(inputStream, 8192);
            this.outputStream = outputStream;
            String remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
            this.headers = new HashMap<String, String>();
            this.headers.put("remote-addr", remoteIp);
            this.headers.put("http-client-ip", remoteIp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws IOException {
            try {
                byte[] buf = new byte[8192];
                this.splitbyte = 0;
                this.rlen = 0;
                int read = -1;
                try {
                    read = this.inputStream.read(buf, 0, 8192);
                }
                catch (Exception e) {
                    NanoHTTPD.safeClose(this.inputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                if (read == -1) {
                    NanoHTTPD.safeClose(this.inputStream);
                    NanoHTTPD.safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                while (read > 0) {
                    this.rlen += read;
                    this.splitbyte = this.findHeaderEnd(buf, this.rlen);
                    if (this.splitbyte > 0) break;
                    read = this.inputStream.read(buf, this.rlen, 8192 - this.rlen);
                }
                if (this.splitbyte < this.rlen) {
                    this.inputStream.unread(buf, this.splitbyte, this.rlen - this.splitbyte);
                }
                this.parms = new HashMap<String, String>();
                if (null == this.headers) {
                    this.headers = new HashMap<String, String>();
                }
                BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, this.rlen)));
                HashMap<String, String> pre = new HashMap<String, String>();
                this.decodeHeader(hin, pre, this.parms, this.headers);
                this.method = Method.lookup((String)pre.get("method"));
                if (this.method == null) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error.");
                }
                this.uri = (String)pre.get("uri");
                this.cookies = new CookieHandler(this.headers);
                Response r = NanoHTTPD.this.serve(this);
                if (r == null) {
                    throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                }
                this.cookies.unloadQueue(r);
                r.setRequestMethod(this.method);
                r.send(this.outputStream);
            }
            catch (SocketException e) {
                throw e;
            }
            catch (SocketTimeoutException ste) {
                throw ste;
            }
            catch (IOException ioe) {
                Response r = new Response(Response.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                r.send(this.outputStream);
                NanoHTTPD.safeClose(this.outputStream);
            }
            catch (ResponseException re) {
                Response r = new Response(re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
                r.send(this.outputStream);
                NanoHTTPD.safeClose(this.outputStream);
            }
            finally {
                this.tempFileManager.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parseBody(Map<String, String> files) throws IOException, ResponseException {
            RandomAccessFile randomAccessFile = null;
            BufferedReader in = null;
            try {
                randomAccessFile = this.getTmpBucket();
                byte[] buf = new byte[512];
                for (long size = this.headers.containsKey("content-length") ? (long)Integer.parseInt(this.headers.get("content-length")) : (this.splitbyte < this.rlen ? (long)(this.rlen - this.splitbyte) : 0L); this.rlen >= 0 && size > 0L; size -= (long)this.rlen) {
                    this.rlen = this.inputStream.read(buf, 0, (int)Math.min(size, 512L));
                    if (this.rlen <= 0) continue;
                    randomAccessFile.write(buf, 0, this.rlen);
                }
                MappedByteBuffer fbuf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
                randomAccessFile.seek(0L);
                FileInputStream bin = new FileInputStream(randomAccessFile.getFD());
                in = new BufferedReader(new InputStreamReader(bin));
                if (Method.POST.equals((Object)this.method)) {
                    String contentType = "";
                    String contentTypeHeader = this.headers.get("content-type");
                    StringTokenizer st = null;
                    if (contentTypeHeader != null && (st = new StringTokenizer(contentTypeHeader, ",; ")).hasMoreTokens()) {
                        contentType = st.nextToken();
                    }
                    if ("multipart/form-data".equalsIgnoreCase(contentType)) {
                        if (!st.hasMoreTokens()) {
                            throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                        }
                        String boundaryStartString = "boundary=";
                        int boundaryContentStart = contentTypeHeader.indexOf(boundaryStartString) + boundaryStartString.length();
                        String boundary = contentTypeHeader.substring(boundaryContentStart, contentTypeHeader.length());
                        if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
                            boundary = boundary.substring(1, boundary.length() - 1);
                        }
                        this.decodeMultipartData(boundary, fbuf, in, this.parms, files);
                    } else {
                        String postLine = "";
                        StringBuilder postLineBuffer = new StringBuilder();
                        char[] pbuf = new char[512];
                        int read = in.read(pbuf);
                        while (read >= 0 && !postLine.endsWith("\r\n")) {
                            postLine = String.valueOf(pbuf, 0, read);
                            postLineBuffer.append(postLine);
                            read = in.read(pbuf);
                        }
                        postLine = postLineBuffer.toString().trim();
                        this.decodeParms(postLine, this.parms);
                    }
                } else if (Method.PUT.equals((Object)this.method)) {
                    files.put("content", this.saveTmpFile(fbuf, 0, fbuf.limit()));
                }
            }
            catch (Throwable throwable) {
                NanoHTTPD.safeClose(randomAccessFile);
                NanoHTTPD.safeClose(in);
                throw throwable;
            }
            NanoHTTPD.safeClose(randomAccessFile);
            NanoHTTPD.safeClose(in);
        }

        private void decodeHeader(BufferedReader in, Map<String, String> pre, Map<String, String> parms, Map<String, String> headers) throws ResponseException {
            try {
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                pre.put("method", st.nextToken());
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String uri = st.nextToken();
                int qmi = uri.indexOf(63);
                if (qmi >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = NanoHTTPD.this.decodePercent(uri.substring(0, qmi));
                } else {
                    uri = NanoHTTPD.this.decodePercent(uri);
                }
                if (st.hasMoreTokens()) {
                    String line = in.readLine();
                    while (line != null && line.trim().length() > 0) {
                        int p = line.indexOf(58);
                        if (p >= 0) {
                            headers.put(line.substring(0, p).trim().toLowerCase(Locale.US), line.substring(p + 1).trim());
                        }
                        line = in.readLine();
                    }
                }
                pre.put("uri", uri);
            }
            catch (IOException ioe) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
            }
        }

        private void decodeMultipartData(String boundary, ByteBuffer fbuf, BufferedReader in, Map<String, String> parms, Map<String, String> files) throws ResponseException {
            try {
                int[] bpositions = this.getBoundaryPositions(fbuf, boundary.getBytes());
                int boundarycount = 1;
                String mpline = in.readLine();
                while (mpline != null) {
                    if (!mpline.contains(boundary)) {
                        throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but next chunk does not start with boundary. Usage: GET /example/file.html");
                    }
                    ++boundarycount;
                    HashMap<String, String> item = new HashMap<String, String>();
                    mpline = in.readLine();
                    while (mpline != null && mpline.trim().length() > 0) {
                        int p = mpline.indexOf(58);
                        if (p != -1) {
                            item.put(mpline.substring(0, p).trim().toLowerCase(Locale.US), mpline.substring(p + 1).trim());
                        }
                        mpline = in.readLine();
                    }
                    if (mpline == null) continue;
                    String contentDisposition = (String)item.get("content-disposition");
                    if (contentDisposition == null) {
                        throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but no content-disposition info found. Usage: GET /example/file.html");
                    }
                    StringTokenizer st = new StringTokenizer(contentDisposition, "; ");
                    HashMap<String, String> disposition = new HashMap<String, String>();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        int p = token.indexOf(61);
                        if (p == -1) continue;
                        disposition.put(token.substring(0, p).trim().toLowerCase(Locale.US), token.substring(p + 1).trim());
                    }
                    String pname = (String)disposition.get("name");
                    pname = pname.substring(1, pname.length() - 1);
                    String value = "";
                    if (item.get("content-type") == null) {
                        while (mpline != null && !mpline.contains(boundary)) {
                            mpline = in.readLine();
                            if (mpline == null) continue;
                            int d = mpline.indexOf(boundary);
                            if (d == -1) {
                                value = value + mpline;
                                continue;
                            }
                            value = value + mpline.substring(0, d - 2);
                        }
                    } else {
                        if (boundarycount > bpositions.length) {
                            throw new ResponseException(Response.Status.INTERNAL_ERROR, "Error processing request");
                        }
                        int offset = this.stripMultipartHeaders(fbuf, bpositions[boundarycount - 2]);
                        String path = this.saveTmpFile(fbuf, offset, bpositions[boundarycount - 1] - offset - 4);
                        files.put(pname, path);
                        value = (String)disposition.get("filename");
                        value = value.substring(1, value.length() - 1);
                        while ((mpline = in.readLine()) != null && !mpline.contains(boundary)) {
                        }
                    }
                    parms.put(pname, value);
                }
            }
            catch (IOException ioe) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
            }
        }

        private int findHeaderEnd(byte[] buf, int rlen) {
            int splitbyte = 0;
            while (splitbyte + 3 < rlen) {
                if (buf[splitbyte] == 13 && buf[splitbyte + 1] == 10 && buf[splitbyte + 2] == 13 && buf[splitbyte + 3] == 10) {
                    return splitbyte + 4;
                }
                ++splitbyte;
            }
            return 0;
        }

        private int[] getBoundaryPositions(ByteBuffer b, byte[] boundary) {
            int matchcount = 0;
            int matchbyte = -1;
            ArrayList<Integer> matchbytes = new ArrayList<Integer>();
            for (int i = 0; i < b.limit(); ++i) {
                if (b.get(i) == boundary[matchcount]) {
                    if (matchcount == 0) {
                        matchbyte = i;
                    }
                    if (++matchcount != boundary.length) continue;
                    matchbytes.add(matchbyte);
                    matchcount = 0;
                    matchbyte = -1;
                    continue;
                }
                i -= matchcount;
                matchcount = 0;
                matchbyte = -1;
            }
            int[] ret = new int[matchbytes.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)matchbytes.get(i);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String saveTmpFile(ByteBuffer b, int offset, int len) {
            String path = "";
            if (len > 0) {
                FileOutputStream fileOutputStream = null;
                try {
                    TempFile tempFile = this.tempFileManager.createTempFile();
                    ByteBuffer src = b.duplicate();
                    fileOutputStream = new FileOutputStream(tempFile.getName());
                    FileChannel dest = fileOutputStream.getChannel();
                    src.position(offset).limit(offset + len);
                    dest.write(src.slice());
                    path = tempFile.getName();
                }
                catch (Exception e) {
                    try {
                        System.err.println("Error: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        NanoHTTPD.safeClose(fileOutputStream);
                        throw throwable;
                    }
                    NanoHTTPD.safeClose(fileOutputStream);
                }
                NanoHTTPD.safeClose(fileOutputStream);
            }
            return path;
        }

        private RandomAccessFile getTmpBucket() {
            try {
                TempFile tempFile = this.tempFileManager.createTempFile();
                return new RandomAccessFile(tempFile.getName(), "rw");
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                return null;
            }
        }

        private int stripMultipartHeaders(ByteBuffer b, int offset) {
            int i = offset;
            while (i < b.limit() && (b.get(i) != 13 || b.get(++i) != 10 || b.get(++i) != 13 || b.get(++i) != 10)) {
                ++i;
            }
            return i + 1;
        }

        private void decodeParms(String parms, Map<String, String> p) {
            if (parms == null) {
                this.queryParameterString = "";
                return;
            }
            this.queryParameterString = parms;
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep >= 0) {
                    p.put(NanoHTTPD.this.decodePercent(e.substring(0, sep)).trim(), NanoHTTPD.this.decodePercent(e.substring(sep + 1)));
                    continue;
                }
                p.put(NanoHTTPD.this.decodePercent(e).trim(), "");
            }
        }

        @Override
        public final Map<String, String> getParms() {
            return this.parms;
        }

        @Override
        public String getQueryParameterString() {
            return this.queryParameterString;
        }

        @Override
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Method getMethod() {
            return this.method;
        }

        @Override
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public CookieHandler getCookies() {
            return this.cookies;
        }
    }

    public static interface IHTTPSession {
        public void execute() throws IOException;

        public Map<String, String> getParms();

        public Map<String, String> getHeaders();

        public String getUri();

        public String getQueryParameterString();

        public Method getMethod();

        public InputStream getInputStream();

        public CookieHandler getCookies();

        public void parseBody(Map<String, String> var1) throws IOException, ResponseException;
    }

    private class DefaultTempFileManagerFactory
    implements TempFileManagerFactory {
        private DefaultTempFileManagerFactory() {
        }

        @Override
        public TempFileManager create() {
            return new DefaultTempFileManager();
        }
    }

    public static final class ResponseException
    extends Exception {
        private final Response.Status status;

        public ResponseException(Response.Status status, String message) {
            super(message);
            this.status = status;
        }

        public ResponseException(Response.Status status, String message, Exception e) {
            super(message, e);
            this.status = status;
        }

        public Response.Status getStatus() {
            return this.status;
        }
    }

    public static class Response {
        private Status status;
        private String mimeType;
        private InputStream data;
        private Map<String, String> header = new HashMap<String, String>();
        private Method requestMethod;
        private boolean chunkedTransfer;

        public Response(String msg) {
            this(Status.OK, NanoHTTPD.MIME_HTML, msg);
        }

        public Response(Status status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(Status status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            try {
                this.data = txt != null ? new ByteArrayInputStream(txt.getBytes("UTF-8")) : null;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }

        private void send(OutputStream outputStream) {
            String mime = this.mimeType;
            SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                if (this.status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                PrintWriter pw = new PrintWriter(outputStream);
                pw.print("HTTP/1.1 " + this.status.getDescription() + " \r\n");
                if (mime != null) {
                    pw.print("Content-Type: " + mime + "\r\n");
                }
                if (this.header == null || this.header.get("Date") == null) {
                    pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }
                if (this.header != null) {
                    for (String key : this.header.keySet()) {
                        String value = this.header.get(key);
                        pw.print(key + ": " + value + "\r\n");
                    }
                }
                pw.print("Connection: keep-alive\r\n");
                if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                    this.sendAsChunked(outputStream, pw);
                } else {
                    this.sendAsFixedLength(outputStream, pw);
                }
                outputStream.flush();
                NanoHTTPD.safeClose(this.data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void sendAsChunked(OutputStream outputStream, PrintWriter pw) throws IOException {
            int read;
            pw.print("Transfer-Encoding: chunked\r\n");
            pw.print("\r\n");
            pw.flush();
            int BUFFER_SIZE = 16384;
            byte[] CRLF = "\r\n".getBytes();
            byte[] buff = new byte[BUFFER_SIZE];
            while ((read = this.data.read(buff)) > 0) {
                outputStream.write(String.format("%x\r\n", read).getBytes());
                outputStream.write(buff, 0, read);
                outputStream.write(CRLF);
            }
            outputStream.write(String.format("0\r\n\r\n", new Object[0]).getBytes());
        }

        private void sendAsFixedLength(OutputStream outputStream, PrintWriter pw) throws IOException {
            int pending;
            pw.print("Content-Length: " + pending + "\r\n");
            pw.print("\r\n");
            pw.flush();
            if (this.requestMethod != Method.HEAD && this.data != null) {
                int read;
                int BUFFER_SIZE = 16384;
                byte[] buff = new byte[BUFFER_SIZE];
                for (pending = this.data != null ? this.data.available() : 0; pending > 0 && (read = this.data.read(buff, 0, pending > BUFFER_SIZE ? BUFFER_SIZE : pending)) > 0; pending -= read) {
                    outputStream.write(buff, 0, read);
                }
            }
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public InputStream getData() {
            return this.data;
        }

        public void setData(InputStream data) {
            this.data = data;
        }

        public Method getRequestMethod() {
            return this.requestMethod;
        }

        public void setRequestMethod(Method requestMethod) {
            this.requestMethod = requestMethod;
        }

        public void setChunkedTransfer(boolean chunkedTransfer) {
            this.chunkedTransfer = chunkedTransfer;
        }

        public static enum Status {
            OK(200, "OK"),
            CREATED(201, "Created"),
            ACCEPTED(202, "Accepted"),
            NO_CONTENT(204, "No Content"),
            PARTIAL_CONTENT(206, "Partial Content"),
            REDIRECT(301, "Moved Permanently"),
            NOT_MODIFIED(304, "Not Modified"),
            BAD_REQUEST(400, "Bad Request"),
            UNAUTHORIZED(401, "Unauthorized"),
            FORBIDDEN(403, "Forbidden"),
            NOT_FOUND(404, "Not Found"),
            METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
            RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
            INTERNAL_ERROR(500, "Internal Server Error");

            private final int requestStatus;
            private final String description;

            private Status(int requestStatus, String description) {
                this.requestStatus = requestStatus;
                this.description = description;
            }

            public int getRequestStatus() {
                return this.requestStatus;
            }

            public String getDescription() {
                return "" + this.requestStatus + " " + this.description;
            }
        }
    }

    public static class DefaultTempFile
    implements TempFile {
        private File file;
        private OutputStream fstream;

        public DefaultTempFile(String tempdir) throws IOException {
            this.file = File.createTempFile("NanoHTTPD-", "", new File(tempdir));
            this.fstream = new FileOutputStream(this.file);
        }

        @Override
        public OutputStream open() throws Exception {
            return this.fstream;
        }

        @Override
        public void delete() throws Exception {
            NanoHTTPD.safeClose(this.fstream);
            this.file.delete();
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }
    }

    public static class DefaultTempFileManager
    implements TempFileManager {
        private final String tmpdir = System.getProperty("java.io.tmpdir");
        private final List<TempFile> tempFiles = new ArrayList<TempFile>();

        @Override
        public TempFile createTempFile() throws Exception {
            DefaultTempFile tempFile = new DefaultTempFile(this.tmpdir);
            this.tempFiles.add(tempFile);
            return tempFile;
        }

        @Override
        public void clear() {
            for (TempFile file : this.tempFiles) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
            this.tempFiles.clear();
        }
    }

    public static class DefaultAsyncRunner
    implements AsyncRunner {
        private long requestCount;

        @Override
        public void exec(Runnable code) {
            ++this.requestCount;
            Thread t = new Thread(code);
            t.setDaemon(true);
            t.setName("NanoHttpd Request Processor (#" + this.requestCount + ")");
            t.start();
        }
    }

    public static interface TempFile {
        public OutputStream open() throws Exception;

        public void delete() throws Exception;

        public String getName();
    }

    public static interface TempFileManager {
        public TempFile createTempFile() throws Exception;

        public void clear();
    }

    public static interface TempFileManagerFactory {
        public TempFileManager create();
    }

    public static interface AsyncRunner {
        public void exec(Runnable var1);
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS;


        static Method lookup(String method) {
            for (Method m : Method.values()) {
                if (!m.toString().equalsIgnoreCase(method)) continue;
                return m;
            }
            return null;
        }
    }
}

