/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DateTimeRenderer
extends NumberRenderer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected final SimpleDateFormat dateFormatter;
    private long relativeStartTime = 0L;
    private static final String EMPTY = "";
    public static final String HHMMSS = "HH:mm:ss";

    public DateTimeRenderer() {
        this.dateFormatter = (SimpleDateFormat)SimpleDateFormat.getInstance();
    }

    public DateTimeRenderer(String format) {
        this.dateFormatter = new SimpleDateFormat(format);
    }

    public DateTimeRenderer(String format, long aRelativeStartTime) {
        this(format);
        TimeZone utc = TimeZone.getTimeZone("UTC");
        this.dateFormatter.setTimeZone(utc);
        this.relativeStartTime = aRelativeStartTime;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText(EMPTY);
        } else {
            if (value instanceof Double) {
                value = Math.round((Double)value);
            }
            this.setLongValue((Long)value);
        }
    }

    private void setLongValue(Long value) {
        this.setText(this.dateFormatter.format(value - this.relativeStartTime));
    }
}

