/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.gui.ButtonPanelAddCopyRemove;
import kg.apc.jmeter.jmxmon.JMXMonCollector;
import kg.apc.jmeter.jmxmon.JMXMonSampleResult;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMXMonGui
extends AbstractOverTimeVisualizer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private PowerTableModel tableModel;
    private JTable grid;
    private JTextArea errorTextArea;
    private JScrollPane errorPane;
    public static final String[] columnIdentifiers = new String[]{"Label", "URL", "Username", "Password", "Object Name", "Attribute", "Key", "Delta"};
    public static final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
    private static Object[] defaultValues = new Object[]{"", "", "", "", "", "", "", false};

    public JMXMonGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Query results");
        this.graphPanel.getGraphObject().getChartSettings().setExpendRows(true);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 13074);
    }

    @Override
    public String getWikiPage() {
        return "JMXMon";
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("JMXMon Samples Collector");
    }

    @Override
    protected JPanel getGraphPanelContainer() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerTopPanel = new JPanel(new BorderLayout());
        this.errorPane = new JScrollPane();
        this.errorPane.setMinimumSize(new Dimension(100, 50));
        this.errorPane.setPreferredSize(new Dimension(100, 50));
        this.errorTextArea = new JTextArea();
        this.errorTextArea.setForeground(Color.red);
        this.errorTextArea.setBackground(new Color(255, 255, 153));
        this.errorTextArea.setEditable(false);
        this.errorPane.setViewportView(this.errorTextArea);
        this.registerPopup();
        innerTopPanel.add(this.createSamplerPanel(), "North");
        innerTopPanel.add((Component)this.errorPane, "South");
        innerTopPanel.add(this.getFilePanel(), "Center");
        panel.add((Component)innerTopPanel, "North");
        this.errorPane.setVisible(false);
        return panel;
    }

    private void addErrorMessage(String msg, long time) {
        this.errorPane.setVisible(true);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String newLine = "";
        if (this.errorTextArea.getText().length() != 0) {
            newLine = "\n";
        }
        this.errorTextArea.setText(this.errorTextArea.getText() + newLine + formatter.format(time) + " - ERROR: " + msg);
        this.errorTextArea.setCaretPosition(this.errorTextArea.getDocument().getLength());
        this.updateGui();
    }

    public void clearErrorMessage() {
        this.errorTextArea.setText("");
        this.errorPane.setVisible(false);
    }

    private void registerPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem hideMessagesMenu = new JMenuItem("Hide Error Panel");
        hideMessagesMenu.addActionListener(new HideAction());
        popup.add(hideMessagesMenu);
        this.errorTextArea.setComponentPopupMenu(popup);
    }

    @Override
    public void clearData() {
        this.clearErrorMessage();
        super.clearData();
    }

    private Component createSamplerPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("JMX Samplers"));
        panel.setPreferredSize(new Dimension(150, 150));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        panel.add((Component)new ButtonPanelAddCopyRemove(this.grid, this.tableModel, defaultValues), "South");
        this.grid.getTableHeader().setReorderingAllowed(false);
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        this.grid.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.grid.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.grid.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.grid.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.grid.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.grid.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.grid.getColumnModel().getColumn(6).setPreferredWidth(50);
        this.grid.getColumnModel().getColumn(7).setPreferredWidth(50);
        return this.grid;
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(columnIdentifiers, columnClasses);
        this.grid.setModel((TableModel)this.tableModel);
    }

    @Override
    public TestElement createTestElement() {
        JMXMonCollector te = new JMXMonCollector();
        this.modifyTestElement((TestElement)te);
        te.setComment(JMeterPluginsUtils.getWikiLinkText(this.getWikiPage()));
        return te;
    }

    @Override
    public void modifyTestElement(TestElement te) {
        super.modifyTestElement(te);
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (te instanceof JMXMonCollector) {
            JMXMonCollector dmte = (JMXMonCollector)te;
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty(this.tableModel, "samplers");
            dmte.setData(rows);
        }
        super.configureTestElement(te);
    }

    @Override
    public void configure(TestElement te) {
        super.configure(te);
        JMXMonCollector dmte = (JMXMonCollector)te;
        JMeterProperty jmxmonValues = dmte.getSamplerSettings();
        if (!(jmxmonValues instanceof NullProperty)) {
            JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)jmxmonValues, this.tableModel, columnClasses);
        } else {
            log.warn("Received null property instead of collection");
        }
    }

    @Override
    public void add(SampleResult res) {
        if (res.isSuccessful()) {
            if (this.isSampleIncluded(res)) {
                super.add(res);
                this.addJmxMonRecord(res.getSampleLabel(), this.normalizeTime(res.getStartTime()), JMXMonSampleResult.getValue(res));
                this.updateGui(null);
            }
        } else {
            this.addErrorMessage(res.getResponseMessage(), res.getStartTime());
        }
    }

    private void addJmxMonRecord(String rowName, long time, double value) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(rowName);
        if (row == null) {
            row = this.getNewRow(this.model, 0, rowName, 0, false, false, false, true, true);
        }
        row.add(time, value);
    }

    private class HideAction
    implements ActionListener {
        private HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMXMonGui.this.errorPane.setVisible(false);
            JMXMonGui.this.updateGui();
        }
    }
}

