/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.apache.jmeter.protocol.tcp.sampler.TCPClientImpl;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class InfiniteGetTCPClientImpl
extends TCPClientImpl {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final int chunkSize = JMeterUtils.getPropDefault((String)"tcp.infiniteTCPChunkSize", (int)5120);
    private boolean isRequestSent = false;
    private int recvDataLimit = JMeterUtils.getPropDefault((String)"kg.apc.jmeter.samplers.ResultDataLimit", (int)Integer.MAX_VALUE);

    public InfiniteGetTCPClientImpl() {
        if (this.recvDataLimit < Integer.MAX_VALUE) {
            log.info("Limiting result data to " + this.recvDataLimit);
        }
    }

    public void write(OutputStream os, InputStream is) {
        if (!this.isRequestSent) {
            this.isRequestSent = true;
            try {
                super.write(os, is);
            }
            catch (Exception ex) {
                log.error("Can't send: ", (Throwable)ex);
            }
        }
    }

    public void write(OutputStream out, String string) {
        if (!this.isRequestSent) {
            this.isRequestSent = true;
            try {
                super.write(out, string);
            }
            catch (Exception ex) {
                log.error("Can't send: ", (Throwable)ex);
            }
        }
    }

    public String read(InputStream is) {
        byte[] buffer = new byte[this.chunkSize];
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        try {
            int x = is.read(buffer);
            if (x > 0) {
                if (w.size() < this.recvDataLimit) {
                    w.write(buffer, 0, x);
                }
            } else {
                log.warn("Read 0 bytes, seems the connection was closed. Closing stream");
                is.close();
            }
        }
        catch (SocketTimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedIOException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Read: " + w.size() + "\n" + w.toString());
        }
        return w.toString();
    }
}

