/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import com.squareup.picasso.Transformation;

public class ColorFilterTransformation
implements Transformation {
    private int mColor;

    public ColorFilterTransformation(int color) {
        this.mColor = color;
    }

    public Bitmap transform(Bitmap source) {
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mColor, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "ColorFilterTransformation(color=" + this.mColor + ")";
    }
}

