/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class RoundedCornersTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private int radius;
    private int margin;

    public RoundedCornersTransformation(BitmapPool pool, int radius, int margin) {
        this.radius = radius;
        this.margin = margin;
        this.mBitmapPool = pool;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        int height;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        Bitmap bitmap = this.mBitmapPool.get(width, height = source.getHeight(), Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        canvas.drawRoundRect(new RectF((float)this.margin, (float)this.margin, (float)(width - this.margin), (float)(height - this.margin)), (float)this.radius, (float)this.radius, paint);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "RoundedTransformation(radius=" + this.radius + ", margin=" + this.margin + ")";
    }
}

