/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.graphics.Bitmap;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class CropSquareTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private int mWidth;
    private int mHeight;

    public CropSquareTransformation(BitmapPool pool) {
        this.mBitmapPool = pool;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        int size = Math.min(source.getWidth(), source.getHeight());
        this.mWidth = (source.getWidth() - size) / 2;
        this.mHeight = (source.getHeight() - size) / 2;
        Bitmap.Config config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888;
        Bitmap bitmap = this.mBitmapPool.get(this.mWidth, this.mHeight, config);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((Bitmap)source, (int)this.mWidth, (int)this.mHeight, (int)size, (int)size);
        }
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "CropSquareTransformation(width=" + this.mWidth + ", height=" + this.mHeight + ")";
    }
}

