/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageSwirlFilter;

public class SwirlFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageSwirlFilter mFilter = new GPUImageSwirlFilter();
    private float mRadius;
    private float mAngle;
    private PointF mCenter;

    public SwirlFilterTransformation(Context context) {
        this.mContext = context;
        this.mCenter = new PointF();
    }

    public SwirlFilterTransformation(Context context, float radius, float angle, PointF center) {
        this.mContext = context;
        this.mRadius = radius;
        this.mAngle = angle;
        this.mCenter = center;
        this.mFilter.setRadius(this.mRadius);
        this.mFilter.setAngle(this.mAngle);
        this.mFilter.setCenter(this.mCenter);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "SwirlFilterTransformation(radius=" + this.mRadius + ",angle=" + this.mAngle + ",center=" + this.mCenter.toString() + ")";
    }
}

