/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageSepiaFilter;

public class SepiaFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageSepiaFilter mFilter = new GPUImageSepiaFilter();
    private float mIntensity;

    public SepiaFilterTransformation(Context context) {
        this.mContext = context;
    }

    public SepiaFilterTransformation(Context context, float intensity) {
        this.mContext = context;
        this.mIntensity = intensity;
        this.mFilter.setIntensity(this.mIntensity);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "SepiaFilterTransformation(intensity=" + this.mIntensity + ")";
    }
}

