/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageToonFilter;

public class ToonFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageToonFilter mFilter = new GPUImageToonFilter();
    private float mThreshold;
    private float mQuantizationLevels;

    public ToonFilterTransformation(Context context) {
        this.mContext = context;
    }

    public ToonFilterTransformation(Context context, float threshold, float quantizationLevels) {
        this.mContext = context;
        this.mThreshold = threshold;
        this.mQuantizationLevels = quantizationLevels;
        this.mFilter.setThreshold(this.mThreshold);
        this.mFilter.setQuantizationLevels(this.mQuantizationLevels);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "ToonFilterTransformation(threshold=" + this.mThreshold + ",quantizationLevels=" + this.mQuantizationLevels + ")";
    }
}

