/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="<div lang=\"ja\">PageFeedItemServiceReviewSummarySelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u767b\u9332\u3057\u305f\u30da\u30fc\u30b8\u30d5\u30a3\u30fc\u30c9\u30a2\u30a4\u30c6\u30e0\u306e\u5be9\u67fb\u6210\u7e3e\u3001\u72b6\u6cc1\u30b5\u30de\u30ea\u30fc\u3092\u53d6\u5f97\u3059\u308b\u305f\u3081\u306e\u691c\u7d22\u6761\u4ef6\u3092\u683c\u7d0d\u3057\u307e\u3059\u3002</div> <div lang=\"en\">The PageFeedItemServiceReviewSummarySelector object stores search condition to acquire the examination results of the page feed item and the situation summary.</div> ")
public class PageFeedItemServiceReviewSummarySelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="feedIds")
    @Valid
    private List<Long> feedIds = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public PageFeedItemServiceReviewSummarySelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Account ID</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public PageFeedItemServiceReviewSummarySelector feedIds(List<Long> feedIds) {
        this.feedIds = feedIds;
        return this;
    }

    public PageFeedItemServiceReviewSummarySelector addFeedIdsItem(Long feedIdsItem) {
        if (this.feedIds == null) {
            this.feedIds = new ArrayList<Long>();
        }
        this.feedIds.add(feedIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30d5\u30a3\u30fc\u30c9ID</div> <div lang=\"en\">Feed ID</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getFeedIds() {
        return this.feedIds;
    }

    public void setFeedIds(List<Long> feedIds) {
        this.feedIds = feedIds;
    }

    public PageFeedItemServiceReviewSummarySelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=10000L)
    public @Min(value=1L) @Max(value=10000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public PageFeedItemServiceReviewSummarySelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageFeedItemServiceReviewSummarySelector pageFeedItemServiceReviewSummarySelector = (PageFeedItemServiceReviewSummarySelector)o;
        return Objects.equals(this.accountId, pageFeedItemServiceReviewSummarySelector.accountId) && Objects.equals(this.feedIds, pageFeedItemServiceReviewSummarySelector.feedIds) && Objects.equals(this.numberResults, pageFeedItemServiceReviewSummarySelector.numberResults) && Objects.equals(this.startIndex, pageFeedItemServiceReviewSummarySelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.feedIds, this.numberResults, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageFeedItemServiceReviewSummarySelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    feedIds: ").append(this.toIndentedString(this.feedIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

