/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v5.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adsdisplayapi.v5.model.VideoServiceApprovalStatus;
import jp.co.yahoo.adsdisplayapi.v5.model.VideoServiceCreatedDateRange;
import jp.co.yahoo.adsdisplayapi.v5.model.VideoServiceProcessStatus;
import jp.co.yahoo.adsdisplayapi.v5.model.VideoServiceUserStatus;

@ApiModel(description="<div lang=\"ja\">VideoServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u5165\u7a3f\u6e08\u307f\u306e\u52d5\u753b\u306e\u60c5\u5831\u3092\u53d6\u5f97\u3057\u307e\u3059\u3002</div> <div lang=\"en\">The VideoServiceSelector object is a container for storing added video information and filtering condition.</div> ")
public class VideoServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-display-api-lib:0.0.12";
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="approvalStatuses")
    @Valid
    private List<VideoServiceApprovalStatus> approvalStatuses = null;
    @JsonProperty(value="mediaIds")
    @Valid
    private List<Long> mediaIds = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="processStatuses")
    @Valid
    private List<VideoServiceProcessStatus> processStatuses = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;
    @JsonProperty(value="userStatuses")
    @Valid
    private List<VideoServiceUserStatus> userStatuses = null;
    @JsonProperty(value="createdDateRange")
    private VideoServiceCreatedDateRange createdDateRange = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public VideoServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public VideoServiceSelector approvalStatuses(List<VideoServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
        return this;
    }

    public VideoServiceSelector addApprovalStatusesItem(VideoServiceApprovalStatus approvalStatusesItem) {
        if (this.approvalStatuses == null) {
            this.approvalStatuses = new ArrayList<VideoServiceApprovalStatus>();
        }
        this.approvalStatuses.add(approvalStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=4)
    public @Valid @Size(max=4) List<VideoServiceApprovalStatus> getApprovalStatuses() {
        return this.approvalStatuses;
    }

    public void setApprovalStatuses(List<VideoServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
    }

    public VideoServiceSelector mediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
        return this;
    }

    public VideoServiceSelector addMediaIdsItem(Long mediaIdsItem) {
        if (this.mediaIds == null) {
            this.mediaIds = new ArrayList<Long>();
        }
        this.mediaIds.add(mediaIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30e1\u30c7\u30a3\u30a2ID\u3067\u3059\u3002</div> <div lang=\"en\">Media ID.</div> ")
    @Size(max=500)
    public @Size(max=500) List<Long> getMediaIds() {
        return this.mediaIds;
    }

    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }

    public VideoServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=500L)
    public @Min(value=1L) @Max(value=500L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public VideoServiceSelector processStatuses(List<VideoServiceProcessStatus> processStatuses) {
        this.processStatuses = processStatuses;
        return this;
    }

    public VideoServiceSelector addProcessStatusesItem(VideoServiceProcessStatus processStatusesItem) {
        if (this.processStatuses == null) {
            this.processStatuses = new ArrayList<VideoServiceProcessStatus>();
        }
        this.processStatuses.add(processStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=3)
    public @Valid @Size(max=3) List<VideoServiceProcessStatus> getProcessStatuses() {
        return this.processStatuses;
    }

    public void setProcessStatuses(List<VideoServiceProcessStatus> processStatuses) {
        this.processStatuses = processStatuses;
    }

    public VideoServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public VideoServiceSelector userStatuses(List<VideoServiceUserStatus> userStatuses) {
        this.userStatuses = userStatuses;
        return this;
    }

    public VideoServiceSelector addUserStatusesItem(VideoServiceUserStatus userStatusesItem) {
        if (this.userStatuses == null) {
            this.userStatuses = new ArrayList<VideoServiceUserStatus>();
        }
        this.userStatuses.add(userStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=2)
    public @Valid @Size(max=2) List<VideoServiceUserStatus> getUserStatuses() {
        return this.userStatuses;
    }

    public void setUserStatuses(List<VideoServiceUserStatus> userStatuses) {
        this.userStatuses = userStatuses;
    }

    public VideoServiceSelector createdDateRange(VideoServiceCreatedDateRange createdDateRange) {
        this.createdDateRange = createdDateRange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public VideoServiceCreatedDateRange getCreatedDateRange() {
        return this.createdDateRange;
    }

    public void setCreatedDateRange(VideoServiceCreatedDateRange createdDateRange) {
        this.createdDateRange = createdDateRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoServiceSelector videoServiceSelector = (VideoServiceSelector)o;
        return Objects.equals(this.accountId, videoServiceSelector.accountId) && Objects.equals(this.approvalStatuses, videoServiceSelector.approvalStatuses) && Objects.equals(this.mediaIds, videoServiceSelector.mediaIds) && Objects.equals(this.numberResults, videoServiceSelector.numberResults) && Objects.equals(this.processStatuses, videoServiceSelector.processStatuses) && Objects.equals(this.startIndex, videoServiceSelector.startIndex) && Objects.equals(this.userStatuses, videoServiceSelector.userStatuses) && Objects.equals(this.createdDateRange, videoServiceSelector.createdDateRange);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.approvalStatuses, this.mediaIds, this.numberResults, this.processStatuses, this.startIndex, this.userStatuses, this.createdDateRange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    approvalStatuses: ").append(this.toIndentedString(this.approvalStatuses)).append("\n");
        sb.append("    mediaIds: ").append(this.toIndentedString(this.mediaIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    processStatuses: ").append(this.toIndentedString(this.processStatuses)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    userStatuses: ").append(this.toIndentedString(this.userStatuses)).append("\n");
        sb.append("    createdDateRange: ").append(this.toIndentedString(this.createdDateRange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

