/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adsdisplayapi.v6.model.AdGroupServiceBiddingValueCpcRange;
import jp.co.yahoo.adsdisplayapi.v6.model.AdGroupServiceCreatedDateRange;
import jp.co.yahoo.adsdisplayapi.v6.model.AdGroupServiceUserStatus;

@ApiModel(description="<div lang=\"ja\">AdGroupServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u6307\u5b9a\u3055\u308c\u305f\u5e83\u544a\u30b0\u30eb\u30fc\u30d7\u3092\u8868\u3057\u307e\u3059\u3002</div> <div lang=\"en\">The AdGroupServiceSelector object is a container for storing specified ad group information.</div> ")
public class AdGroupServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-display-api-lib:0.0.11";
    @JsonProperty(value="accountId")
    private Long accountId = null;
    @JsonProperty(value="adGroupIds")
    @Valid
    private List<Long> adGroupIds = null;
    @JsonProperty(value="campaignIds")
    @Valid
    private List<Long> campaignIds = null;
    @JsonProperty(value="containsLabelIdFlg")
    private Boolean containsLabelIdFlg = null;
    @JsonProperty(value="feedSetIds")
    @Valid
    private List<Long> feedSetIds = null;
    @JsonProperty(value="labelIds")
    @Valid
    private List<Long> labelIds = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;
    @JsonProperty(value="userStatuses")
    @Valid
    private List<AdGroupServiceUserStatus> userStatuses = null;
    @JsonProperty(value="createdDateRange")
    private AdGroupServiceCreatedDateRange createdDateRange = null;
    @JsonProperty(value="biddingValueCpcRange")
    private AdGroupServiceBiddingValueCpcRange biddingValueCpcRange = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public AdGroupServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Search Condition: Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AdGroupServiceSelector adGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public AdGroupServiceSelector addAdGroupIdsItem(Long adGroupIdsItem) {
        if (this.adGroupIds == null) {
            this.adGroupIds = new ArrayList<Long>();
        }
        this.adGroupIds.add(adGroupIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u5e83\u544a\u30b0\u30eb\u30fc\u30d7ID</div> <div lang=\"en\">Search Condition: Ad group ID.</div> ")
    @Size(max=500)
    public @Size(max=500) List<Long> getAdGroupIds() {
        return this.adGroupIds;
    }

    public void setAdGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
    }

    public AdGroupServiceSelector campaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public AdGroupServiceSelector addCampaignIdsItem(Long campaignIdsItem) {
        if (this.campaignIds == null) {
            this.campaignIds = new ArrayList<Long>();
        }
        this.campaignIds.add(campaignIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30ad\u30e3\u30f3\u30da\u30fc\u30f3ID</div> <div lang=\"en\">Search Condition: Campaign ID.</div> ")
    @Size(max=500)
    public @Size(max=500) List<Long> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public AdGroupServiceSelector containsLabelIdFlg(Boolean containsLabelIdFlg) {
        this.containsLabelIdFlg = containsLabelIdFlg;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30e9\u30d9\u30ebID\u53d6\u5f97\u30d5\u30e9\u30b0</div> <div lang=\"en\">Flag of contains label ID.</div> ")
    public Boolean getContainsLabelIdFlg() {
        return this.containsLabelIdFlg;
    }

    public void setContainsLabelIdFlg(Boolean containsLabelIdFlg) {
        this.containsLabelIdFlg = containsLabelIdFlg;
    }

    public AdGroupServiceSelector feedSetIds(List<Long> feedSetIds) {
        this.feedSetIds = feedSetIds;
        return this;
    }

    public AdGroupServiceSelector addFeedSetIdsItem(Long feedSetIdsItem) {
        if (this.feedSetIds == null) {
            this.feedSetIds = new ArrayList<Long>();
        }
        this.feedSetIds.add(feedSetIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30d5\u30a3\u30fc\u30c9\u30bb\u30c3\u30c8ID</div> <div lang=\"en\">Search Condition: Feed set ID.</div> ")
    @Size(max=200)
    public @Size(max=200) List<Long> getFeedSetIds() {
        return this.feedSetIds;
    }

    public void setFeedSetIds(List<Long> feedSetIds) {
        this.feedSetIds = feedSetIds;
    }

    public AdGroupServiceSelector labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public AdGroupServiceSelector addLabelIdsItem(Long labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<Long>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6 : \u30e9\u30d9\u30ebID</div> <div lang=\"en\">Search Condition: Label ID.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public AdGroupServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=10000L)
    public @Min(value=1L) @Max(value=10000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AdGroupServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public AdGroupServiceSelector userStatuses(List<AdGroupServiceUserStatus> userStatuses) {
        this.userStatuses = userStatuses;
        return this;
    }

    public AdGroupServiceSelector addUserStatusesItem(AdGroupServiceUserStatus userStatusesItem) {
        if (this.userStatuses == null) {
            this.userStatuses = new ArrayList<AdGroupServiceUserStatus>();
        }
        this.userStatuses.add(userStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=2)
    public @Valid @Size(max=2) List<AdGroupServiceUserStatus> getUserStatuses() {
        return this.userStatuses;
    }

    public void setUserStatuses(List<AdGroupServiceUserStatus> userStatuses) {
        this.userStatuses = userStatuses;
    }

    public AdGroupServiceSelector createdDateRange(AdGroupServiceCreatedDateRange createdDateRange) {
        this.createdDateRange = createdDateRange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AdGroupServiceCreatedDateRange getCreatedDateRange() {
        return this.createdDateRange;
    }

    public void setCreatedDateRange(AdGroupServiceCreatedDateRange createdDateRange) {
        this.createdDateRange = createdDateRange;
    }

    public AdGroupServiceSelector biddingValueCpcRange(AdGroupServiceBiddingValueCpcRange biddingValueCpcRange) {
        this.biddingValueCpcRange = biddingValueCpcRange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AdGroupServiceBiddingValueCpcRange getBiddingValueCpcRange() {
        return this.biddingValueCpcRange;
    }

    public void setBiddingValueCpcRange(AdGroupServiceBiddingValueCpcRange biddingValueCpcRange) {
        this.biddingValueCpcRange = biddingValueCpcRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdGroupServiceSelector adGroupServiceSelector = (AdGroupServiceSelector)o;
        return Objects.equals(this.accountId, adGroupServiceSelector.accountId) && Objects.equals(this.adGroupIds, adGroupServiceSelector.adGroupIds) && Objects.equals(this.campaignIds, adGroupServiceSelector.campaignIds) && Objects.equals(this.containsLabelIdFlg, adGroupServiceSelector.containsLabelIdFlg) && Objects.equals(this.feedSetIds, adGroupServiceSelector.feedSetIds) && Objects.equals(this.labelIds, adGroupServiceSelector.labelIds) && Objects.equals(this.numberResults, adGroupServiceSelector.numberResults) && Objects.equals(this.startIndex, adGroupServiceSelector.startIndex) && Objects.equals(this.userStatuses, adGroupServiceSelector.userStatuses) && Objects.equals(this.createdDateRange, adGroupServiceSelector.createdDateRange) && Objects.equals(this.biddingValueCpcRange, adGroupServiceSelector.biddingValueCpcRange);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.adGroupIds, this.campaignIds, this.containsLabelIdFlg, this.feedSetIds, this.labelIds, this.numberResults, this.startIndex, this.userStatuses, this.createdDateRange, this.biddingValueCpcRange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdGroupServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    adGroupIds: ").append(this.toIndentedString(this.adGroupIds)).append("\n");
        sb.append("    campaignIds: ").append(this.toIndentedString(this.campaignIds)).append("\n");
        sb.append("    containsLabelIdFlg: ").append(this.toIndentedString(this.containsLabelIdFlg)).append("\n");
        sb.append("    feedSetIds: ").append(this.toIndentedString(this.feedSetIds)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    userStatuses: ").append(this.toIndentedString(this.userStatuses)).append("\n");
        sb.append("    createdDateRange: ").append(this.toIndentedString(this.createdDateRange)).append("\n");
        sb.append("    biddingValueCpcRange: ").append(this.toIndentedString(this.biddingValueCpcRange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

